/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.gson;

import com.android.build.gradle.internal.gson.NativeLibraryValue;
import com.android.build.gradle.internal.gson.NativeToolchainValue;
import com.android.build.gradle.managed.NativeBuildConfig;
import com.android.build.gradle.managed.NativeLibrary;
import com.android.build.gradle.managed.NativeToolchain;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.Action;

public class NativeBuildConfigValue {
    Collection<File> buildFiles;
    Map<String, NativeLibraryValue> libraries;
    Map<String, NativeToolchainValue> toolchains;
    Collection<String> cFileExtensions;
    Collection<String> cppFileExtensions;

    public void copyTo(NativeBuildConfig config) {
        if (this.buildFiles != null) {
            config.getBuildFiles().addAll(this.buildFiles);
        }
        if (this.libraries != null) {
            for (final Map.Entry<String, Object> entry : this.libraries.entrySet()) {
                config.getLibraries().create(entry.getKey(), (Action)new Action<NativeLibrary>(){

                    public void execute(NativeLibrary nativeLibrary) {
                        ((NativeLibraryValue)entry.getValue()).copyTo(nativeLibrary);
                    }
                });
            }
        }
        if (this.toolchains != null) {
            for (final Map.Entry<String, Object> entry : this.toolchains.entrySet()) {
                config.getToolchains().create(entry.getKey(), (Action)new Action<NativeToolchain>(){

                    public void execute(NativeToolchain nativeToolchain) {
                        ((NativeToolchainValue)entry.getValue()).copyTo(nativeToolchain);
                    }
                });
            }
        }
        if (this.cFileExtensions != null) {
            config.getCFileExtensions().addAll(this.cFileExtensions);
        }
        if (this.cppFileExtensions != null) {
            config.getCppFileExtensions().addAll(this.cppFileExtensions);
        }
    }
}

