/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.NativeDependencyLinkage;
import java.util.Locale;
import org.gradle.api.InvalidUserDataException;

public class AndroidNativeDependencySpec {
    private final String projectPath;
    private final String libraryPath;
    private final String buildType;
    private final String productFlavor;
    private final NativeDependencyLinkage linkage;

    public AndroidNativeDependencySpec(String projectPath, String libraryPath, String buildType, String productFlavor, NativeDependencyLinkage linkage) {
        this.projectPath = projectPath;
        this.libraryPath = libraryPath;
        this.buildType = buildType;
        this.productFlavor = productFlavor;
        this.linkage = linkage;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public String getProductFlavor() {
        return this.productFlavor;
    }

    public NativeDependencyLinkage getLinkage() {
        return this.linkage;
    }

    public void validate() {
        if (this.projectPath == null && this.libraryPath == null) {
            throw new InvalidUserDataException("Native dependency must contain either project or library.");
        }
        if (this.projectPath != null && this.libraryPath != null) {
            throw new InvalidUserDataException("Native dependency cannot contain both project and library");
        }
    }

    public static class Builder {
        private String projectPath;
        private String libraryPath;
        private String buildType;
        private String productFlavor;
        NativeDependencyLinkage linkage;

        public Builder project(String value) {
            this.projectPath = value;
            return this;
        }

        public Builder library(String value) {
            this.libraryPath = value;
            return this;
        }

        public Builder buildType(String value) {
            this.buildType = value;
            return this;
        }

        public Builder productFlavor(String value) {
            this.productFlavor = value;
            return this;
        }

        public Builder linkage(String value) {
            this.linkage = NativeDependencyLinkage.valueOf(value.toUpperCase(Locale.US));
            return this;
        }

        public Builder linkage(NativeDependencyLinkage value) {
            this.linkage = value;
            return this;
        }

        public AndroidNativeDependencySpec build() {
            return new AndroidNativeDependencySpec(this.projectPath, this.libraryPath, this.buildType, this.productFlavor, this.linkage);
        }
    }
}

