/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import com.google.common.base.Strings;
import org.apache.commons.lang.ObjectUtils;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.Nullable;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.ModuleDependencySpec;
import org.gradle.platform.base.ModuleDependencySpecBuilder;

public final class DefaultModuleDependencySpec
implements ModuleDependencySpec {
    private final String group;
    private final String name;
    private final String version;

    public static String effectiveVersionFor(String version) {
        return Strings.isNullOrEmpty((String)version) ? "+" : version;
    }

    public DefaultModuleDependencySpec(String group, String name, String version) {
        if (group == null || name == null) {
            throw new IllegalDependencyNotation("A module dependency must have at least a group and a module name specified.");
        }
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public String getDisplayName() {
        return String.format("%s:%s:%s", this.getGroup(), this.getName(), DefaultModuleDependencySpec.effectiveVersionFor(this.getVersion()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleDependencySpec that = (DefaultModuleDependencySpec)o;
        return ObjectUtils.equals((Object)this.group, (Object)that.group) && ObjectUtils.equals((Object)this.name, (Object)that.name) && ObjectUtils.equals((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        int result = ObjectUtils.hashCode((Object)this.group);
        result = 31 * result + ObjectUtils.hashCode((Object)this.name);
        result = 31 * result + ObjectUtils.hashCode((Object)this.version);
        return result;
    }

    public static class Builder
    implements ModuleDependencySpecBuilder {
        private String group;
        private String module;
        private String version;

        public ModuleDependencySpecBuilder module(String name) {
            if (name != null && name.contains(":")) {
                this.setValuesFromModuleId(name);
            } else {
                this.checkNotSet("module", this.module);
                this.module = name;
            }
            return this;
        }

        private void checkNotSet(String name, String value) {
            if (value != null) {
                throw new IllegalDependencyNotation(String.format("Cannot set '%s' multiple times for module dependency.", name));
            }
        }

        private void setValuesFromModuleId(String moduleId) {
            String[] components = moduleId.split(":");
            if (components.length < 2 || components.length > 3 || Strings.isNullOrEmpty((String)components[0]) || Strings.isNullOrEmpty((String)components[1])) {
                throw this.illegalNotation(moduleId);
            }
            this.group(components[0]).module(components[1]);
            if (components.length > 2) {
                this.version(components[2]);
            }
        }

        private IllegalDependencyNotation illegalNotation(String moduleId) {
            return new IllegalDependencyNotation(String.format("'%s' is not a valid module dependency notation. Example notations: 'org.gradle:gradle-core:2.2', 'org.mockito:mockito-core'.", moduleId));
        }

        public ModuleDependencySpecBuilder group(String name) {
            this.checkNotSet("group", this.group);
            this.group = name;
            return this;
        }

        public ModuleDependencySpecBuilder version(String range) {
            this.checkNotSet("version", this.version);
            this.version = range;
            return this;
        }

        public DependencySpec build() {
            return new DefaultModuleDependencySpec(this.group, this.module, this.version);
        }
    }
}

