/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.parsing.PropertiesParser;
import com.intellij.lang.properties.parsing.PropertyListStubElementType;
import com.intellij.lang.properties.parsing.PropertyStubElementType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;

public interface PropertiesElementTypes {
    public static final PropertiesLanguage LANG = PropertiesLanguage.INSTANCE;
    public static final ILightStubFileElementType FILE = new ILightStubFileElementType(LANG){

        public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(ASTNode chameleon) {
            PsiElement psi = chameleon.getPsi();
            assert (psi != null) : "Bad chameleon: " + chameleon;
            Project project = psi.getProject();
            PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
            PsiBuilder builder = factory.createBuilder(project, chameleon);
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage());
            assert (parserDefinition != null) : this;
            PropertiesParser parser = new PropertiesParser();
            return parser.parseLight((IElementType)this, builder);
        }
    };
    public static final IStubElementType PROPERTY = new PropertyStubElementType();
    public static final IStubElementType PROPERTIES_LIST = new PropertyListStubElementType();
    public static final TokenSet PROPERTIES = TokenSet.create((IElementType[])new IElementType[]{PROPERTY});
}

