/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.run;

import com.google.gct.studio.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.studio.appengine.run.AppEngineRunConfiguration;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class AppEngineRunConfigurationSettingsEditor
extends SettingsEditor<AppEngineRunConfiguration> {
    private JTextField myServerPortField;
    private JPanel myMainPanel;
    private JComboBox myModuleComboBox;
    private JTextField myVmArgsField;
    private TextFieldWithBrowseButton myWarPathField;
    private TextFieldWithBrowseButton myAppEngineSdkField;
    private JTextField myServerAddressField;
    private JCheckBox mySynchronizeWithBuildGradleCheckBox;
    private JCheckBox myUpdateCheckCheckBox;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;

    public AppEngineRunConfigurationSettingsEditor(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.myModuleComboBox);
        this.myModuleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppEngineRunConfigurationSettingsEditor.this.updateSync();
            }
        });
        this.mySynchronizeWithBuildGradleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppEngineRunConfigurationSettingsEditor.this.updateSync();
            }
        });
        this.myAppEngineSdkField.addBrowseFolderListener("Select App Engine Sdk Root", null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myWarPathField.addBrowseFolderListener("Select Exploded War Root", null, this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    protected void updateSync() {
        boolean isSync = this.mySynchronizeWithBuildGradleCheckBox.isSelected();
        if (isSync) {
            this.syncWithBuildFileViaFacet();
        }
        this.myWarPathField.setEditable(!isSync);
        this.myServerAddressField.setEditable(!isSync);
        this.myServerPortField.setEditable(!isSync);
        this.myAppEngineSdkField.setEditable(!isSync);
        this.myVmArgsField.setEditable(!isSync);
        this.myUpdateCheckCheckBox.setEnabled(!isSync);
    }

    protected void syncWithBuildFileViaFacet() {
        AppEngineConfigurationProperties model;
        this.myServerPortField.setText("");
        this.myServerAddressField.setText("");
        this.myAppEngineSdkField.setText("");
        this.myWarPathField.setText("");
        this.myVmArgsField.setText("");
        this.myUpdateCheckCheckBox.setSelected(false);
        AppEngineGradleFacet facet = AppEngineGradleFacet.getAppEngineFacetByModule(this.myModuleSelector.getModule());
        if (facet != null && (model = ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState()) != null) {
            this.myServerPortField.setText(model.HTTP_PORT.toString());
            this.myServerAddressField.setText(model.HTTP_ADDRESS);
            this.myAppEngineSdkField.setText(model.APPENGINE_SDKROOT);
            this.myWarPathField.setText(model.WAR_DIR);
            this.myVmArgsField.setText(model.getJvmFlags());
            this.myUpdateCheckCheckBox.setSelected(model.DISABLE_UPDATE_CHECK);
        }
    }

    protected void resetEditorFrom(AppEngineRunConfiguration configuration) {
        if (configuration.getSdkPath() != null) {
            this.myAppEngineSdkField.setText(configuration.getSdkPath());
        }
        if (configuration.getWarPath() != null) {
            this.myWarPathField.setText(configuration.getWarPath());
        }
        this.myServerPortField.setText(configuration.getServerPort());
        this.myServerAddressField.setText(configuration.getServerAddress());
        this.myVmArgsField.setText(configuration.getVmArgs());
        this.myModuleSelector.reset((ModuleBasedConfiguration)configuration);
        this.mySynchronizeWithBuildGradleCheckBox.setSelected(configuration.isSyncWithGradle());
        this.myUpdateCheckCheckBox.setSelected(configuration.isDisableUpdateCheck());
        this.updateSync();
    }

    protected void applyEditorTo(AppEngineRunConfiguration configuration) throws ConfigurationException {
        this.myModuleSelector.applyTo((ModuleBasedConfiguration)configuration);
        configuration.setSdkPath(this.myAppEngineSdkField.getText());
        configuration.setServerAddress(this.myServerAddressField.getText());
        configuration.setServerPort(this.myServerPortField.getText());
        configuration.setVmArgs(this.myVmArgsField.getText());
        configuration.setWarPath(this.myWarPathField.getText());
        configuration.setSyncWithGradle(this.mySynchronizeWithBuildGradleCheckBox.isSelected());
        configuration.setDisableUpdateCheck(this.myUpdateCheckCheckBox.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/run/AppEngineRunConfigurationSettingsEditor", "createEditor"));
        }
        return jPanel;
    }

    protected void disposeEditor() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("War Path");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Server Port");
        jPanel.add((Component)jLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerPortField = jTextField3 = new JTextField();
        jTextField3.setToolTipText("Defaults to 8080");
        jPanel.add((Component)jTextField3, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("App Engine SDK");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("VM Args");
        jPanel.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVmArgsField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAppEngineSdkField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myWarPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myServerAddressField = jTextField = new JTextField();
        jTextField.setToolTipText("Defaults to \"localhost\" (i.e. 127.0.0.1)");
        jPanel.add((Component)jTextField, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Server Address");
        jPanel.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Module");
        jPanel.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModuleComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.mySynchronizeWithBuildGradleCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.run.sync.checkbox"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUpdateCheckCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.run.disable.check.updates"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/CloudToolsBundle").getString("appengine.run.disable.check.updates.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(7, 1, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

