/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.auth.Signer;
import com.amazonaws.retry.internal.AuthErrorRetryStrategy;
import com.amazonaws.retry.internal.AuthRetryParameters;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.internal.AWSS3V4Signer;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.Immutable;

@Immutable
public class S3V4AuthErrorRetryStrategy
implements AuthErrorRetryStrategy {
    private static Log log = LogFactory.getLog(AmazonS3Client.class);
    private static final String V4_REGION_WARNING = "please use region-specific endpoint to access buckets located in regions that require V4 signing.";
    private final String bucketName;
    private static final List<String> ERROR_CODES_AUTH_ERROR = new ArrayList<String>();
    private static final List<String> ERROR_MESSAGES_AUTH_ERROR;

    public S3V4AuthErrorRetryStrategy(String bucketName) {
        this.bucketName = bucketName;
    }

    public AuthRetryParameters shouldRetryWithAuthParam(Request<?> request, AmazonServiceException ase) {
        if (S3V4AuthErrorRetryStrategy.isAwsV4SigningRequiredError(request.getOriginalRequest(), ase)) {
            if (!BucketNameUtils.isDNSBucketName(this.bucketName)) {
                throw new AmazonClientException(V4_REGION_WARNING, (Throwable)ase);
            }
            AWSS3V4Signer v4Signer = new AWSS3V4Signer();
            v4Signer.setRegionName("us-east-1");
            v4Signer.setServiceName("s3");
            URI bucketEndpoint = null;
            try {
                bucketEndpoint = new URI(String.format("https://%s.s3-external-1.amazonaws.com", this.bucketName));
            }
            catch (URISyntaxException e) {
                throw new AmazonClientException("Failed to re-send the request to \"s3-external-1.amazonaws.com\". please use region-specific endpoint to access buckets located in regions that require V4 signing.", (Throwable)e);
            }
            log.warn((Object)("Attempting to re-send the request to " + bucketEndpoint.getHost() + " with AWS V4 authentication. " + "To avoid this warning in the future, " + V4_REGION_WARNING));
            return new AuthRetryParameters((Signer)v4Signer, bucketEndpoint);
        }
        return null;
    }

    private static boolean isAwsV4SigningRequiredError(AmazonWebServiceRequest originalRequest, AmazonServiceException ase) {
        String errorMsg;
        if (ase == null) {
            return false;
        }
        String errorCode = ase.getErrorCode();
        String string = errorMsg = ase.getErrorMessage() != null ? ase.getErrorMessage().trim() : null;
        if (errorMsg != null && ERROR_CODES_AUTH_ERROR.contains(errorCode)) {
            for (String possibleErrorMessage : ERROR_MESSAGES_AUTH_ERROR) {
                if (!errorMsg.contains(possibleErrorMessage)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ERROR_CODES_AUTH_ERROR.add("InvalidRequest");
        ERROR_CODES_AUTH_ERROR.add("InvalidArgument");
        ERROR_MESSAGES_AUTH_ERROR = new ArrayList<String>();
        ERROR_MESSAGES_AUTH_ERROR.add("Please use AWS4-HMAC-SHA256.");
        ERROR_MESSAGES_AUTH_ERROR.add("AWS KMS managed keys require AWS Signature Version 4.");
    }
}

