/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.rpccore;

import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Rpc {
    public static final Executor DEFAULT_EXECUTOR = MoreExecutors.sameThreadExecutor();

    public static <V> V get(ListenableFuture<V> future, long timeout, TimeUnit unit) throws RpcException, TimeoutException, ExecutionException {
        try {
            return (V)Uninterruptibles.getUninterruptibly(future, (long)timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof RpcException)) {
                throw e;
            }
            throw (RpcException)cause;
        }
    }

    public static <V> void listen(ListenableFuture<V> future, Logger log, Callback<V> callback) {
        Rpc.listen(future, DEFAULT_EXECUTOR, log, FutureController.NULL_CONTROLLER, callback);
    }

    public static <V> void listen(ListenableFuture<V> future, Executor executor, Logger log, Callback<V> callback) {
        Rpc.listen(future, executor, log, FutureController.NULL_CONTROLLER, callback);
    }

    public static <V> void listen(ListenableFuture<V> future, Logger log, FutureController controller, Callback<V> callback) {
        Rpc.listen(future, DEFAULT_EXECUTOR, log, controller, callback);
    }

    public static <V> void listen(final ListenableFuture<V> future, Executor executor, final Logger log, final FutureController controller, final Callback<V> callback) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                controller.onStart((Future)future);
                callback.onStart();
            }
        });
        future.addListener(new Runnable(){

            @Override
            public void run() {
                if (!controller.onStop((Future)future)) {
                    return;
                }
                try {
                    callback.onFinish(new Result(future));
                }
                catch (CancellationException cancellationException) {
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }, executor);
    }

    public static class Result<V> {
        private final ListenableFuture<V> mFuture;

        private Result(ListenableFuture<V> future) {
            this.mFuture = future;
        }

        public V get() throws RpcException, ExecutionException {
            try {
                return (V)Uninterruptibles.getUninterruptibly(this.mFuture);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof RpcException)) {
                    throw e;
                }
                throw (RpcException)cause;
            }
        }
    }

    public static abstract class Callback<V> {
        public void onStart() {
        }

        public abstract void onFinish(Result<V> var1) throws RpcException, ExecutionException;
    }
}

