/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.binary;

public class BitField<T extends BitField<T>> {
    protected int bits;

    public BitField(Iterable<Bit<T>> bits) {
        for (Bit<T> bit : bits) {
            this.set(bit);
        }
    }

    protected BitField(int value) {
        this.bits = value;
    }

    public boolean isSet(Bit<T> bit) {
        return (this.bits & bit.value) == bit.value;
    }

    public void set(Bit<T> bit) {
        this.bits |= bit.value;
    }

    public void clear(Bit<T> bit) {
        this.bits &= ~bit.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.bits == ((BitField)o).bits;
    }

    public int hashCode() {
        return this.bits;
    }

    public static class Bit<T extends BitField<T>> {
        public final int value;
        public final String name;

        public Bit(int value, String name) {
            this.value = value;
            this.name = name;
        }
    }
}

