/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class InsetTitleBorder
implements Border {
    private final Border myBorder;
    private final String myTitle;
    private final Icon myIcon;

    public InsetTitleBorder(String title, Icon icon, Color color) {
        this.myTitle = title;
        this.myIcon = icon;
        this.myBorder = new MatteBorder(20, 2, 2, 2, color);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.myBorder.paintBorder(c, g, x, y, width, height);
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            this.myIcon.paintIcon(c, g, 5, 2);
            g2d.setColor(Color.white);
            g2d.setFont(new Font("Sans", 1, 12));
            g2d.drawString(this.myTitle, 30, 15);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.myBorder.getBorderInsets(c);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

