/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.ValidationError;
import com.google.common.collect.Lists;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.launcher.CloudAuthenticator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class CloudTargetUtil {
    private CloudTargetUtil() {
    }

    @NotNull
    public static List<ValidationError> validate(@NotNull AndroidFacet facet, @NotNull CloudConfiguration.Kind kind, @NotNull String cloudProjectId, int cloudConfigurationId) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/google/gct/testing/android/CloudTargetUtil", "validate"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/google/gct/testing/android/CloudTargetUtil", "validate"));
        }
        if (cloudProjectId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cloudProjectId", "com/google/gct/testing/android/CloudTargetUtil", "validate"));
        }
        ArrayList errors = Lists.newArrayList();
        if (!CloudAuthenticator.isUserLoggedIn()) {
            errors.add(ValidationError.fatal((String)"Not connected to Google Cloud Platform."));
            ArrayList arrayList = errors;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudTargetUtil", "validate"));
            }
            return arrayList;
        }
        if (cloudProjectId.isEmpty()) {
            errors.add(ValidationError.fatal((String)"Cloud project not specified."));
        }
        CloudConfiguration selectedConfig = null;
        for (CloudConfiguration cloudConfiguration : CloudConfigurationHelper.getCloudConfigurations(facet, kind)) {
            if (cloudConfiguration.getId() != cloudConfigurationId) continue;
            selectedConfig = cloudConfiguration;
        }
        if (selectedConfig == null) {
            errors.add(ValidationError.fatal((String)"Cloud configuration not specified."));
            ArrayList arrayList = errors;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudTargetUtil", "validate"));
            }
            return arrayList;
        }
        if (selectedConfig.getDeviceConfigurationCount() < 1) {
            errors.add(ValidationError.fatal((String)"Selected cloud configuration is empty."));
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudTargetUtil", "validate"));
        }
        return arrayList;
    }
}

