/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.editor;

import com.google.api.client.util.Maps;
import com.google.appindexing.editor.AppIndexingVirtualFile;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.appindexing.ui.ResultPanel;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.util.Key;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppIndexingFileEditor
implements FileEditor {
    private JBScrollPane myScrollPane;
    private JPanel myRootPanel;
    private JPanel myLoadingPanel;
    private AsyncProcessIcon myLoadingIcon;
    private JPanel myLoadingMessagePanel;
    private JBLabel myLoadingMessage;
    private JPanel myResultsPanel;
    private static final Map<FetchAsGoogleTask.Status, String> STATUS_TO_TEXT = Maps.newHashMap();
    private static final Map<FetchAsGoogleTask.ErrorCode, String> ERROR_TO_TEXT = Maps.newHashMap();
    private AppIndexingVirtualFile myFile;

    public AppIndexingFileEditor(@NotNull AppIndexingVirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/google/appindexing/editor/AppIndexingFileEditor", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myScrollPane = new JBScrollPane((Component)this.myRootPanel);
        this.myFile = file;
        this.myFile.addContentChangeCallback(new Runnable(){

            @Override
            public void run() {
                AppIndexingFileEditor.this.refreshUi();
            }
        });
        this.refreshUi();
    }

    private void createUIComponents() {
        this.myLoadingIcon = new AsyncProcessIcon.Big("Fetch as Google");
    }

    private void refreshUi() {
        FetchAsGoogleTask task = this.myFile.getFetchAsGoogleTask();
        FetchAsGoogleTask.Status status = task.getStatus();
        switch (status) {
            case NOT_STARTED: 
            case BUILDING_APK: 
            case UPLOADING_APK: 
            case FETCHING_RESULT: {
                this.myLoadingMessage.setText(STATUS_TO_TEXT.get((Object)status));
                break;
            }
            case FAIL: 
            case SUCCESS: {
                ResultPanel resultPanel = status == FetchAsGoogleTask.Status.FAIL ? ResultPanel.buildFromFailedFetch(task.getCreatedTime(), this.myFile.getDeepLink(), task.getLanguage(), ERROR_TO_TEXT.get((Object)task.getErrorCode())) : ResultPanel.buildFromSuccessFetch(task.getCreatedTime(), this.myFile.getDeepLink(), task.getLanguage(), task.getFetchResponse());
                this.myResultsPanel.add(resultPanel);
                ((CardLayout)this.myRootPanel.getLayout()).show(this.myRootPanel, "results");
            }
        }
    }

    @NotNull
    public JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myScrollPane;
        if (jBScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingFileEditor", "getComponent"));
        }
        return jBScrollPane;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myScrollPane;
    }

    @NotNull
    public String getName() {
        if ("App Indexing" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingFileEditor", "getName"));
        }
        return "App Indexing";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel fileEditorStateLevel) {
        if (fileEditorStateLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorStateLevel", "com/google/appindexing/editor/AppIndexingFileEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingFileEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState fileEditorState) {
        if (fileEditorState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorState", "com/google/appindexing/editor/AppIndexingFileEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyChangeListener", "com/google/appindexing/editor/AppIndexingFileEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyChangeListener", "com/google/appindexing/editor/AppIndexingFileEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/google/appindexing/editor/AppIndexingFileEditor", "getUserData"));
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T t) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/google/appindexing/editor/AppIndexingFileEditor", "putUserData"));
        }
    }

    static {
        STATUS_TO_TEXT.put(FetchAsGoogleTask.Status.NOT_STARTED, "The task has not started yet.");
        STATUS_TO_TEXT.put(FetchAsGoogleTask.Status.BUILDING_APK, "Building APK...");
        STATUS_TO_TEXT.put(FetchAsGoogleTask.Status.UPLOADING_APK, "Uploading APK to Google App Indexing testing service...");
        STATUS_TO_TEXT.put(FetchAsGoogleTask.Status.FETCHING_RESULT, "Testing; takes about 2 minutes to complete.");
        ERROR_TO_TEXT.put(FetchAsGoogleTask.ErrorCode.UNKNOWN, "Test failed for unknown reason.");
        ERROR_TO_TEXT.put(FetchAsGoogleTask.ErrorCode.BUILD_APK_FAILED, "Build APK failed.");
        ERROR_TO_TEXT.put(FetchAsGoogleTask.ErrorCode.UPLOAD_APK_FAILED, "Upload APK failed.");
        ERROR_TO_TEXT.put(FetchAsGoogleTask.ErrorCode.FETCH_RESULT_FAILED, "Fetch App Indexing result failed.");
        ERROR_TO_TEXT.put(FetchAsGoogleTask.ErrorCode.NEED_SIGNIN, "Please sign in.");
        ERROR_TO_TEXT.put(FetchAsGoogleTask.ErrorCode.NETWORK_ERROR, "Network error, please try later.");
        ERROR_TO_TEXT.put(FetchAsGoogleTask.ErrorCode.INTENT_URL_NOT_SUPPORTED, "Intent url is not supported.");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        this.myLoadingPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, "loading");
        this.myLoadingMessagePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myLoadingMessage = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myLoadingIcon;
        jPanel2.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myResultsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, "results");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

