/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.builder.core.AaptPackageProcessBuilder;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class GenerateSplitAbiRes
extends BaseTask {
    private String applicationId;
    private int versionCode;
    private String versionName;
    private String outputBaseName;
    private Set<String> splits;
    private File outputDirectory;
    private boolean debuggable;
    private AaptOptions aaptOptions;

    @OutputFiles
    public List<File> getOutputFiles() {
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (String split : this.getSplits()) {
            outputFiles.add(this.getOutputFileForSplit(split));
        }
        return outputFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    protected void doFullTaskAction() throws IOException, InterruptedException, ProcessException {
        for (String split : this.getSplits()) {
            String resPackageFileName = this.getOutputFileForSplit(split).getAbsolutePath();
            File tmpDirectory = new File(this.getOutputDirectory(), this.getOutputBaseName());
            tmpDirectory.mkdirs();
            File tmpFile = new File(tmpDirectory, "AndroidManifest.xml");
            String versionNameToUse = this.getVersionName();
            if (versionNameToUse == null) {
                versionNameToUse = String.valueOf(this.getVersionCode());
            }
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8");
            try {
                fileWriter.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n      package=\"" + this.getApplicationId() + "\"\n" + "      android:versionCode=\"" + this.getVersionCode() + "\"\n" + "      android:versionName=\"" + versionNameToUse + "\"\n" + "      split=\"lib_" + this.getOutputBaseName() + "\">\n" + "       <uses-sdk android:minSdkVersion=\"21\"/>\n" + "</manifest> ");
                fileWriter.flush();
            }
            finally {
                fileWriter.close();
            }
            AaptPackageProcessBuilder aaptPackageCommandBuilder = new AaptPackageProcessBuilder(tmpFile, (com.android.builder.model.AaptOptions)this.getAaptOptions()).setDebuggable(this.isDebuggable()).setResPackageOutput(resPackageFileName);
            this.getBuilder().processResources(aaptPackageCommandBuilder, false, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getILogger()));
        }
    }

    private File getOutputFileForSplit(String split) {
        return new File(this.getOutputDirectory(), "resources-" + this.getOutputBaseName() + "-" + split + ".ap_");
    }

    @Input
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Input
    public int getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(int versionCode) {
        this.versionCode = versionCode;
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    @Input
    public String getOutputBaseName() {
        return this.outputBaseName;
    }

    public void setOutputBaseName(String outputBaseName) {
        this.outputBaseName = outputBaseName;
    }

    @Input
    public Set<String> getSplits() {
        return this.splits;
    }

    public void setSplits(Set<String> splits) {
        this.splits = splits;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }
}

