/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.builder.model.PackagingOptions;
import com.android.builder.signing.SignedJarBuilder;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class FileFilter
implements SignedJarBuilder.IZipEntryFilter {
    private final PackagingOptions packagingOptions;
    private final Set<String> excludes;
    private final Set<String> pickFirsts;
    private final List<SubStream> expandedFolders;

    public FileFilter(List<SubStream> expandedFolders, PackagingOptions packagingOptions) {
        this.expandedFolders = ImmutableList.copyOf(expandedFolders);
        this.packagingOptions = packagingOptions;
        this.excludes = this.packagingOptions != null ? this.packagingOptions.getExcludes() : Collections.emptySet();
        this.pickFirsts = this.packagingOptions != null ? this.packagingOptions.getPickFirsts() : Collections.emptySet();
    }

    public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
        PackagingOption packagingOption = this.getPackagingAction(archivePath);
        switch (packagingOption) {
            case EXCLUDE: {
                return false;
            }
            case PICK_FIRST: {
                List<File> allFiles = this.getAllFiles(archivePath);
                return allFiles.isEmpty();
            }
            case MERGE: 
            case NONE: {
                return true;
            }
        }
        throw new RuntimeException("Unhandled PackagingOption " + (Object)((Object)packagingOption));
    }

    void handleChanged(File outputDir, File changedFile) throws IOException {
        String archivePath = this.getArchivePath(changedFile);
        PackagingOption packagingOption = this.getPackagingAction(archivePath);
        switch (packagingOption) {
            case EXCLUDE: {
                return;
            }
            case MERGE: {
                this.mergeAll(outputDir, archivePath);
                return;
            }
            case PICK_FIRST: {
                FileFilter.copy(changedFile, outputDir, archivePath);
                return;
            }
            case NONE: {
                FileFilter.copy(changedFile, outputDir, archivePath);
            }
        }
    }

    public void handleRemoved(File outputDir, String removedFilePath) throws IOException {
        File outFile = new File(outputDir, removedFilePath);
        if (outFile.exists() && !outFile.delete()) {
            throw new IOException("Cannot delete " + outFile.getAbsolutePath());
        }
        PackagingOption itemPackagingOption = this.getPackagingAction(removedFilePath);
        switch (itemPackagingOption) {
            case PICK_FIRST: 
            case NONE: {
                Optional<File> firstPick = this.getFirstPick(removedFilePath);
                if (firstPick.isPresent()) {
                    FileFilter.copy((File)firstPick.get(), outputDir, removedFilePath);
                }
                return;
            }
            case MERGE: {
                this.mergeAll(outputDir, removedFilePath);
                return;
            }
            case EXCLUDE: {
                return;
            }
        }
        throw new RuntimeException("Unhandled package option" + (Object)((Object)itemPackagingOption));
    }

    private static void copy(File inputFile, File outputDir, String archivePath) throws IOException {
        File outputFile = new File(outputDir, archivePath);
        FileUtils.mkdirs((File)outputFile.getParentFile());
        Files.copy((File)inputFile, (File)outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeAll(File outputDir, String archivePath) throws IOException {
        File outputFile = new File(outputDir, archivePath);
        FileUtils.deleteIfExists((File)outputFile);
        FileUtils.mkdirs((File)outputFile.getParentFile());
        List<File> allFiles = this.getAllFiles(archivePath);
        if (!allFiles.isEmpty()) {
            OutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(outputFile));
                for (File file : allFiles) {
                    Files.copy((File)file, (OutputStream)os);
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    private Optional<File> getFirstPick(final String archivePath) {
        return Optional.fromNullable((Object)this.forEachExpansionFolder(new FolderAction(){

            @Override
            public File on(File folder) {
                File expandedFile = new File(folder, archivePath);
                if (expandedFile.exists()) {
                    return expandedFile;
                }
                return null;
            }
        }));
    }

    private List<File> getAllFiles(final String archivePath) {
        final ImmutableList.Builder matchingFiles = ImmutableList.builder();
        this.forEachExpansionFolder(new FolderAction(){

            @Override
            public File on(File folder) {
                File expandedFile = new File(folder, archivePath);
                if (expandedFile.exists()) {
                    matchingFiles.add((Object)expandedFile);
                }
                return null;
            }
        });
        return matchingFiles.build();
    }

    private File forEachExpansionFolder(FolderAction action) {
        for (SubStream subStream : this.expandedFolders) {
            File value;
            if (!subStream.getFolder().isDirectory() || (value = action.on(subStream.getFolder())) == null) continue;
            return value;
        }
        return null;
    }

    private File getExpansionFolder(final File expandedFile) {
        File expansionFolder = this.forEachExpansionFolder(new FolderAction(){

            @Override
            public File on(File folder) {
                return expandedFile.getAbsolutePath().startsWith(folder.getAbsolutePath()) ? folder : null;
            }
        });
        if (expansionFolder == null) {
            throw new RuntimeException("Cannot determine expansion folder for " + expandedFile + " with folders " + Joiner.on((String)",").join(this.expandedFolders));
        }
        return expansionFolder;
    }

    private String getArchivePath(File expandedFile) {
        File expansionFolder = this.getExpansionFolder(expandedFile);
        return expandedFile.getAbsolutePath().substring(expansionFolder.getAbsolutePath().length() + 1);
    }

    private PackagingOption getPackagingAction(String archivePath) {
        if (this.packagingOptions != null) {
            if (this.pickFirsts.contains(archivePath)) {
                return PackagingOption.PICK_FIRST;
            }
            if (this.packagingOptions.getMerges().contains(archivePath)) {
                return PackagingOption.MERGE;
            }
            if (this.excludes.contains(archivePath)) {
                return PackagingOption.EXCLUDE;
            }
        }
        return PackagingOption.NONE;
    }

    private static interface FolderAction {
        public File on(File var1);
    }

    public static class SubStream {
        private final File folder;
        private final String name;

        SubStream(File folder, String name) {
            this.folder = folder;
            this.name = name;
        }

        public File getFolder() {
            return this.folder;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum PackagingOption {
        NONE,
        MERGE,
        PICK_FIRST,
        EXCLUDE;

    }
}

