/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskAction;

public class DataBindingExportBuildInfoTask
extends DefaultTask {
    private LayoutXmlProcessor xmlProcessor;
    private File sdkDir;
    private File xmlOutFolder;
    private File exportClassListTo;
    private boolean printMachineReadableErrors;

    @TaskAction
    public void exportInfo() {
        this.xmlProcessor.writeInfoClass(this.getSdkDir(), this.getXmlOutFolder(), this.getExportClassListTo(), this.getLogger().isDebugEnabled(), this.isPrintMachineReadableErrors());
        Scope.assertNoError();
    }

    public LayoutXmlProcessor getXmlProcessor() {
        return this.xmlProcessor;
    }

    public void setXmlProcessor(LayoutXmlProcessor xmlProcessor) {
        this.xmlProcessor = xmlProcessor;
    }

    public File getSdkDir() {
        return this.sdkDir;
    }

    public void setSdkDir(File sdkDir) {
        this.sdkDir = sdkDir;
    }

    public File getXmlOutFolder() {
        return this.xmlOutFolder;
    }

    public void setXmlOutFolder(File xmlOutFolder) {
        this.xmlOutFolder = xmlOutFolder;
    }

    public File getExportClassListTo() {
        return this.exportClassListTo;
    }

    public void setExportClassListTo(File exportClassListTo) {
        this.exportClassListTo = exportClassListTo;
    }

    public boolean isPrintMachineReadableErrors() {
        return this.printMachineReadableErrors;
    }

    public void setPrintMachineReadableErrors(boolean printMachineReadableErrors) {
        this.printMachineReadableErrors = printMachineReadableErrors;
    }

    public static class ConfigAction
    implements TaskConfigAction<DataBindingExportBuildInfoTask> {
        private final VariantScope variantScope;
        private final boolean printMachineReadableErrors;

        public ConfigAction(VariantScope variantScope, boolean printMachineReadableErrors) {
            this.variantScope = variantScope;
            this.printMachineReadableErrors = printMachineReadableErrors;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("dataBindingExportBuildInfo");
        }

        @Override
        public Class<DataBindingExportBuildInfoTask> getType() {
            return DataBindingExportBuildInfoTask.class;
        }

        @Override
        public void execute(DataBindingExportBuildInfoTask task) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.variantScope.getVariantData();
            task.setXmlProcessor(variantData.getLayoutXmlProcessor());
            task.setSdkDir(this.variantScope.getGlobalScope().getSdkHandler().getSdkFolder());
            task.setXmlOutFolder(this.variantScope.getLayoutInfoOutputForDataBinding());
            task.setExportClassListTo(variantData.getType().isExportDataBindingClassList() ? this.variantScope.getGeneratedClassListOutputFileForDataBinding() : null);
            task.setPrintMachineReadableErrors(this.printMachineReadableErrors);
            variantData.registerJavaGeneratingTask((Task)task, this.variantScope.getClassOutputForDataBinding());
        }
    }
}

