/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiService;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"#\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u001b7!\u0011\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$\u0002+\u0004\u00055MA!\u0001E\u0006\u001b\u0005A2!G\u0002\t\r5\t\u0001T\u0002+\u0004\u0005E]Aa\u0011\u0005\t\u00015\t\u0001\u0014A)\u0004\t\u0015\u0001QB\u0001\u0003\u0002\u0011\u0007!6A\u0001"}, strings={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "FastCgiServiceKt", "parseHeaders", "", "response", "Lio/netty/handler/codec/http/HttpResponse;", "buffer", "Lio/netty/buffer/ByteBuf;", "sendBadGateway", "channel", "Lio/netty/channel/Channel;"}, moduleName="built-in-server")
public final class FastCgiServiceKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final void sendBadGateway(Channel channel) {
        try {
            if (channel.isActive()) {
                Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
            }
        }
        catch (Throwable e) {
            NettyUtil.log(e, LOG);
        }
    }

    private static final void parseHeaders(HttpResponse response, ByteBuf buffer) {
        StringBuilder builder = new StringBuilder();
        while (buffer.isReadable()) {
            byte b;
            builder.setLength(0);
            String key = null;
            boolean valueExpected = true;
            while ((b = buffer.readByte()) >= 0 && (char)b != '\n') {
                if ((char)b == '\r') continue;
                if (valueExpected && (char)b == ':') {
                    valueExpected = false;
                    key = builder.toString();
                    builder.setLength(0);
                    MessageDecoder.skipWhitespace(buffer);
                    continue;
                }
                builder.append((char)b);
            }
            if (builder.length() == 0) {
                return;
            }
            if (StringsKt.isNullOrEmpty((CharSequence)key)) continue;
            String string = key;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith((String)string, (String)"http", (boolean)true) || StringsKt.startsWith((String)key, (String)"X-Accel-", (boolean)true)) continue;
            String value = builder.toString();
            if (StringsKt.equals((String)key, (String)"status", (boolean)true)) {
                int index = StringsKt.indexOf$default((CharSequence)value, (char)' ', (int)0, (boolean)false, (int)6);
                if (index == -1) {
                    LOG.warn("Cannot parse status: " + value);
                    response.setStatus(HttpResponseStatus.OK);
                    continue;
                }
                response.setStatus(HttpResponseStatus.valueOf((int)Integer.parseInt(StringsKt.substring((String)value, (int)0, (int)index))));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"http", (boolean)false, (int)2) || StringsKt.startsWith$default((String)key, (String)"HTTP", (boolean)false, (int)2)) continue;
            response.headers().add(key, (Object)value);
        }
    }

    static {
        Logger logger = Logger.getInstance(FastCgiService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(FastCgiService::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$sendBadGateway(@NotNull Channel channel) {
        FastCgiServiceKt.sendBadGateway(channel);
    }

    public static final /* synthetic */ void access$parseHeaders(@NotNull HttpResponse response, @NotNull ByteBuf buffer) {
        FastCgiServiceKt.parseHeaders(response, buffer);
    }
}

