/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.regex.Pattern;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"5\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!$\u0007\t\u00055\t\u0001TA\r\u0004\u0011\ri\u0011\u0001g\u0002\u001a\u0007!!Q\"\u0001M\u0005)\u000e\rQ2\u0003\u0003\u0002\u0011\u0015i\u0011\u0001g\u0003\u001a\u0007!1Q\"\u0001M\u0007)\u000e\rQ\u0012\u0003\u0005\b\u001b\u0005Aj!G\u0002\t\r5\t\u0001t\u0002+\u0004\u00045E\u0001\u0002C\u0007\u00021\u001bI2\u0001\u0003\u0004\u000e\u0003a=Aka\u0001\u000e\u0014\u0011\u0001\u0001\u0012C\u0007\u00021\u001bI2\u0001\u0003\u0004\u000e\u0003aIAka\u0001\u0012\u001a\u0011\t\u0005\u0002\u0003\u0001\u000e\u000bA\tQC\u0001G\u00011\u0003A\n!U\u0002\u0002\u000b\u0001!61\u0001"}, strings={"ARRAY_DESCRIPTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "VariableViewKt", "VariableView", "Lorg/jetbrains/debugger/VariableView;", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "createNumberPresentation", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "value", "", "getClassName", "Lorg/jetbrains/debugger/values/ObjectValue;", "getObjectValueDescription", "trimFunctionDescription", "Lorg/jetbrains/debugger/values/Value;"}, moduleName="script-debugger-ui")
public final class VariableViewKt {
    private static final Pattern ARRAY_DESCRIPTION_PATTERN = Pattern.compile("^[a-zA-Z\\d]+\\[\\d+\\]$");

    @NotNull
    public static final VariableView VariableView(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
        return new VariableView(string, variable, context);
    }

    @NotNull
    public static final String getClassName(@NotNull ObjectValue value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String className = value.getClassName();
        if (StringsKt.isNullOrEmpty((CharSequence)className)) {
            string = "Object";
        } else {
            string = className;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        return string;
    }

    @NotNull
    public static final String getObjectValueDescription(@NotNull ObjectValue value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String description = value.getValueString();
        if (StringsKt.isNullOrEmpty((CharSequence)description)) {
            string = VariableViewKt.getClassName(value);
        } else {
            string = description;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        return string;
    }

    @NotNull
    public static final String trimFunctionDescription(@NotNull Value value) {
        int endIndex;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value.getValueString();
        if (string == null) {
            return "";
        }
        String presentableValue = string;
        for (endIndex = 0; endIndex < presentableValue.length() && !StringUtil.isLineBreak((char)presentableValue.charAt(endIndex)); ++endIndex) {
        }
        while (endIndex > 0 && Character.isWhitespace(presentableValue.charAt(endIndex - 1))) {
            --endIndex;
        }
        return StringsKt.substring((String)presentableValue, (int)0, (int)endIndex);
    }

    private static final XValuePresentation createNumberPresentation(String value) {
        return Intrinsics.areEqual((Object)value, (Object)"NaN") || Intrinsics.areEqual((Object)value, (Object)"Infinity") ? (XValuePresentation)new XKeywordValuePresentation(value) : (XValuePresentation)new XNumericValuePresentation(value);
    }

    @NotNull
    public static final /* synthetic */ XValuePresentation access$createNumberPresentation(@NotNull String value) {
        return VariableViewKt.createNumberPresentation(value);
    }

    public static final /* synthetic */ Pattern access$getARRAY_DESCRIPTION_PATTERN$p() {
        return ARRAY_DESCRIPTION_PATTERN;
    }
}

