/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.VariableContext;

class VariableContextWrapper
implements VariableContext {
    private final VariableContext parentContext;
    private final Scope scope;
    private final NotNullLazyValue<Promise<MemberFilter>> memberFilterPromise;

    public VariableContextWrapper(@NotNull VariableContext parentContext, @Nullable Scope scope) {
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/debugger/VariableContextWrapper", "<init>"));
        }
        this.memberFilterPromise = new AtomicNotNullLazyValue<Promise<MemberFilter>>(){

            @NotNull
            protected Promise<MemberFilter> compute() {
                Promise<MemberFilter> promise2 = VariableContextWrapper.this.parentContext.getViewSupport().getMemberFilter(VariableContextWrapper.this);
                if (promise2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableContextWrapper$1", "compute"));
                }
                return promise2;
            }
        };
        this.parentContext = parentContext;
        this.scope = scope;
    }

    @Override
    @Nullable
    public String getName() {
        return this.parentContext.getName();
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        Promise promise2 = (Promise)this.memberFilterPromise.getValue();
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableContextWrapper", "getMemberFilter"));
        }
        return promise2;
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        EvaluateContext evaluateContext2 = this.parentContext.getEvaluateContext();
        if (evaluateContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableContextWrapper", "getEvaluateContext"));
        }
        return evaluateContext2;
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        DebuggerViewSupport debuggerViewSupport = this.parentContext.getViewSupport();
        if (debuggerViewSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableContextWrapper", "getViewSupport"));
        }
        return debuggerViewSupport;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.parentContext.watchableAsEvaluationExpression();
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public VariableContext getParent() {
        return this.parentContext;
    }
}

