/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.values.ValueManager;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005AY!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\f\u0015\t\u0001bB\u0003\u0001\tMa\u0001!F\u0006\u0005\u0001!\u0005Q\u0003C\u0005\u0002\t\u0007I\u0011\u0001b\u0001\n\u0005%\tA5\u0001\r\u0002+\u0011!\t\u0001c\u0001\u0016\u0003a\u0011\u0011\u0004B\u0005\u0003\u0013\u0005!\u001b\u0001'\u0002\"\u0006E\u001b\u0011\u0001C\u0002&\u0011\u0011Y\u0001RD\u0007\u00021/I2\u0001C\b\u000e\u0003a\u0011Q5\u0003E\u0010\u001b\u0005A\u0002#G\u0002\t\b5\tA\u0004A)\u0004\u0003!\u0005R\u0005\u0002\u0003\u0003\u0011Ei\u0011\u0001\u0007\t&\u0019\u0011\u0011\u00012E\u0007\u0004\u0013\u0005!\u0019\u0001\u0007\n\u001a\u000b!\u0015RbA\u0005\u0002\t\u0007A\"#\n\u0004\u0005%!\u0019RbA\u0005\u0002\t\u0007A\"#\n\u0006\u0005\u0017!\u001dR\"\u0001M\f3\u0015A9!D\u0002\n\u0003\u0011\r\u0001\u0004BS\u000e\t-AA#\u0004\u0003\n\u0005%\t\u0001t\u0003\r\u00133\rAq\"D\u0001\u001d\u0002E\u001b\u0011\u0001#\u000b&$\u0011Q\u0001\u0002F\u0007\u0005\u0013\tI\u0011\u0001g\u0006\u0019%e\u0019\u0001bD\u0007\u00029\u0003I2\u0001C\u000b\u000e\u0003q\u0001\u0011kA\u0001\t,\u0015N\u0001BF\u0007\u00021AI2\u0001#\f\u000e\u0003q\u0001\u0011kA\u0001\t\"\u0015JAa\u0003\u0005\u0018\u001b\u0005A\u0002#\u0007\u0003\t05\u0011A\u0012\u0001\r\u0019K\u0019!1\u0002#\r\u000e\u0007%\tA1\u0001\r\u0013S9!1\n\u0003E\u0004\u001b\u0015I!!C\u0001\u001d\u00021\u0005\u0001\u0004\u0002\u000f,#\u000e\u0019QB\u0001C\u0005\u0011\u0015I#\u0002B&\t\u0011\u0017i\u0011\u0001\b\u0001\u001dWE\u001b1!\u0004\u0002\u0005\r!5\u0011&\u0004\u0003D\u0011!9Q\u0002B\u0005\u0003\u0013\u0005a\u0002\u0001g\u0004R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0011!E\u0011&\u0003\u0003S\u0011!IQ\"\u0001M\n#\u000e\u0019QB\u0001\u0003\u000b\u0011+I+\u0002B&I\u0003!YQ\"\u0001M\f#\u000e!Q\u0001A\u0007\u0003\t-AA\"\u000b\t\u0005\u0005\"AI\"D\u0004\n\u000b%!\u0011BA\u0005\u000217AR\u0002g\u0004R\u0007\u0011)\u0001!\u0004\u0002\u0005\u001d!E\u0001"}, strings={"Lorg/jetbrains/debugger/SuspendContextManagerBase;", "T", "Lorg/jetbrains/debugger/SuspendContextBase;", "CALL_FRAME", "Lorg/jetbrains/debugger/CallFrame;", "Lorg/jetbrains/debugger/SuspendContextManager;", "()V", "context", "Lorg/jetbrains/debugger/SuspendContext;", "getContext", "()Lorg/jetbrains/debugger/SuspendContext;", "contextOrFail", "getContextOrFail", "()Lorg/jetbrains/debugger/SuspendContextBase;", "contextRef", "Ljava/util/concurrent/atomic/AtomicReference;", "getContextRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "debugListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "isRestartFrameSupported", "", "()Z", "suspendCallback", "Lorg/jetbrains/concurrency/AsyncPromise;", "Ljava/lang/Void;", "getSuspendCallback", "canRestartFrame", "callFrame", "contextDismissed", "", "(Lorg/jetbrains/debugger/SuspendContextBase;)V", "dismissContext", "dismissContextOnDone", "Lorg/jetbrains/concurrency/Promise;", "promise", "doSuspend", "isContextObsolete", "restartFrame", "(Lorg/jetbrains/debugger/CallFrame;)Lorg/jetbrains/concurrency/Promise;", "currentContext", "(Lorg/jetbrains/debugger/CallFrame;Lorg/jetbrains/debugger/SuspendContextBase;)Lorg/jetbrains/concurrency/Promise;", "setContext", "newContext", "setOverlayMessage", "message", "", "suspend"}, moduleName="script-debugger-backend")
public abstract class SuspendContextManagerBase<T extends SuspendContextBase<?, ?, CALL_FRAME>, CALL_FRAME extends CallFrame>
implements SuspendContextManager<CALL_FRAME> {
    @NotNull
    private final AtomicReference<T> contextRef = new AtomicReference();
    @NotNull
    private final AtomicReference<AsyncPromise<Void>> suspendCallback = new AtomicReference();
    private final boolean isRestartFrameSupported = false;

    @NotNull
    public final AtomicReference<T> getContextRef() {
        return this.contextRef;
    }

    @NotNull
    protected final AtomicReference<AsyncPromise<Void>> getSuspendCallback() {
        return this.suspendCallback;
    }

    @NotNull
    protected abstract DebugEventListener getDebugListener();

    public final void setContext(@NotNull T newContext) {
        Intrinsics.checkParameterIsNotNull(newContext, (String)"newContext");
        if (!this.contextRef.compareAndSet(null, newContext)) {
            throw (Throwable)new IllegalStateException("Attempt to set context, but current suspend context is already exists");
        }
    }

    protected final void dismissContext() {
        SuspendContextBase context = (SuspendContextBase)this.contextRef.get();
        if (context != null) {
            this.contextDismissed(context);
        }
    }

    @NotNull
    protected final Promise<?> dismissContextOnDone(@NotNull Promise<?> promise2) {
        Intrinsics.checkParameterIsNotNull(promise2, (String)"promise");
        SuspendContext context = this.getContextOrFail();
        Promise<?> promise3 = promise2;
        if (promise3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
        }
        promise3.done(new Consumer<? super T>(this, (SuspendContextBase)context){
            final /* synthetic */ SuspendContextManagerBase this$0;
            final /* synthetic */ SuspendContextBase $context;

            public final void consume(@Nullable Object it) {
                this.this$0.contextDismissed(this.$context);
            }
            {
                this.this$0 = suspendContextManagerBase;
                this.$context = suspendContextBase;
            }
        });
        return promise2;
    }

    public final void contextDismissed(@NotNull T context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (!this.contextRef.compareAndSet(context, null)) {
            throw (Throwable)new IllegalStateException("Expected " + context + ", but another suspend context exists");
        }
        ((ValueManager)((SuspendContextBase)context).getValueManager()).markObsolete();
        this.getDebugListener().resumed();
    }

    @Override
    @Nullable
    public SuspendContext<CALL_FRAME> getContext() {
        return (SuspendContext)this.contextRef.get();
    }

    @NotNull
    public T getContextOrFail() {
        SuspendContextBase suspendContextBase = (SuspendContextBase)this.contextRef.get();
        if (suspendContextBase == null) {
            throw (Throwable)new IllegalStateException("No current suspend context");
        }
        return (T)suspendContextBase;
    }

    @Override
    @NotNull
    public Promise<?> suspend() {
        AsyncPromise<Void> callback = this.suspendCallback.get();
        if (callback != null) {
            return (Promise)callback;
        }
        return this.getContext() != null ? PromiseKt.resolvedPromise() : this.doSuspend();
    }

    @NotNull
    protected abstract Promise<?> doSuspend();

    @Override
    public boolean isContextObsolete(@NotNull SuspendContext<?> context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        return this.getContext() != context;
    }

    @Override
    public void setOverlayMessage(@Nullable String message) {
    }

    @Override
    @NotNull
    public Promise<Boolean> restartFrame(@NotNull CALL_FRAME callFrame) {
        Intrinsics.checkParameterIsNotNull(callFrame, (String)"callFrame");
        return this.restartFrame(callFrame, this.getContextOrFail());
    }

    @NotNull
    protected Promise<Boolean> restartFrame(@NotNull CALL_FRAME callFrame, @NotNull T currentContext) {
        Intrinsics.checkParameterIsNotNull(callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull(currentContext, (String)"currentContext");
        return PromiseKt.rejectedPromise("Unsupported");
    }

    @Override
    public boolean canRestartFrame(@NotNull CallFrame callFrame) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        return false;
    }

    @Override
    public boolean isRestartFrameSupported() {
        return this.isRestartFrameSupported;
    }
}

