/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.surroundWith;

import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.surroundWith.GroupSurrounder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new GroupSurrounder("Capturing Group (pattern)", "("), new GroupSurrounder("Non-Capturing Group (?:pattern)", "(?:")};

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
        PsiElement[] psiElementArray = this.findElementsInRange(file2, startOffset, endOffset);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/surroundWith/SimpleSurroundDescriptor", "getElementsToSurround"));
        }
        return psiElementArray;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        if (SURROUNDERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/surroundWith/SimpleSurroundDescriptor", "getSurrounders"));
        }
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }

    private PsiElement[] findElementsInRange(PsiFile file2, int startOffset, int endOffset) {
        RegExpPattern pattern;
        PsiElement element1 = file2.findElementAt(startOffset);
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
        }
        if ((pattern = SimpleSurroundDescriptor.findElementAtStrict(file2, startOffset, endOffset, RegExpPattern.class)) != null) {
            return new RegExpElement[]{pattern};
        }
        RegExpBranch branch = SimpleSurroundDescriptor.findElementAtStrict(file2, startOffset, endOffset, RegExpBranch.class);
        if (branch != null) {
            return new RegExpElement[]{branch};
        }
        ArrayList<PsiElement> atoms = new ArrayList<PsiElement>();
        RegExpAtom atom = (RegExpAtom)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, RegExpAtom.class);
        while (atom != null) {
            atoms.add(atom);
            startOffset = atom.getTextRange().getEndOffset();
            element1 = file2.findElementAt(startOffset);
            if (element1 instanceof PsiWhiteSpace) {
                startOffset = element1.getTextRange().getEndOffset();
                atoms.add(element1);
            }
            atom = (RegExpAtom)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, RegExpAtom.class);
        }
        if (startOffset == endOffset && atoms.size() > 0) {
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(atoms);
            if (atoms.size() == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements) == elements[0].getParent()) {
                return elements;
            }
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    private static <T extends RegExpElement> T findElementAtStrict(PsiFile file2, int startOffset, int endOffset, Class<T> clazz) {
        RegExpElement element = (RegExpElement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, clazz);
        if (element == null || element.getTextRange().getEndOffset() < endOffset) {
            return null;
        }
        return (T)element;
    }
}

