/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.options.BaseConfigurableWithChangeSupport;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.intellij.images.ImagesBundle;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.impl.OptionsUIForm;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionsConfigurabe
extends BaseConfigurableWithChangeSupport
implements SearchableConfigurable,
PropertyChangeListener {
    private static final String DISPLAY_NAME = ImagesBundle.message("settings.page.name", new Object[0]);
    private OptionsUIForm uiForm;

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "preferences.images";
    }

    public JComponent createComponent() {
        if (this.uiForm == null) {
            this.uiForm = new OptionsUIForm();
            Options options = OptionsManager.getInstance().getOptions();
            options.addPropertyChangeListener(this);
            this.uiForm.getOptions().inject(options);
            this.uiForm.updateUI();
            this.uiForm.getOptions().addPropertyChangeListener(this);
            this.setModified(false);
        }
        return this.uiForm.getContentPane();
    }

    public void apply() {
        if (this.uiForm != null) {
            Options options = OptionsManager.getInstance().getOptions();
            options.inject(this.uiForm.getOptions());
        }
    }

    public void reset() {
        if (this.uiForm != null) {
            Options options = OptionsManager.getInstance().getOptions();
            this.uiForm.getOptions().inject(options);
            this.uiForm.updateUI();
        }
    }

    public void disposeUIResources() {
        if (this.uiForm != null) {
            Options options = OptionsManager.getInstance().getOptions();
            options.removePropertyChangeListener(this);
            this.uiForm.getOptions().removePropertyChangeListener(this);
            this.uiForm = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Options uiOptions;
        Options options = OptionsManager.getInstance().getOptions();
        this.setModified(!options.equals(uiOptions = this.uiForm.getOptions()));
    }

    public static void show(Project project) {
        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
        util.editConfigurable(project, (Configurable)new OptionsConfigurabe());
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("Images" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/options/impl/OptionsConfigurabe", "getId"));
        }
        return "Images";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }
}

