/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.shift;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.shift.ShiftUtils;

class MultiplyByPowerOfTwoPredicate
implements PsiElementPredicate {
    MultiplyByPowerOfTwoPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (element instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression = (PsiBinaryExpression)element;
            return MultiplyByPowerOfTwoPredicate.binaryExpressionIsMultiplyByPowerOfTwo(expression);
        }
        if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression expression = (PsiAssignmentExpression)element;
            return MultiplyByPowerOfTwoPredicate.assignmentExpressionIsMultiplyByPowerOfTwo(expression);
        }
        return false;
    }

    private static boolean assignmentExpressionIsMultiplyByPowerOfTwo(PsiAssignmentExpression expression) {
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.ASTERISKEQ) && !tokenType.equals(JavaTokenType.DIVEQ)) {
            return false;
        }
        PsiExpression lhs = expression.getLExpression();
        PsiType lhsType = lhs.getType();
        if (lhsType == null) {
            return false;
        }
        if (!ShiftUtils.isIntegral(lhsType)) {
            return false;
        }
        PsiExpression rhs = expression.getRExpression();
        if (rhs == null) {
            return false;
        }
        return ShiftUtils.isPowerOfTwo(rhs);
    }

    private static boolean binaryExpressionIsMultiplyByPowerOfTwo(PsiBinaryExpression expression) {
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.ASTERISK) && !tokenType.equals(JavaTokenType.DIV)) {
            return false;
        }
        PsiExpression lhs = expression.getLOperand();
        PsiType lhsType = lhs.getType();
        if (lhsType == null) {
            return false;
        }
        if (!ShiftUtils.isIntegral(lhsType)) {
            return false;
        }
        PsiExpression rhs = expression.getROperand();
        if (rhs == null) {
            return false;
        }
        return ShiftUtils.isPowerOfTwo(rhs);
    }
}

