/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.parenthesis;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.PsiElementPredicate;

class UnnecessaryParenthesesPredicate
implements PsiElementPredicate {
    UnnecessaryParenthesesPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (element instanceof PsiParameterList) {
            PsiParameterList parameterList = (PsiParameterList)element;
            PsiElement parent = element.getParent();
            if (parent instanceof PsiLambdaExpression && parameterList.getParametersCount() == 1) {
                PsiParameter parameter = parameterList.getParameters()[0];
                return parameter.getTypeElement() == null && element.getFirstChild() != parameter && element.getLastChild() != parameter;
            }
        }
        if (!(element instanceof PsiParenthesizedExpression)) {
            return false;
        }
        PsiParenthesizedExpression expression = (PsiParenthesizedExpression)element;
        return !ParenthesesUtils.areParenthesesNeeded(expression, false);
    }
}

