/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceConditionalWithBooleanExpressionIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof PsiConditionalExpression)) {
                    return false;
                }
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
                PsiType type = conditionalExpression.getType();
                return PsiType.BOOLEAN.equals((Object)type) || type != null && type.equalsToText("java.lang.Boolean");
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/conditional/ReplaceConditionalWithBooleanExpressionIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/conditional/ReplaceConditionalWithBooleanExpressionIntention", "processIntention"));
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
        PsiExpression condition = conditionalExpression.getCondition();
        String replacementText = condition.getText() + "&&" + ReplaceConditionalWithBooleanExpressionIntention.getText(conditionalExpression.getThenExpression()) + "||" + BoolUtils.getNegatedExpressionText(condition, 13) + "&&" + ReplaceConditionalWithBooleanExpressionIntention.getText(conditionalExpression.getElseExpression());
        PsiReplacementUtil.replaceExpression((PsiExpression)element, replacementText);
    }

    private static String getText(PsiExpression expression) {
        if (ParenthesesUtils.getPrecedence(expression) > 13) {
            return '(' + expression.getText() + ')';
        }
        return expression.getText();
    }
}

