/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.Nullable;

class CallSequencePredicate
implements PsiElementPredicate {
    CallSequencePredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiStatement statement = (PsiStatement)element;
        PsiStatement nextSibling = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        if (nextSibling == null) {
            return false;
        }
        PsiVariable variable1 = CallSequencePredicate.getVariable(statement);
        if (variable1 == null) {
            return false;
        }
        PsiVariable variable2 = CallSequencePredicate.getVariable(nextSibling);
        return variable1.equals(variable2);
    }

    @Nullable
    private static PsiVariable getVariable(PsiStatement statement) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        return CallSequencePredicate.getVariable(methodCallExpression);
    }

    @Nullable
    private static PsiVariable getVariable(PsiMethodCallExpression methodCallExpression) {
        PsiType type = methodCallExpression.getType();
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (!aClass.equals(containingClass)) {
            return null;
        }
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)qualifierExpression;
            return CallSequencePredicate.getVariable(expression);
        }
        if (!(qualifierExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return null;
        }
        return (PsiVariable)target;
    }
}

