/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryEnumModifierInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.enum.modifier.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryEnumModifierInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiElement parent = (PsiElement)infos[1];
        if (parent instanceof PsiMethod) {
            String string = InspectionGadgetsBundle.message("unnecessary.enum.modifier.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryEnumModifierInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.enum.modifier.problem.descriptor1", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryEnumModifierInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryEnumModifierVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryEnumModifierFix((PsiElement)infos[0]);
    }

    private static class UnnecessaryEnumModifierVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryEnumModifierVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement[] children2;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/style/UnnecessaryEnumModifierInspection$UnnecessaryEnumModifierVisitor", "visitClass"));
            }
            if (!(aClass.isEnum() && ClassUtils.isInnerClass(aClass) && aClass.hasModifierProperty("static"))) {
                return;
            }
            PsiModifierList modifiers = aClass.getModifierList();
            if (modifiers == null) {
                return;
            }
            for (PsiElement child : children2 = modifiers.getChildren()) {
                String text = child.getText();
                if (!"static".equals(text)) continue;
                this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{child, aClass});
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiElement[] children2;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/style/UnnecessaryEnumModifierInspection$UnnecessaryEnumModifierVisitor", "visitMethod"));
            }
            if (!method.isConstructor() || !method.hasModifierProperty("private")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || !aClass.isEnum()) {
                return;
            }
            PsiModifierList modifiers = method.getModifierList();
            for (PsiElement child : children2 = modifiers.getChildren()) {
                String text = child.getText();
                if (!"private".equals(text)) continue;
                this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{child, method});
            }
        }
    }

    private static class UnnecessaryEnumModifierFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private UnnecessaryEnumModifierFix(PsiElement modifier) {
            this.m_name = InspectionGadgetsBundle.message("smth.unnecessary.remove.quickfix", modifier.getText());
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryEnumModifierInspection$UnnecessaryEnumModifierFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove unnecessary modifiers" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryEnumModifierInspection$UnnecessaryEnumModifierFix", "getFamilyName"));
            }
            return "Remove unnecessary modifiers";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiModifierList modifierList = element instanceof PsiModifierList ? (PsiModifierList)element : (PsiModifierList)element.getParent();
            assert (modifierList != null);
            if (modifierList.getParent() instanceof PsiClass) {
                modifierList.setModifierProperty("static", false);
            } else {
                modifierList.setModifierProperty("private", false);
            }
        }
    }
}

