/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForCanBeForeachInspectionBase
extends BaseInspection {
    public boolean REPORT_INDEXED_LOOP = false;
    public boolean ignoreUntypedCollections;

    static boolean isIndexedListLoopStatement(PsiForStatement forStatement, boolean ignoreUntypedCollections) {
        PsiElement secondDeclaredElement;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration.getDeclaredElements();
        if (declaredElements.length == 1) {
            secondDeclaredElement = null;
        } else if (declaredElements.length == 2) {
            secondDeclaredElement = declaredElements[1];
        } else {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(initialValue);
        if (!(constant instanceof Number)) {
            return false;
        }
        Number number = (Number)constant;
        if (number.intValue() != 0) {
            return false;
        }
        PsiExpression condition = forStatement.getCondition();
        Holder collectionHolder = ForCanBeForeachInspectionBase.getCollectionFromSizeComparison(condition, indexVariable, secondDeclaredElement);
        if (collectionHolder == null) {
            return false;
        }
        PsiStatement update = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update)) {
            return false;
        }
        PsiStatement body = forStatement.getBody();
        if (!ForCanBeForeachInspectionBase.isIndexVariableOnlyUsedAsListIndex(collectionHolder, indexVariable, body)) {
            return false;
        }
        if (collectionHolder != Holder.DUMMY) {
            PsiVariable collection = collectionHolder.getVariable();
            PsiClassType collectionType = (PsiClassType)collection.getType();
            PsiType[] parameters = collectionType.getParameters();
            if (ignoreUntypedCollections && parameters.length == 0) {
                return false;
            }
            return !VariableAccessUtils.variableIsAssigned(collection, (PsiElement)body);
        }
        return true;
    }

    static boolean isArrayLoopStatement(PsiForStatement forStatement) {
        PsiElement secondDeclaredElement;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration.getDeclaredElements();
        if (declaredElements.length == 1) {
            secondDeclaredElement = null;
        } else if (declaredElements.length == 2) {
            secondDeclaredElement = declaredElements[1];
        } else {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(initialValue);
        if (!(constant instanceof Integer)) {
            return false;
        }
        Integer integer = (Integer)constant;
        if (integer != 0) {
            return false;
        }
        PsiStatement update = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update)) {
            return false;
        }
        PsiExpression condition = forStatement.getCondition();
        PsiReferenceExpression arrayReference = ForCanBeForeachInspectionBase.getVariableReferenceFromCondition(condition, indexVariable, secondDeclaredElement);
        if (arrayReference == null) {
            return false;
        }
        if (!(arrayReference.getType() instanceof PsiArrayType)) {
            return false;
        }
        PsiElement element = arrayReference.resolve();
        if (!(element instanceof PsiVariable)) {
            return false;
        }
        PsiVariable arrayVariable = (PsiVariable)element;
        PsiStatement body = forStatement.getBody();
        return body == null || ForCanBeForeachInspectionBase.isIndexVariableOnlyUsedAsIndex(arrayVariable, indexVariable, body) && !VariableAccessUtils.variableIsAssigned(arrayVariable, (PsiElement)body) && !VariableAccessUtils.arrayContentsAreAssigned(arrayVariable, (PsiElement)body);
    }

    private static boolean isIndexVariableOnlyUsedAsIndex(@NotNull PsiVariable arrayVariable, @NotNull PsiVariable indexVariable, @Nullable PsiStatement body) {
        if (arrayVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayVariable", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "isIndexVariableOnlyUsedAsIndex"));
        }
        if (indexVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexVariable", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "isIndexVariableOnlyUsedAsIndex"));
        }
        if (body == null) {
            return true;
        }
        VariableOnlyUsedAsIndexVisitor visitor = new VariableOnlyUsedAsIndexVisitor(arrayVariable, indexVariable);
        body.accept((PsiElementVisitor)visitor);
        return visitor.isIndexVariableUsedOnlyAsIndex();
    }

    private static boolean isIndexVariableOnlyUsedAsListIndex(Holder collectionHolder, PsiVariable indexVariable, PsiStatement body) {
        if (body == null) {
            return true;
        }
        VariableOnlyUsedAsListIndexVisitor visitor = new VariableOnlyUsedAsListIndexVisitor(collectionHolder, indexVariable);
        body.accept((PsiElementVisitor)visitor);
        return visitor.isIndexVariableUsedOnlyAsIndex();
    }

    static boolean isCollectionLoopStatement(PsiForStatement forStatement, boolean ignoreUntypedCollections) {
        PsiClass qualifierClass;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator", "java.util.ListIterator")) {
            return false;
        }
        PsiExpression initialValue = variable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        if (!(initialValue instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
        PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
        String initialCallName = initialMethodExpression.getReferenceName();
        if (!"iterator".equals(initialCallName) && !"listIterator".equals(initialCallName)) {
            return false;
        }
        PsiExpressionList argumentList = initialCall.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 0) {
            return false;
        }
        PsiExpression qualifier = initialMethodExpression.getQualifierExpression();
        if (qualifier == null) {
            PsiClassType type;
            PsiType[] parameters;
            qualifierClass = ClassUtils.getContainingClass((PsiElement)initialMethodExpression);
            if (ignoreUntypedCollections && (parameters = (type = (PsiClassType)variable.getType()).getParameters()).length == 0) {
                return false;
            }
        } else {
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)qualifierType;
            qualifierClass = classType.resolve();
            if (ignoreUntypedCollections) {
                PsiClassType type = (PsiClassType)variable.getType();
                PsiType[] parameters = type.getParameters();
                PsiType[] parameters1 = classType.getParameters();
                if (parameters.length == 0 && parameters1.length == 0) {
                    return false;
                }
            }
        }
        if (qualifierClass == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.lang.Iterable") && !InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.util.Collection")) {
            return false;
        }
        PsiExpression condition = forStatement.getCondition();
        if (!ForCanBeForeachInspectionBase.isHasNext(condition, variable)) {
            return false;
        }
        PsiStatement update = forStatement.getUpdate();
        if (update != null && !(update instanceof PsiEmptyStatement)) {
            return false;
        }
        PsiStatement body = forStatement.getBody();
        if (body == null) {
            return false;
        }
        if (ForCanBeForeachInspectionBase.calculateCallsToIteratorNext(variable, body) != 1) {
            return false;
        }
        if (ForCanBeForeachInspectionBase.isIteratorMethodCalled(variable, body)) {
            return false;
        }
        return !VariableAccessUtils.variableIsReturned(variable, (PsiElement)body) && !VariableAccessUtils.variableIsAssigned(variable, (PsiElement)body) && !VariableAccessUtils.variableIsPassedAsMethodArgument(variable, (PsiElement)body);
    }

    private static int calculateCallsToIteratorNext(PsiVariable iterator, PsiStatement body) {
        if (body == null) {
            return 0;
        }
        NumCallsToIteratorNextVisitor visitor = new NumCallsToIteratorNextVisitor(iterator);
        body.accept((PsiElementVisitor)visitor);
        return visitor.getNumCallsToIteratorNext();
    }

    public static boolean isIteratorMethodCalled(PsiVariable iterator, PsiStatement body) {
        IteratorMethodCallVisitor visitor = new IteratorMethodCallVisitor(iterator);
        body.accept((PsiElementVisitor)visitor);
        return visitor.isMethodCalled();
    }

    private static boolean isHasNext(PsiExpression condition, PsiVariable iterator) {
        if (!(condition instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)condition;
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 0) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"hasNext".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return true;
        }
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement target = referenceExpression.resolve();
        return iterator.equals(target);
    }

    @Nullable
    private static PsiReferenceExpression getVariableReferenceFromCondition(PsiExpression condition, PsiVariable variable, PsiElement secondDeclaredElement) {
        PsiExpression qualifierExpression;
        PsiReferenceExpression referenceExpression;
        if (!((condition = ParenthesesUtils.stripParentheses(condition)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
        PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
        if (rhs == null) {
            return null;
        }
        if (tokenType.equals(JavaTokenType.LT)) {
            if (!VariableAccessUtils.evaluatesToVariable(lhs, variable) || !(rhs instanceof PsiReferenceExpression)) {
                return null;
            }
            referenceExpression = (PsiReferenceExpression)rhs;
        } else if (tokenType.equals(JavaTokenType.GT)) {
            if (!VariableAccessUtils.evaluatesToVariable(rhs, variable) || !(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            referenceExpression = (PsiReferenceExpression)lhs;
        } else {
            return null;
        }
        if (!ForCanBeForeachInspectionBase.expressionIsArrayLengthLookup((PsiExpression)referenceExpression)) {
            PsiElement target = referenceExpression.resolve();
            if (secondDeclaredElement != null && !secondDeclaredElement.equals(target)) {
                return null;
            }
            if (target instanceof PsiVariable) {
                PsiVariable maxVariable = (PsiVariable)target;
                PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)maxVariable, PsiCodeBlock.class);
                if (context == null) {
                    return null;
                }
                if (VariableAccessUtils.variableIsAssigned(maxVariable, (PsiElement)context)) {
                    return null;
                }
                PsiExpression expression = ParenthesesUtils.stripParentheses(maxVariable.getInitializer());
                if (!(expression instanceof PsiReferenceExpression)) {
                    return null;
                }
                referenceExpression = (PsiReferenceExpression)expression;
                if (!ForCanBeForeachInspectionBase.expressionIsArrayLengthLookup((PsiExpression)referenceExpression)) {
                    return null;
                }
            }
        } else if (secondDeclaredElement != null) {
            return null;
        }
        if ((qualifierExpression = referenceExpression.getQualifierExpression()) instanceof PsiReferenceExpression) {
            return (PsiReferenceExpression)qualifierExpression;
        }
        if (qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression || qualifierExpression == null) {
            return referenceExpression;
        }
        return null;
    }

    @Nullable
    private static Holder getCollectionFromSizeComparison(PsiExpression condition, PsiVariable variable, PsiElement secondDeclaredElement) {
        if (!((condition = ParenthesesUtils.stripParentheses(condition)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        PsiExpression rhs = binaryExpression.getROperand();
        PsiExpression lhs = binaryExpression.getLOperand();
        if (tokenType.equals(JavaTokenType.LT)) {
            if (!VariableAccessUtils.evaluatesToVariable(lhs, variable)) {
                return null;
            }
            return ForCanBeForeachInspectionBase.getCollectionFromListMethodCall(rhs, "size", secondDeclaredElement);
        }
        if (tokenType.equals(JavaTokenType.GT)) {
            if (!VariableAccessUtils.evaluatesToVariable(rhs, variable)) {
                return null;
            }
            return ForCanBeForeachInspectionBase.getCollectionFromListMethodCall(lhs, "size", secondDeclaredElement);
        }
        return null;
    }

    static boolean expressionIsListGetLookup(PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression reference = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = reference.getMethodExpression();
        PsiElement resolved = methodExpression.resolve();
        if (!(resolved instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)resolved;
        if (!"get".equals(method.getName())) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.List");
    }

    @Nullable
    private static Holder getCollectionFromListMethodCall(PsiExpression expression, String methodName, PsiElement secondDeclaredElement) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (secondDeclaredElement != null && !secondDeclaredElement.equals(target)) {
                return null;
            }
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)target;
            PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (context == null) {
                return null;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)context)) {
                return null;
            }
            expression = ParenthesesUtils.stripParentheses(variable.getInitializer());
        } else if (secondDeclaredElement != null) {
            return null;
        }
        if (!(expression instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String referenceName = methodExpression.getReferenceName();
        if (!methodName.equals(referenceName)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.List")) {
            return null;
        }
        PsiExpression qualifierExpression = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (qualifierExpression == null || qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression) {
            return Holder.DUMMY;
        }
        if (!(qualifierExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return null;
        }
        PsiVariable variable = (PsiVariable)target;
        return new Holder(variable);
    }

    private static boolean expressionIsArrayLengthLookup(PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)expression;
        String referenceName = reference.getReferenceName();
        if (!"length".equals(referenceName)) {
            return false;
        }
        PsiExpression qualifier = reference.getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiType type = qualifier.getType();
        return type != null && type.getArrayDimensions() > 0;
    }

    @NotNull
    public String getID() {
        if ("ForLoopReplaceableByForEach" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "getID"));
        }
        return "ForLoopReplaceableByForEach";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.can.be.foreach.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("for.can.be.foreach.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForCanBeForeachVisitor();
    }

    private class ForCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private ForCanBeForeachVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement forStatement) {
            if (forStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$ForCanBeForeachVisitor", "visitForStatement"));
            }
            super.visitForStatement(forStatement);
            if (ForCanBeForeachInspectionBase.isArrayLoopStatement(forStatement) || ForCanBeForeachInspectionBase.isCollectionLoopStatement(forStatement, ForCanBeForeachInspectionBase.this.ignoreUntypedCollections) || ForCanBeForeachInspectionBase.this.REPORT_INDEXED_LOOP && ForCanBeForeachInspectionBase.isIndexedListLoopStatement(forStatement, ForCanBeForeachInspectionBase.this.ignoreUntypedCollections)) {
                this.registerStatementError((PsiStatement)forStatement, new Object[0]);
            }
        }
    }

    private static class Holder {
        public static final Holder DUMMY = new Holder();
        private final PsiVariable variable;

        public Holder(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$Holder", "<init>"));
            }
            this.variable = variable;
        }

        private Holder() {
            this.variable = null;
        }

        public PsiVariable getVariable() {
            return this.variable;
        }
    }

    private static class VariableOnlyUsedAsListIndexVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean indexVariableUsedOnlyAsIndex;
        private boolean listGetCalled;
        private final PsiVariable indexVariable;
        private final Holder collection;

        private VariableOnlyUsedAsListIndexVisitor(@NotNull Holder collection, @NotNull PsiVariable indexVariable) {
            if (collection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsListIndexVisitor", "<init>"));
            }
            if (indexVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexVariable", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsListIndexVisitor", "<init>"));
            }
            this.indexVariableUsedOnlyAsIndex = true;
            this.collection = collection;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsListIndexVisitor", "visitElement"));
            }
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsListIndexVisitor", "visitReferenceExpression"));
            }
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (this.indexVariable.equals(element)) {
                if (!this.isListIndexExpression(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                } else {
                    this.listGetCalled = true;
                }
            } else if (this.collection == Holder.DUMMY) {
                if (this.isListNonGetMethodCall(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                }
            } else if (this.collection.getVariable().equals(element) && !this.isListReferenceInIndexExpression(reference)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        private boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex && this.listGetCalled;
        }

        private boolean isListNonGetMethodCall(PsiReferenceExpression reference) {
            PsiClass containingClass;
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class);
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)(containingClass = method.getContainingClass()), (boolean)true)) {
                return false;
            }
            return !this.isListGetExpression(methodCallExpression);
        }

        private boolean isListIndexExpression(PsiReferenceExpression reference) {
            PsiElement referenceParent = reference.getParent();
            if (!(referenceParent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)referenceParent;
            PsiElement parent = expressionList.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListReferenceInIndexExpression(PsiReferenceExpression reference) {
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiElement greatGrandParent = methodCallExpression.getParent();
            if (greatGrandParent instanceof PsiExpressionStatement) {
                return false;
            }
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListGetExpression(PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                if (this.collection == Holder.DUMMY && (qualifierExpression == null || qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression)) {
                    return ForCanBeForeachInspectionBase.expressionIsListGetLookup((PsiExpression)methodCallExpression);
                }
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)qualifierExpression;
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = reference.resolve();
            if (this.collection == Holder.DUMMY || !this.collection.getVariable().equals(target)) {
                return false;
            }
            return ForCanBeForeachInspectionBase.expressionIsListGetLookup((PsiExpression)methodCallExpression);
        }
    }

    private static class VariableOnlyUsedAsIndexVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean indexVariableUsedOnlyAsIndex = true;
        private final PsiVariable arrayVariable;
        private final PsiVariable indexVariable;

        private VariableOnlyUsedAsIndexVisitor(PsiVariable arrayVariable, PsiVariable indexVariable) {
            this.arrayVariable = arrayVariable;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsIndexVisitor", "visitElement"));
            }
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            PsiAssignmentExpression assignment;
            PsiExpression lhs;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsIndexVisitor", "visitReferenceExpression"));
            }
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (!this.indexVariable.equals(element)) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiArrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (!(arrayExpression instanceof PsiReferenceExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (!this.arrayVariable.equals(target)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiElement arrayExpressionContext = arrayAccessExpression.getParent();
            if (arrayExpressionContext instanceof PsiAssignmentExpression && (lhs = (assignment = (PsiAssignmentExpression)arrayExpressionContext).getLExpression()).equals(arrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        private boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex;
        }
    }

    private static class IteratorMethodCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean methodCalled;
        private final PsiVariable iterator;

        private IteratorMethodCallVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$IteratorMethodCallVisitor", "visitElement"));
            }
            if (!this.methodCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$IteratorMethodCallVisitor", "visitMethodCallExpression"));
            }
            if (this.methodCalled) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if ("next".equals(name)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (this.iterator.equals(target)) {
                this.methodCalled = true;
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            if (this.methodCalled) {
                return;
            }
            super.visitMethodReferenceExpression(expression);
            PsiExpression qualifierExpression = ParenthesesUtils.stripParentheses(expression.getQualifierExpression());
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            if (this.iterator.equals(referenceExpression.resolve())) {
                this.methodCalled = true;
            }
        }

        private boolean isMethodCalled() {
            return this.methodCalled;
        }
    }

    private static class NumCallsToIteratorNextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private int numCallsToIteratorNext;
        private final PsiVariable iterator;

        private NumCallsToIteratorNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$NumCallsToIteratorNextVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(callExpression);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"next".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!this.iterator.equals(target)) {
                return;
            }
            ++this.numCallsToIteratorNext;
        }

        private int getNumCallsToIteratorNext() {
            return this.numCallsToIteratorNext;
        }
    }
}

