/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OverlyLargePrimitiveArrayInitializerInspection
extends BaseInspection {
    public int m_limit = 64;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("large.initializer.primitive.type.array.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/OverlyLargePrimitiveArrayInitializerInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer numElements = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("large.initializer.primitive.type.array.problem.descriptor", numElements);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/OverlyLargePrimitiveArrayInitializerInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("large.initializer.primitive.type.array.maximum.number.of.elements.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyLargePrimitiveArrayInitializerVisitor();
    }

    private class OverlyLargePrimitiveArrayInitializerVisitor
    extends BaseInspectionVisitor {
        private OverlyLargePrimitiveArrayInitializerVisitor() {
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            super.visitArrayInitializerExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            PsiType componentType = type.getDeepComponentType();
            if (!(componentType instanceof PsiPrimitiveType)) {
                return;
            }
            int numElements = this.calculateNumElements((PsiExpression)expression);
            if (numElements <= OverlyLargePrimitiveArrayInitializerInspection.this.m_limit) {
                return;
            }
            this.registerError((PsiElement)expression, numElements);
        }

        private int calculateNumElements(PsiExpression expression) {
            if (expression instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayExpression = (PsiArrayInitializerExpression)expression;
                PsiExpression[] initializers = arrayExpression.getInitializers();
                int out = 0;
                for (PsiExpression initializer : initializers) {
                    out += this.calculateNumElements(initializer);
                }
                return out;
            }
            return 1;
        }
    }
}

