/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.visitors.filters;

import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ArrayFilters {
    public static int NO_PARAM = -1;
    public static int CONCRETE_TYPE = -2;
    public static final int INVOCATOR = -1;
    public static final int RESULT = -2;
    public static final int VALUES = 0;
    public static final int KEYS = 1;
    public static final int BOTH = 2;
    private Map<String, ArrayTreatedMethod> methodsMap = new HashMap<String, ArrayTreatedMethod>();
    private Map<String, ContainerType> typesMap = new HashMap<String, ContainerType>();

    public void addType(ContainerType type) {
        this.typesMap.put(type.signature, type);
    }

    public void addMethod(ArrayTreatedMethod method) {
        this.methodsMap.put(method.signature + '#' + method.numOfParams + '#' + method.domain, method);
    }

    public ContainerType findType(String signature) {
        return this.typesMap.get(signature);
    }

    public ArrayTreatedMethod[] findMethods(String signature, int numOfParams) {
        ArrayList<ArrayTreatedMethod> result2 = new ArrayList<ArrayTreatedMethod>();
        ArrayTreatedMethod method = this.methodsMap.get(signature + '#' + numOfParams + '#' + 0);
        if (method != null) {
            result2.add(method);
        }
        if ((method = this.methodsMap.get(signature + '#' + numOfParams + '#' + 1)) != null) {
            result2.add(method);
        }
        if ((method = this.methodsMap.get(signature + '#' + numOfParams + '#' + 2)) != null) {
            result2.add(method);
        }
        return (ArrayTreatedMethod[])ArrayHelper.castArray(result2.toArray(), ArrayTreatedMethod.class);
    }

    public static class ArrayCopyMetod
    extends ArrayTreatedMethod {
        public int srcIndex;
        public int dstIndex;

        ArrayCopyMetod(String signature, int numOfParams, int srcIndex, int dstIndex, int domain) {
            super(signature, numOfParams);
            this.srcIndex = srcIndex;
            this.dstIndex = dstIndex;
            this.domain = domain;
        }
    }

    public static class ArrayStoreMetod
    extends ArrayTreatedMethod {
        public int paramIndex;

        ArrayStoreMetod(String signature, int numOfParams, int paramIndex, int domain) {
            super(signature, numOfParams);
            this.paramIndex = paramIndex;
            this.domain = domain;
        }
    }

    public static class ArrayAccessMetod
    extends ArrayTreatedMethod {
        ArrayAccessMetod(String signature, int numOfParams) {
            super(signature, numOfParams);
        }
    }

    public static abstract class ArrayTreatedMethod {
        public String signature;
        public int numOfParams;
        public int domain;

        ArrayTreatedMethod(String signature, int numOfParams) {
            this.signature = signature;
            this.numOfParams = numOfParams;
        }
    }

    public static class ContainerType {
        public String signature;
        public int keysTypeParamIndex;
        public int elemetsTypeParamIndex;
        public String concreteElementsType;

        ContainerType(String signature, int keysTypeParamIndex, int elemetsTypeParamIndex, String concreteElementsType) {
            this.signature = signature;
            this.keysTypeParamIndex = keysTypeParamIndex;
            this.elemetsTypeParamIndex = elemetsTypeParamIndex;
            this.concreteElementsType = concreteElementsType;
        }
    }
}

