/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils.stream;

import com.jetbrains.sourceglider.utils.FileHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class RSAKey {
    public BigInteger exponent;
    public BigInteger modulus;
    public int blockSize;

    public RSAKey(BigInteger exponent, BigInteger modulus, int blockSize) {
        this.exponent = exponent;
        this.modulus = modulus;
        this.blockSize = blockSize;
    }

    public static void serialize(OutputStream stream, RSAKey key) throws IOException {
        FileHelper.writeBigIntToStream(stream, key.exponent);
        FileHelper.writeBigIntToStream(stream, key.modulus);
        stream.write((byte)(key.blockSize >> 8));
        stream.write((byte)(key.blockSize & 0xFF));
    }

    public static RSAKey deserialize(InputStream stream) throws IOException {
        BigInteger exponent = FileHelper.readBigIntFromStream(stream);
        BigInteger modulus = FileHelper.readBigIntFromStream(stream);
        int blockSize = (stream.read() << 8) + stream.read();
        return new RSAKey(exponent, modulus, blockSize);
    }
}

