/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.scripts.GenericDomainTypeUnifier;
import com.jetbrains.sourceglider.scripts.Script;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RMLParseErrorCallback;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.parser.ConsoleStatement;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Lexer;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.Parser;
import com.jetbrains.sourceglider.scripts.rml.parser.Program;
import com.jetbrains.sourceglider.scripts.rml.parser.StatementPrint;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.ui.console.Console;
import com.jetbrains.sourceglider.utils.FileHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class RMLScript
implements Script {
    private String name;
    private URL url;
    private String query;
    private Stmt stmt;
    private VariablesManager manager;
    private IRelationsManager relationsManager;
    private UIInstancesProvider uiInstancesProvider;
    private SymbolTable symbolTable;
    public static final String CONSOLE_QUERY = Messages.getString(RMLScript.class.getName() + "-0");
    public static final String KEY_NAME = "name";

    public RMLScript(IRelationsManager relationsManager, UIInstancesProvider provider, SymbolTable table) {
        this.relationsManager = relationsManager;
        this.uiInstancesProvider = provider;
        this.symbolTable = table;
    }

    public RMLScript(IRelationsManager relationsManager, String name, String query, UIInstancesProvider provider, SymbolTable table) {
        this.relationsManager = relationsManager;
        this.name = name;
        this.query = query;
        this.uiInstancesProvider = provider;
        this.symbolTable = table;
    }

    public static RMLScript readScript(String fileName, ManagerInstancesProvider provider) {
        URL url = RMLScript.class.getResource(fileName);
        return RMLScript.readScript(fileName, url, provider);
    }

    public static RMLScript readScript(String name, URL url, ManagerInstancesProvider provider) {
        try {
            if (url == null) {
                provider.getUIInstancesProvider().getUICallback().showError(Messages.getString(RMLScript.class.getName() + "-2") + name + "\"", true);
                return null;
            }
            InputStream stream = url.openStream();
            String query = FileHelper.readTextFromStream(stream);
            stream.close();
            RMLScript script = new RMLScript(provider.getRelationsManager(), name, query, provider.getUIInstancesProvider(), provider.getSymbolTable());
            script.url = url;
            return script;
        }
        catch (Throwable e) {
            provider.getUICallback().showError(Messages.getString(RMLScript.class.getName() + "-1") + name + "\"", e, true);
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean hasProgressFeedback() {
        return false;
    }

    @Override
    public RelationSignature[] getInputRelations() {
        return this.manager.getInputRelations();
    }

    @Override
    public RelationSignature[] getOutputRelations() {
        return this.manager.getOutputRelations();
    }

    @Override
    public String getMetaInfo(String key) {
        return this.manager.getScriptMetaInfo().get(key);
    }

    @Override
    public Map<String, String> getMetaInfos(String relation) {
        return this.manager.getMetaInfo(relation);
    }

    public String getQuery() {
        return this.query;
    }

    public boolean compile(RMLParseErrorCallback errorCallback) {
        this.manager = new VariablesManager(this.symbolTable);
        try {
            Context context = new Context(this.manager, this.symbolTable, false);
            Parser parser = new Parser(new Lexer(this.query, this.manager), context);
            Program program = new Program(context);
            parser.parse(program);
            this.stmt = program.getStmt();
        }
        catch (ParseException e) {
            if (e.getMessage().equals("Missed END_OF_FILE")) {
                e = new ParseException(e.getStartPos(), e.getEndPos(), e.getLine(), e.getOffset(), "Parse error");
            }
            errorCallback.error(e.getStartPos(), e.getEndPos(), e.getLine(), e.getOffset(), e.getMessage());
            return false;
        }
        if (this.getMetaInfo(KEY_NAME) != null) {
            this.name = this.getMetaInfo(KEY_NAME);
        }
        this.manager.removeUnusedRelations();
        return true;
    }

    public boolean compileConsoleQuery(RelationsRepository repository, RMLParseErrorCallback errorCallback, boolean isComplex) {
        String[] rels;
        this.manager = new VariablesManager(this.symbolTable);
        Context context = new Context(this.manager, this.symbolTable, true);
        for (String rel : rels = repository.getAvailableRelations()) {
            this.manager.addInputRelation(new RelationSignature(rel, repository.getDomainTypes(rel)));
        }
        try {
            Parser parser = new Parser(new Lexer(this.query, this.manager), context);
            if (isComplex) {
                ConsoleStatement statement = new ConsoleStatement(context);
                parser.parse(statement);
                this.stmt = statement.stmt;
            } else {
                StatementPrint statement = new StatementPrint(context);
                parser.parse(statement);
                this.stmt = statement.stmt;
            }
        }
        catch (ParseException e) {
            if (e.getMessage().equals("Missed END_OF_FILE")) {
                e = new ParseException(e.getStartPos(), e.getEndPos(), e.getLine(), e.getOffset(), "Parse error");
            }
            errorCallback.error(e.getStartPos(), e.getEndPos(), e.getLine(), e.getOffset(), e.getMessage());
            return false;
        }
        this.manager.removeUnusedRelations();
        return true;
    }

    @Override
    public void unifyGenericTypes(GenericDomainTypeUnifier unifier) {
        this.manager.unifyGenericTypes(unifier);
    }

    @Override
    public void run(RelationsRepository relationsRepository, Map options, ThreadCallback threadCallback, Console console) {
        ProfileManager profileManager;
        RuntimeVariablesManager manager = new RuntimeVariablesManager(relationsRepository, options, this.manager, this.relationsManager);
        ProfileManager profileManager2 = profileManager = options.containsKey(ProfileManager.class) ? new ProfileManager() : null;
        if (this.stmt != null) {
            this.stmt.interpret(this.relationsManager, manager, threadCallback, new DomainsPool(), this.uiInstancesProvider, this.symbolTable, profileManager);
        }
        if (!threadCallback.checkCancelled()) {
            manager.storeOutputRelations(threadCallback);
        }
        if (profileManager != null) {
            profileManager.dump(console, this.query);
        }
    }
}

