/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.repositories;

import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.repositories.MemoryRelationsRepository;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.repositories.RepositoryEvent;
import com.jetbrains.sourceglider.repositories.RepostoryActionListener;
import com.jetbrains.sourceglider.scripts.GenericDomainTypeUnifier;
import com.jetbrains.sourceglider.scripts.Script;
import com.jetbrains.sourceglider.scripts.ScriptManager;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.Task;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import com.jetbrains.sourceglider.utils.StringHelper;
import com.jetbrains.sourceglider.visitors.Visitor;
import com.jetbrains.sourceglider.visitors.VisitorImpl;
import com.jetbrains.sourceglider.visitors.VisitorsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HypoteticRelationsRepository
implements RepostoryActionListener {
    private static final String KEY_KILL_DEPENDENT_RELATIONS = "KillDependentRelations";
    private static final boolean DEFAULT_KILL_DEPENDENT_RELATIONS = true;
    private ManagerInstancesProvider provider;
    private RelationsRepository repository;
    private ScriptManager scriptManager;
    private VisitorsManager visitorsManager;
    private final UIInstancesProvider uiInstancesProvider;
    private HashMap<String, Entry> entries;
    private boolean spoilRelationsMode;
    private boolean killDependentRelations;

    public HypoteticRelationsRepository(ManagerInstancesProvider provider) {
        this.provider = provider;
        this.repository = provider.getRelationsRepository();
        this.scriptManager = provider.getScriptManager();
        this.visitorsManager = provider.getVisitorsManager();
        this.entries = new HashMap();
        this.uiInstancesProvider = provider.getUIInstancesProvider();
        this.killDependentRelations = this.uiInstancesProvider.getConfigs().getBooleanValue(KEY_KILL_DEPENDENT_RELATIONS, true);
    }

    public void setSpoilRelationsMode(boolean mode) {
        this.spoilRelationsMode = mode;
    }

    @Override
    public void relationAdded(RepositoryEvent event) {
        Entry entry = this.entries.get(event.name);
        if (entry == null) {
            entry = new Entry();
            entry.signature = new RelationSignature(event.name, event.relation.getDomainTypes());
            this.entries.put(event.name, entry);
        } else if (!ArrayHelper.equals(entry.signature.getTypes(), event.relation.getDomainTypes())) {
            throw new RuntimeException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-2"));
        }
        if (event.causeRepository == MemoryRelationsRepository.class) {
            entry.inMemory = true;
        }
        if (this.spoilRelationsMode && this.killDependentRelations) {
            ArrayList<String> vector = new ArrayList<String>();
            this.getDependentRelations(entry, vector);
            this.repository.deleteAllRelations(ArrayHelper.castStringArray(vector.toArray()));
        }
    }

    private void getDependentRelations(Entry entry, List<String> vector) {
        for (int i = 0; i < entry.dependencies.size(); ++i) {
            String name = entry.dependencies.get((int)i).signature.getName();
            if (vector.contains(name) || !this.repository.containsRelation(name)) continue;
            vector.add(name);
            this.getDependentRelations(entry.dependencies.get(i), vector);
        }
    }

    @Override
    public void relationRemoved(RepositoryEvent event) {
        Entry entry = this.entries.get(event.name);
        if (entry == null) {
            return;
        }
        if (event.causeRepository == MemoryRelationsRepository.class) {
            entry.inMemory = false;
        }
        if (!entry.inMemory && entry.visitor == null && entry.script == null) {
            this.entries.remove(event.name);
        }
    }

    public void resetMemoryRelations() {
        String[] relations;
        for (String relation : relations = this.getAvailableRelations()) {
            this.entries.get((Object)relation).inMemory = false;
        }
    }

    public boolean refresh() {
        this.entries = new HashMap();
        this.refreshRepository();
        this.refreshVisitors();
        return this.refreshScripts();
    }

    private void refreshVisitors() {
        Visitor[] visitors;
        for (Visitor visitor : visitors = this.visitorsManager.getAvailableVisitors()) {
            RelationSignature[] signatures;
            for (RelationSignature signature : signatures = visitor.getOutputRelations()) {
                Entry entry;
                String name = signature.getName();
                if (this.entries.containsKey(name)) {
                    entry = this.entries.get(name);
                    if (entry.visitor != null) {
                        throw new RuntimeException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-3") + name + Messages.getString(HypoteticRelationsRepository.class.getName() + "-4") + entry.visitor.getDescription() + Messages.getString(HypoteticRelationsRepository.class.getName() + "-5") + visitor.getDescription() + "\"");
                    }
                    if (!ArrayHelper.equals(entry.signature.getTypes(), signature.getTypes())) {
                        throw new RuntimeException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-7") + name + Messages.getString(HypoteticRelationsRepository.class.getName() + "-8"));
                    }
                } else {
                    entry = new Entry();
                }
                entry.signature = signature;
                entry.visitor = visitor;
                entry.metaInfo = visitor.getMetaInfos(name);
                this.entries.put(name, entry);
            }
        }
    }

    private boolean refreshScripts() {
        boolean changes;
        Script[] scripts = this.scriptManager.getAvailableScripts();
        boolean[] processed = new boolean[scripts.length];
        GenericDomainTypeUnifier unifier = new GenericDomainTypeUnifier(this);
        int scriptsLeft = scripts.length;
        String notUnified = null;
        do {
            changes = false;
            for (int i = 0; i < scripts.length; ++i) {
                Script script = scripts[i];
                if (processed[i] || (notUnified = unifier.unifySignatures(script.getInputRelations(), script.getName())) != null) continue;
                script.unifyGenericTypes(unifier);
                for (int j = 0; j < script.getOutputRelations().length; ++j) {
                    Entry entry;
                    String name = script.getOutputRelations()[j].getName();
                    if (this.entries.containsKey(name)) {
                        entry = this.entries.get(name);
                        if (entry.visitor != null || entry.script != null) {
                            throw new RuntimeException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-9") + name + Messages.getString(HypoteticRelationsRepository.class.getName() + "-10") + (entry.visitor != null ? entry.visitor.getDescription() : entry.script.getName()) + Messages.getString(HypoteticRelationsRepository.class.getName() + "-11") + script.getName() + "\"");
                        }
                    } else {
                        entry = new Entry();
                    }
                    entry.signature = script.getOutputRelations()[j];
                    entry.script = script;
                    entry.metaInfo = script.getMetaInfos(name);
                    this.entries.put(name, entry);
                    for (int k = 0; k < script.getInputRelations().length; ++k) {
                        String input = script.getInputRelations()[k].getName();
                        this.entries.get((Object)input).dependencies.add(entry);
                    }
                }
                processed[i] = true;
                changes = true;
                --scriptsLeft;
            }
        } while (changes);
        ArrayList<String> loops = new ArrayList<String>();
        for (int i = 0; i < processed.length; ++i) {
            if (processed[i]) continue;
            loops.add("\"" + scripts[i].getName() + "\"");
        }
        if (loops.size() > 0) {
            this.uiInstancesProvider.getUICallback().showError(Messages.getString(HypoteticRelationsRepository.class.getName() + "-15") + StringHelper.makeCommaList(loops) + Messages.getString(HypoteticRelationsRepository.class.getName() + "-16") + notUnified + "\".", true);
            return false;
        }
        return true;
    }

    private void refreshRepository() {
        String[] names;
        for (String name : names = this.repository.getAvailableRelations()) {
            Entry entry = this.entries.get(name);
            if (entry == null) {
                entry = new Entry();
                entry.signature = new RelationSignature(name, this.repository.getDomainTypes(name));
                this.entries.put(name, entry);
            } else if (!ArrayHelper.equals(entry.signature.getTypes(), this.repository.getDomainTypes(name))) {
                throw new RuntimeException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-18") + name + Messages.getString(HypoteticRelationsRepository.class.getName() + "-19"));
            }
            entry.inMemory = true;
        }
    }

    public String[] getAvailableRelations() {
        return ArrayHelper.castStringArray(this.entries.keySet().toArray());
    }

    public DomainType[] getDomainTypes(String name) {
        return this.entries.get((Object)name).signature.getTypes();
    }

    public Map<String, String> getMetaInfo(String relation) {
        return this.entries.get((Object)relation).metaInfo;
    }

    public boolean containsRelation(String name) {
        return this.entries.containsKey(name);
    }

    public List<Task> getRelationBuildPlan(String[] names, final Map options) {
        final ArrayList<VisitorImpl> runDomainBuilders = new ArrayList<VisitorImpl>();
        final ArrayList<Visitor> runVisitors = new ArrayList<Visitor>();
        ArrayList<Script> runScripts = new ArrayList<Script>();
        for (String name : names) {
            if (this.getRelationBuildPlan(name, runDomainBuilders, runVisitors, runScripts, new HashSet<String>())) continue;
            return null;
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        if (!runDomainBuilders.isEmpty()) {
            tasks.add(new Task(Messages.getString(HypoteticRelationsRepository.class.getName() + "-20")){

                @Override
                public void run(ThreadCallback threadCallback) {
                    for (VisitorImpl visitor : runDomainBuilders) {
                        visitor.setMyBuildDomainsMode(true);
                        visitor.init();
                    }
                    HypoteticRelationsRepository.this.visitorsManager.run((Visitor[])ArrayHelper.castArray(runVisitors.toArray(), Visitor.class), options, HypoteticRelationsRepository.this.provider, threadCallback);
                }
            });
        }
        if (!runVisitors.isEmpty()) {
            tasks.add(new Task(Messages.getString(HypoteticRelationsRepository.class.getName() + "-20")){

                @Override
                public void run(ThreadCallback threadCallback) {
                    for (Visitor visitor : runVisitors) {
                        if (visitor instanceof VisitorImpl) {
                            ((VisitorImpl)visitor).setMyBuildDomainsMode(false);
                        }
                        visitor.init();
                    }
                    HypoteticRelationsRepository.this.visitorsManager.run((Visitor[])ArrayHelper.castArray(runVisitors.toArray(), Visitor.class), options, HypoteticRelationsRepository.this.provider, threadCallback);
                }
            });
        }
        for (final Script script : runScripts) {
            tasks.add(new Task(Messages.getString(HypoteticRelationsRepository.class.getName() + "-21") + script.getName() + "\"", !script.hasProgressFeedback()){

                @Override
                public void run(ThreadCallback threadCallback) {
                    HypoteticRelationsRepository.this.scriptManager.run(script, options, HypoteticRelationsRepository.this.repository, threadCallback, HypoteticRelationsRepository.this.uiInstancesProvider);
                }
            });
        }
        return tasks;
    }

    public Set<String> getSideRelations(String name) {
        HashSet<String> result2 = new HashSet<String>();
        if (this.getRelationBuildPlan(name, new ArrayList<VisitorImpl>(), new ArrayList<Visitor>(), new ArrayList<Script>(), result2)) {
            return result2;
        }
        return null;
    }

    public boolean isBasicRelation(String name) {
        return this.entries.get(name) != null && this.entries.get((Object)name).visitor != null;
    }

    public List<Task> getRelationBuildPlan(String name, Map options) {
        return this.getRelationBuildPlan(new String[]{name}, options);
    }

    private boolean getRelationBuildPlan(String name, List<VisitorImpl> runDomainBuilders, List<Visitor> runVisitors, List<Script> runScripts, Set<String> armedRelations) {
        if (armedRelations.contains(name)) {
            return true;
        }
        armedRelations.add(name);
        Entry entry = this.entries.get(name);
        if (entry == null) {
            return false;
        }
        if (!entry.inMemory) {
            if (entry.visitor != null) {
                if (!runVisitors.contains(entry.visitor)) {
                    RelationSignature[] outputs;
                    if (entry.visitor instanceof VisitorImpl) {
                        runDomainBuilders.add((VisitorImpl)entry.visitor);
                    }
                    runVisitors.add(entry.visitor);
                    for (RelationSignature output : outputs = entry.visitor.getOutputRelations()) {
                        armedRelations.add(output.getName());
                    }
                }
            } else if (entry.script != null) {
                if (!runScripts.contains(entry.script)) {
                    RelationSignature[] outputs;
                    RelationSignature[] inputs = entry.script.getInputRelations();
                    for (RelationSignature output : outputs = entry.script.getOutputRelations()) {
                        armedRelations.add(output.getName());
                    }
                    for (RelationSignature input : inputs) {
                        this.getRelationBuildPlan(input.getName(), runDomainBuilders, runVisitors, runScripts, armedRelations);
                    }
                    runScripts.add(entry.script);
                }
            } else {
                throw new RuntimeException(Messages.getString(HypoteticRelationsRepository.class.getName() + "-23"));
            }
        }
        return true;
    }

    private static class Entry {
        RelationSignature signature;
        Map<String, String> metaInfo;
        boolean inMemory;
        Visitor visitor;
        Script script;
        List<Entry> dependencies = new ArrayList<Entry>(0);

        private Entry() {
        }
    }
}

