/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.relations.incremental;

import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.relations.incremental.IncrementalRelation;
import com.jetbrains.sourceglider.relations.incremental.RelationsCache;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IncrementalRelationsManager
implements IRelationsManager {
    SymbolTable symbolTable;
    IBDDManager bddManager;
    RelationsCache cache;

    @Override
    public void init(IBDDManager bddManager, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.bddManager = bddManager;
        this.cache = new RelationsCache(bddManager);
    }

    @Override
    public IRelation makeRepositoryRelation(IRelation relation, String relname) {
        ((IncrementalRelation)relation).key = this.cache.getRepositoryRelationKey(relname);
        return relation;
    }

    private IRelation makeConstRelation(IBDD node, int hashCode, Domain[] domains) {
        int key = this.cache.getKey(hashCode);
        IBDD last = this.cache.getLastCached(key);
        IBDD zero = this.bddManager.getZero();
        last.incRefCount();
        return new IncrementalRelation(this, last, last.isZero() ? node : zero, zero, domains, key).saveResult();
    }

    IRelation makeExplicitIncremental(IBDD result2, int key, Domain[] domains, ThreadCallback threadCallback) {
        IBDD old = this.cache.getLastCached(key);
        IBDD newAdd = result2.intersect(old.complement(), threadCallback);
        IBDD newSub = old.intersect(result2.complement(), threadCallback);
        this.cache.save(key, result2);
        return new IncrementalRelation(this, old, newAdd, newSub, domains, key);
    }

    @Override
    public IRelation makeSubIncrementalRelation(IRelation base, IRelation add, IRelation sub, ThreadCallback threadCallback) {
        IncrementalRelation baseRel = (IncrementalRelation)base;
        IncrementalRelation addRel = (IncrementalRelation)add;
        IncrementalRelation subRel = (IncrementalRelation)sub;
        baseRel.result.incRefCount();
        addRel.result.incRefCount();
        return new IncrementalRelation(this, baseRel.result, addRel.result, subRel.result.intersect(addRel.result.complement(), threadCallback), baseRel.domains, -1);
    }

    @Override
    public IRelation makeEmptyRelation(Domain[] domains) {
        return this.makeConstRelation(this.bddManager.getZero(), 0, domains);
    }

    @Override
    public IRelation makeEmptyRelation(DomainType[] types) {
        return this.makeConstRelation(this.bddManager.getZero(), 0, DomainType.getCorrespondingDomains(types));
    }

    @Override
    public IRelation makeEmptyRelation(Domain[] domains, boolean isFull) {
        return this.makeConstRelation(isFull ? this.bddManager.getOne() : this.bddManager.getZero(), isFull ? 1 : 0, domains);
    }

    @Override
    public IRelation makeSingleTuple(Domain domain, int value) {
        return this.makeConstRelation(this.bddManager.makeSingleTuple(domain.getFirstVar(), domain.size(), value), value, new Domain[]{domain});
    }

    @Override
    public IRelation makeSingleTuple(DomainType type, int value) {
        Domain domain = type.getDomain(0);
        return this.makeConstRelation(this.bddManager.makeSingleTuple(domain.getFirstVar(), domain.size(), value), value, new Domain[]{domain});
    }

    @Override
    public IRelation makeRegExprSet(Domain domain, String regexpr, ThreadCallback threadCallback) {
        SymbolTable symTable = this.symbolTable;
        DomainType type = domain.getType();
        Pattern pattern = Pattern.compile(regexpr);
        IBDD node = this.bddManager.getZero();
        for (int i = 0; i < type.getNumOfAttrs(); ++i) {
            Matcher matcher = pattern.matcher(symTable.getAttribute(type, i).getKey());
            if (!matcher.matches()) continue;
            node = node.unite(this.bddManager.makeSingleTuple(domain.getFirstVar(), domain.size(), i), threadCallback);
        }
        return this.makeExplicitIncremental(node, this.cache.getKey(regexpr.hashCode()), new Domain[]{domain}, threadCallback);
    }

    @Override
    public IRelation makeEqual(Domain domain1, Domain domain2, ThreadCallback threadCallback) {
        if (!domain1.getType().equals(domain2.getType())) {
            throw new RuntimeException(Messages.getString(IncrementalRelationsManager.class.getName() + "-0"));
        }
        IBDD node = this.bddManager.getZero();
        DomainType type = domain1.getType();
        for (int i = 0; i < type.getNumOfAttrs(); ++i) {
            IBDD pair = this.bddManager.makeSingleTuple(domain1.getFirstVar(), domain1.size(), i);
            pair = pair.intersect(this.bddManager.makeSingleTuple(domain2.getFirstVar(), domain2.size(), i), threadCallback);
            node = node.unite(pair, threadCallback);
        }
        return this.makeExplicitIncremental(node, this.cache.getKey(domain1.hashCode() * 31 + domain2.hashCode()), new Domain[]{domain1, domain2}, threadCallback);
    }

    @Override
    public void serialize(ObjectOutputStream stream, IRelation[] relations, ThreadCallback threadCallback, double progressPart, String message) throws IOException {
        IBDD[] nodes = new IBDD[relations.length];
        for (int i = 0; i < relations.length; ++i) {
            nodes[i] = ((IncrementalRelation)relations[i]).result;
        }
        this.bddManager.serialize(stream, nodes, threadCallback, progressPart, message);
        for (IRelation relation : relations) {
            IncrementalRelation rel = (IncrementalRelation)relation;
            String[] typeNames = new String[rel.domains.length];
            for (int j = 0; j < rel.domains.length; ++j) {
                typeNames[j] = rel.domains[j].getType().getName();
            }
            stream.writeObject(typeNames);
        }
    }

    @Override
    public IRelation[] deserialize(ObjectInputStream stream, ThreadCallback threadCallback, double progressPart, String message) throws IOException, ClassNotFoundException {
        IBDD[] nodes = this.bddManager.deserialize(stream, threadCallback, progressPart, message);
        IRelation[] result2 = new IRelation[nodes.length];
        for (int i = 0; i < result2.length; ++i) {
            String[] typeNames = (String[])stream.readObject();
            DomainType[] types = new DomainType[typeNames.length];
            for (int j = 0; j < types.length; ++j) {
                types[j] = this.symbolTable.getDomainType(typeNames[j]);
            }
            result2[i] = new IncrementalRelation(this, this.bddManager.getZero(), nodes[i], this.bddManager.getZero(), DomainType.getCorrespondingDomains(types), -1);
        }
        return result2;
    }
}

