/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.bdd.javaimpl;

import com.jetbrains.sourceglider.bdd.BDDException;
import com.jetbrains.sourceglider.bdd.BDDMemoryOverflowException;
import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import com.jetbrains.sourceglider.bdd.javaimpl.BDDJavaImpl;
import com.jetbrains.sourceglider.ui.IConfigs;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.console.Console;
import com.jetbrains.sourceglider.utils.Formatter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BDDManagerJavaImpl
implements IBDDManager {
    private static final int NODE_SIZE = 40;
    private static final int OP_CACHE_NODE_SIZE = 36;
    private static final int MAX_NODES_SIZE = 100000000;
    BDDJavaImpl zero;
    BDDJavaImpl one;
    private BDDJavaImpl firstFreeNode;
    private int totalNodesAllocated;
    private int garbageCollectCounter;
    private OpCacheEntry[] opCache;
    private int opCacheBitsCount;
    private int opCacheOccupied;
    private int opCacheTreshold;
    private BDDJavaImpl[] nodeCache;
    private int nodeCacheOccupied;
    private int nodeCacheTreshold;
    private int nodeCacheBitsCount;
    static final double CACHE_TRESHOLD_KOEFF = 0.75;
    int maxOpCacheSize;
    int maxNodeCacheSize;
    int garbageCollectRate;
    private int serialID;
    int curSerialID;
    List<BDDJavaImpl> finalizedNodes;
    boolean synchronizeOnGC;
    boolean enableGC;

    int opHashCode(int opCode, BDDJavaImpl left, BDDJavaImpl right) {
        int mask = (1 << this.opCacheBitsCount) - 1;
        int j = left.serialID ^ 0x55555555;
        int k = right.serialID;
        return opCode + (j << (this.opCacheBitsCount >> 1)) + (j >> (this.opCacheBitsCount >> 1)) + (k << (this.opCacheBitsCount >> 2)) + (k >> (this.opCacheBitsCount >> 2)) & mask;
    }

    int opHashCode(int opCode, BDDJavaImpl left, int right) {
        int mask = (1 << this.opCacheBitsCount) - 1;
        int j = left.serialID ^ 0x55555555;
        return opCode + (j << (this.opCacheBitsCount >> 1)) + (j >> (this.opCacheBitsCount >> 1)) + (right << (this.opCacheBitsCount >> 2)) + (right >> (this.opCacheBitsCount >> 2)) & mask;
    }

    int opHashCode(int opCode, BDDJavaImpl left, BDDJavaImpl right, int operand) {
        int mask = (1 << this.opCacheBitsCount) - 1;
        int j = left.serialID ^ 0x55555555;
        int k = right.serialID;
        return opCode + (j << (this.opCacheBitsCount >> 1)) + (j >> (this.opCacheBitsCount >> 1)) + (k << (this.opCacheBitsCount >> 2)) + (k >> (this.opCacheBitsCount >> 2)) + (operand << (this.opCacheBitsCount >> 3)) + (operand >> (this.opCacheBitsCount >> 3)) & mask;
    }

    int nodeHashCode(int var, BDDJavaImpl low, BDDJavaImpl high) {
        int mask = (1 << this.nodeCacheBitsCount) - 1;
        int j = low.serialID ^ 0x55555555;
        int k = high.serialID;
        return var + (j << (this.nodeCacheBitsCount >> 1)) + (j >> (this.nodeCacheBitsCount >> 1)) + (k << (this.nodeCacheBitsCount >> 2)) + (k >> (this.nodeCacheBitsCount >> 2)) & mask;
    }

    BDDJavaImpl searchInOpCache(int opCode, BDDJavaImpl left, BDDJavaImpl right, int hashCode) {
        OpCacheEntry entry = this.opCache[hashCode];
        if (entry.result != null && entry.opCode == opCode && entry.left == left && entry.right == right && entry.leftSerialID == entry.left.serialID && entry.rightSerialID == entry.right.serialID && entry.resultSerialID == entry.result.serialID) {
            ++entry.result.refCount;
            return entry.result;
        }
        return null;
    }

    BDDJavaImpl searchInOpCache(int opCode, BDDJavaImpl left, int right, int hashCode) {
        OpCacheEntry entry = this.opCache[hashCode];
        if (entry.result != null && entry.opCode == opCode && entry.left == left && entry.intOperand == right && entry.leftSerialID == entry.left.serialID && entry.resultSerialID == entry.result.serialID) {
            ++entry.result.refCount;
            return entry.result;
        }
        return null;
    }

    BDDJavaImpl searchInOpCache(int opCode, BDDJavaImpl left, BDDJavaImpl right, int intOperand, int hashCode) {
        OpCacheEntry entry = this.opCache[hashCode];
        if (entry.result != null && entry.opCode == opCode && entry.left == left && entry.right == right && entry.intOperand == intOperand && entry.leftSerialID == entry.left.serialID && entry.rightSerialID == entry.right.serialID && entry.resultSerialID == entry.result.serialID) {
            ++entry.result.refCount;
            return entry.result;
        }
        return null;
    }

    int searchInOpCache(int opCode, BDDJavaImpl operand, int hashCode) {
        OpCacheEntry entry = this.opCache[hashCode];
        if (entry.opCode == opCode && entry.left == operand) {
            return entry.intOperand;
        }
        return -1;
    }

    BDDJavaImpl putInOpCache(int opCode, BDDJavaImpl left, BDDJavaImpl right, BDDJavaImpl result2, int hashCode) {
        OpCacheEntry entry = this.opCache[hashCode];
        if (entry.result == null) {
            ++this.opCacheOccupied;
        } else if (entry.leftSerialID == entry.left.serialID && entry.right != null && entry.rightSerialID == entry.right.serialID && entry.result.serialID == entry.resultSerialID && result2.refCount < entry.result.refCount) {
            return result2;
        }
        entry.opCode = opCode;
        entry.left = left;
        entry.right = right;
        entry.result = result2;
        entry.leftSerialID = left.serialID;
        entry.rightSerialID = right.serialID;
        entry.resultSerialID = result2.serialID;
        if (this.opCacheOccupied > this.opCacheTreshold) {
            this.rehashOpCache();
        }
        return result2;
    }

    BDDJavaImpl putInOpCache(int opCode, BDDJavaImpl left, int right, BDDJavaImpl result2, int hashCode) {
        OpCacheEntry entry = this.opCache[hashCode];
        if (entry.result == null) {
            ++this.opCacheOccupied;
        } else if (entry.leftSerialID == entry.left.serialID && entry.result.serialID == entry.resultSerialID && result2.refCount < entry.result.refCount) {
            return result2;
        }
        entry.opCode = opCode;
        entry.left = left;
        entry.intOperand = right;
        entry.result = result2;
        entry.leftSerialID = left.serialID;
        entry.resultSerialID = result2.serialID;
        if (this.opCacheOccupied > this.opCacheTreshold) {
            this.rehashOpCache();
        }
        return result2;
    }

    BDDJavaImpl putInOpCache(int opCode, BDDJavaImpl left, BDDJavaImpl right, int intOperand, BDDJavaImpl result2, int hashCode) {
        OpCacheEntry entry = this.opCache[hashCode];
        if (entry.result == null) {
            ++this.opCacheOccupied;
        } else if (entry.leftSerialID == entry.left.serialID && entry.right != null && entry.rightSerialID == entry.right.serialID && entry.result.serialID == entry.resultSerialID && result2.refCount < entry.result.refCount) {
            return result2;
        }
        entry.opCode = opCode;
        entry.left = left;
        entry.right = right;
        entry.intOperand = intOperand;
        entry.result = result2;
        entry.leftSerialID = left.serialID;
        entry.rightSerialID = right.serialID;
        entry.resultSerialID = result2.serialID;
        if (this.opCacheOccupied > this.opCacheTreshold) {
            this.rehashOpCache();
        }
        return result2;
    }

    int putInOpCache(int opCode, BDDJavaImpl operand, int result2, int hashCode) {
        OpCacheEntry entry = this.opCache[hashCode];
        entry.opCode = opCode;
        entry.left = operand;
        entry.intOperand = result2;
        if (entry.result != null) {
            entry.result = null;
            --this.opCacheOccupied;
        }
        return result2;
    }

    void rehashOpCache() {
        ++this.opCacheBitsCount;
        this.opCache = new OpCacheEntry[1 << this.opCacheBitsCount];
        for (int i = 0; i < this.opCache.length; ++i) {
            this.opCache[i] = new OpCacheEntry();
        }
        this.opCacheOccupied = 0;
        this.opCacheTreshold = 1 << this.opCacheBitsCount + 1 > this.maxOpCacheSize ? this.opCache.length + 1 : (int)((double)(1 << this.opCacheBitsCount) * 0.75);
    }

    BDDJavaImpl searchInNodeCache(int var, BDDJavaImpl low, BDDJavaImpl high, int hashCode) {
        BDDJavaImpl result2 = this.nodeCache[hashCode];
        while (result2 != null) {
            if (result2.var == var && result2.low == low && result2.high == high) {
                --low.refCount;
                --high.refCount;
                ++result2.refCount;
                return result2;
            }
            result2 = result2.link;
        }
        return null;
    }

    BDDJavaImpl putInNodeCache(BDDJavaImpl node, int hashCode) {
        node.link = this.nodeCache[hashCode];
        this.nodeCache[hashCode] = node;
        ++this.nodeCacheOccupied;
        if (this.nodeCacheOccupied > this.nodeCacheTreshold) {
            this.rehashNodeCache();
        }
        return node;
    }

    void rehashNodeCache() {
        ++this.nodeCacheBitsCount;
        BDDJavaImpl[] newCache = new BDDJavaImpl[1 << this.nodeCacheBitsCount];
        BDDJavaImpl[] bDDJavaImplArray = this.nodeCache;
        int n = bDDJavaImplArray.length;
        for (int i = 0; i < n; ++i) {
            BDDJavaImpl aNodeCache;
            BDDJavaImpl cur = aNodeCache = bDDJavaImplArray[i];
            while (cur != null) {
                BDDJavaImpl next = cur.link;
                int newIndex = this.nodeHashCode(cur.var, cur.low, cur.high);
                cur.link = newCache[newIndex];
                newCache[newIndex] = cur;
                cur = next;
            }
        }
        this.nodeCache = newCache;
        this.nodeCacheTreshold = 1 << this.nodeCacheBitsCount + 1 > this.maxNodeCacheSize ? Integer.MAX_VALUE : (int)((double)(1 << this.nodeCacheBitsCount) * 0.75);
    }

    @Override
    public void init(IConfigs configs) {
        this.serialID = this.curSerialID++;
        if (configs != null) {
            this.maxNodeCacheSize = configs.getIntValue("BDDMaxNodeCacheSize", 10000000);
            this.maxOpCacheSize = configs.getIntValue("BDDMaxOpCacheSize", 1000000);
            this.garbageCollectRate = configs.getIntValue("BDDGarbageCollectRate", 0);
            this.enableGC = configs.getBooleanValue("BDDEnableGC", true);
        } else {
            this.maxNodeCacheSize = 10000000;
            this.maxOpCacheSize = 1000000;
            this.garbageCollectRate = 0;
            this.enableGC = true;
        }
        this.synchronizeOnGC = this.garbageCollectRate > 0;
        this.garbageCollectCounter = 0;
        this.nodeCacheBitsCount = 7;
        this.nodeCache = new BDDJavaImpl[1 << this.nodeCacheBitsCount];
        this.nodeCacheTreshold = (int)((double)(1 << this.nodeCacheBitsCount) * 0.75);
        this.nodeCacheOccupied = 0;
        this.opCacheBitsCount = 7;
        this.opCache = new OpCacheEntry[1 << this.opCacheBitsCount];
        this.opCacheOccupied = 0;
        this.opCacheTreshold = (int)((double)(1 << this.opCacheBitsCount) * 0.75);
        for (int i = 0; i < this.opCache.length; ++i) {
            this.opCache[i] = new OpCacheEntry();
        }
        Arrays.fill(this.nodeCache, null);
        this.totalNodesAllocated = 0;
        this.curSerialID = 0;
        this.firstFreeNode = null;
        this.zero = new BDDJavaImpl();
        this.zero.var = 0x7FFFFFFE;
        this.zero.mark = true;
        this.zero.serialID = this.curSerialID++;
        this.zero.manager = this;
        this.one = new BDDJavaImpl();
        this.one.var = Integer.MAX_VALUE;
        this.one.mark = true;
        this.one.manager = this;
        this.zero.serialID = this.curSerialID++;
        this.finalizedNodes = new ArrayList<BDDJavaImpl>();
    }

    @Override
    public String[] getInfo() {
        this.collectGarbage();
        return new String[]{Messages.getString(BDDJavaImpl.class.getName() + "-0") + this.nodeCacheOccupied, Messages.getString(BDDJavaImpl.class.getName() + "-1") + this.totalNodesAllocated, Messages.getString(BDDJavaImpl.class.getName() + "-2") + Formatter.formatSize(this.nodeCache.length * 4), Messages.getString(BDDJavaImpl.class.getName() + "-3") + Formatter.formatSize(this.opCache.length * 36), Messages.getString(BDDJavaImpl.class.getName() + "-4") + Formatter.formatSize(this.totalNodesAllocated * 40)};
    }

    @Override
    public int getMemoryState() {
        return this.totalNodesAllocated * 40 + this.nodeCache.length * 4 + this.opCache.length * 36;
    }

    BDDJavaImpl cacheNode(int var, BDDJavaImpl low, BDDJavaImpl high) {
        if (low == high) {
            --low.refCount;
            return low;
        }
        int hashCode = this.nodeHashCode(var, low, high);
        BDDJavaImpl node = this.searchInNodeCache(var, low, high, hashCode);
        if (node != null) {
            return node;
        }
        if (this.garbageCollectCounter++ == this.garbageCollectRate) {
            this.garbageCollectCounter = 0;
            this.collectGarbage();
        }
        if (this.firstFreeNode != null) {
            node = this.firstFreeNode;
            this.firstFreeNode = this.firstFreeNode.link;
        } else {
            node = new BDDJavaImpl();
            node.manager = this;
            ++this.totalNodesAllocated;
        }
        node.refCount = 1;
        if (node.low != null) {
            this.doDecRefCount(node.low);
        }
        if (node.high != null) {
            this.doDecRefCount(node.high);
        }
        node.serialID = this.curSerialID++;
        node.var = var;
        node.low = low;
        node.high = high;
        return this.putInNodeCache(node, hashCode);
    }

    private void doDecRefCount(BDDJavaImpl node) {
        --node.refCount;
        if (node == this.zero || node == this.one || !this.enableGC) {
            return;
        }
        if (node.refCount < 0) {
            throw new BDDException(Messages.getString(BDDJavaImpl.class.getName() + "-5"));
        }
        if (node.refCount == 0) {
            node.serialID = -1;
            int hashCode = this.nodeHashCode(node.var, node.low, node.high);
            if (this.nodeCache[hashCode] == node) {
                this.nodeCache[hashCode] = node.link;
                --this.nodeCacheOccupied;
            } else if (this.nodeCache[hashCode] != null) {
                BDDJavaImpl cur = this.nodeCache[hashCode];
                BDDJavaImpl next = cur.link;
                while (next != null) {
                    if (next == node) {
                        cur.link = next.link;
                        --this.nodeCacheOccupied;
                        break;
                    }
                    cur = next;
                    next = next.link;
                }
                if (next == null) {
                    throw new BDDException(Messages.getString(BDDJavaImpl.class.getName() + "-6"));
                }
            }
            node.link = this.firstFreeNode;
            this.firstFreeNode = node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRefCount(BDDJavaImpl node) {
        if (!this.enableGC) {
            return;
        }
        if (this.synchronizeOnGC) {
            List<BDDJavaImpl> list = this.finalizedNodes;
            synchronized (list) {
                this.finalizedNodes.add(node);
            }
        } else {
            this.finalizedNodes.add(node);
        }
    }

    @Override
    public void startInit() {
    }

    @Override
    public int getManagerSerialID() {
        return this.serialID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectGarbage() {
        if (!this.finalizedNodes.isEmpty()) {
            if (this.synchronizeOnGC) {
                List<BDDJavaImpl> list = this.finalizedNodes;
                synchronized (list) {
                    for (BDDJavaImpl finalizedNode : this.finalizedNodes) {
                        this.doDecRefCount(finalizedNode);
                    }
                    this.finalizedNodes.clear();
                }
            } else {
                for (BDDJavaImpl finalizedNode : this.finalizedNodes) {
                    this.doDecRefCount(finalizedNode);
                }
                this.finalizedNodes.clear();
            }
        }
        if (this.totalNodesAllocated * 40 > 100000000) {
            throw new BDDMemoryOverflowException(this.totalNodesAllocated * 40);
        }
    }

    void checkGC(List<BDDJavaImpl> roots, Console console) {
        for (BDDJavaImpl root4 : roots) {
            --root4.refCount;
        }
        for (BDDJavaImpl root3 : roots) {
            if (root3.refCount == 0) continue;
            throw new BDDException(Messages.getString(BDDJavaImpl.class.getName() + "-7"));
        }
        for (BDDJavaImpl root2 : roots) {
            ++root2.refCount;
        }
        int reachable = 0;
        for (BDDJavaImpl root1 : roots) {
            reachable = (int)((long)reachable + root1.evaluateReachableNodesCnt());
        }
        for (BDDJavaImpl root : roots) {
            root.unMark();
        }
        this.collectGarbage();
        console.println(Messages.getString(BDDJavaImpl.class.getName() + "-8") + reachable);
        console.println(Messages.getString(BDDJavaImpl.class.getName() + "-9") + this.nodeCacheOccupied);
        console.println(Messages.getString(BDDJavaImpl.class.getName() + "-10") + this.totalNodesAllocated);
    }

    @Override
    public boolean decRefCountOnGC() {
        return this.synchronizeOnGC;
    }

    @Override
    public IBDD getZero() {
        return this.zero;
    }

    @Override
    public IBDD getOne() {
        return this.one;
    }

    @Override
    public BDDJavaImpl makeEquals(int var1, int var2) {
        if (var1 < var2) {
            return this.cacheNode(var1, this.cacheNode(var2, this.one, this.zero), this.cacheNode(var2, this.zero, this.one));
        }
        return this.cacheNode(var2, this.cacheNode(var1, this.one, this.zero), this.cacheNode(var1, this.zero, this.one));
    }

    @Override
    public BDDJavaImpl makeSingleTuple(int start, int length, int value) {
        BDDJavaImpl result2 = this.one;
        for (int i = 0; i < length; ++i) {
            int position = start + length - i - 1;
            result2 = (value & 1 << i) > 0 ? this.cacheNode(position, this.zero, result2) : this.cacheNode(position, result2, this.zero);
        }
        return result2;
    }

    @Override
    public BDDJavaImpl makeLessEqu(int start, int length, int value) {
        BDDJavaImpl result2 = this.one;
        for (int i = 0; i < length; ++i) {
            int position = start + length - i - 1;
            result2 = (value & 1 << i) > 0 ? this.cacheNode(position, this.one, result2) : this.cacheNode(position, result2, this.zero);
        }
        return result2;
    }

    @Override
    public BDDJavaImpl makeMoreEqu(int start, int length, int value) {
        BDDJavaImpl result2 = this.one;
        for (int i = 0; i < length; ++i) {
            int position = start + length - i - 1;
            result2 = (value & 1 << i) > 0 ? this.cacheNode(position, this.zero, result2) : this.cacheNode(position, result2, this.one);
        }
        return result2;
    }

    @Override
    public BDDJavaImpl makeSingleTuple(int[] starts, int[] lengths, int[] values) {
        BDDJavaImpl result2 = this.one;
        for (int i = starts.length - 1; i >= 0; --i) {
            for (int j = 0; j < lengths[i]; ++j) {
                int position = starts[i] + lengths[i] - j - 1;
                result2 = (values[i] & 1 << j) > 0 ? this.cacheNode(position, this.zero, result2) : this.cacheNode(position, result2, this.zero);
            }
        }
        return result2;
    }

    @Override
    public void serialize(ObjectOutputStream out, IBDD[] nodes, ThreadCallback threadCallback, double progressPart, String message) throws IOException {
        BDDJavaImpl.serialize(out, nodes, threadCallback, progressPart, message);
    }

    @Override
    public IBDD[] deserialize(ObjectInputStream in, ThreadCallback threadCallback, double progressPart, String message) throws IOException, ClassNotFoundException {
        return BDDJavaImpl.deserialize(in, threadCallback, progressPart, message);
    }

    private static class OpCacheEntry {
        int opCode;
        int leftSerialID;
        int rightSerialID;
        int resultSerialID;
        int intOperand;
        BDDJavaImpl left;
        BDDJavaImpl right;
        BDDJavaImpl result;

        private OpCacheEntry() {
        }
    }
}

