/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnvironmentProblems {
    @NotNull
    private final List<String> myProblems = new SmartList();

    public void addProblem(@NotNull String problem) {
        if (problem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/jetbrains/cidr/toolchains/EnvironmentProblems", "addProblem"));
        }
        this.myProblems.add(problem);
    }

    public boolean hasProblems() {
        return !this.myProblems.isEmpty();
    }

    @NotNull
    public List<String> getProblems() {
        List<String> list = Collections.unmodifiableList(this.myProblems);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/EnvironmentProblems", "getProblems"));
        }
        return list;
    }

    public void throwAsExecutionException() throws ExecutionException {
        if (this.hasProblems()) {
            throw new ExecutionException(this.formatProblems());
        }
    }

    @NotNull
    private String formatProblems() {
        String string = StringUtil.join(this.myProblems, (String)"<br>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/EnvironmentProblems", "formatProblems"));
        }
        return string;
    }
}

