/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.compiler.CidrCompilerResult;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPathTree;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.toolchains.CidrCompiler;
import com.jetbrains.cidr.toolchains.CompilerInfo;
import com.jetbrains.cidr.toolchains.GCCCompiler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerInfoCache {
    private static final ThreadPoolExecutor ourExecutor = CompilerInfoCache.createExecutor(CompilerInfoCache.defaultMaxProcesses(Runtime.getRuntime().availableProcessors()));
    @NotNull
    private final Map<String, CidrCompilerResult<Entry>> myCache = new ConcurrentHashMap<String, CidrCompilerResult<Entry>>();
    @NotNull
    private final Map<String, Future<CidrCompilerResult<Entry>>> myInProcess = new HashMap<String, Future<CidrCompilerResult<Entry>>>();
    @NotNull
    private final Object myLock = new Object();

    static int defaultMaxProcesses(int availableProcessors) {
        return Math.max(1, (int)Math.floor((double)availableProcessors * 0.8));
    }

    @NotNull
    static ThreadPoolExecutor createExecutor(int maxProcesses) {
        ThreadFactory factory = ConcurrencyUtil.newNamedThreadFactory((String)"CompilerInfoCache pooled thread");
        ThreadPoolExecutor executor = new ThreadPoolExecutor(maxProcesses, maxProcesses, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        executor.allowCoreThreadTimeOut(true);
        ThreadPoolExecutor threadPoolExecutor = executor;
        if (threadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "createExecutor"));
        }
        return threadPoolExecutor;
    }

    public boolean isEmpty() {
        return this.myCache.isEmpty();
    }

    @NotNull
    public CidrCompilerResult<Entry> getCompilerInfoCache(@NotNull Project project, @NotNull OCCompilerSettings compilerSettings, @NotNull OCLanguageKind lang, @Nullable VirtualFile sourceFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        if (compilerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerSettings", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        File compilerExecutable = compilerSettings.getCompilerExecutable(lang);
        if (compilerExecutable == null) {
            CidrCompilerResult<Entry> cidrCompilerResult = CidrCompilerResult.create(Entry.EMPTY);
            if (cidrCompilerResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
            }
            return cidrCompilerResult;
        }
        GCCCompiler compiler = new GCCCompiler(compilerExecutable, compilerSettings.getCompilerWorkingDir());
        CidrCompilerResult<Entry> cidrCompilerResult = this.getCompilerInfoCache(project, compiler, compilerSettings, lang, sourceFile, ourExecutor);
        if (cidrCompilerResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        return cidrCompilerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    CidrCompilerResult<Entry> getCompilerInfoCache(final @NotNull Project project, final @NotNull CidrCompiler compiler, final @NotNull OCCompilerSettings compilerSettings, final @NotNull OCLanguageKind lang, @Nullable VirtualFile sourceFile, @NotNull ThreadPoolExecutor executor) {
        CidrCompilerResult<Entry> cidrCompilerResult;
        Future<CidrCompilerResult<Entry>> processing;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        if (compilerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerSettings", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        final Pair<String, CidrCompilerSwitches> keyAndSwitches = compilerSettings.getCompilerKeyAndSwitches(lang, sourceFile);
        final String key = (String)keyAndSwitches.first;
        CidrCompilerResult<Entry> cached = this.myCache.get(key);
        if (cached != null) {
            CidrCompilerResult<Entry> cidrCompilerResult2 = cached;
            if (cidrCompilerResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
            }
            return cidrCompilerResult2;
        }
        Object object = this.myLock;
        synchronized (object) {
            cached = this.myCache.get(key);
            if (cached != null) {
                CidrCompilerResult<Entry> cidrCompilerResult3 = cached;
                // MONITOREXIT @DISABLED, blocks:[3, 11] lbl24 : MonitorExitStatement: MONITOREXIT : var11_10
                if (cidrCompilerResult3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
                }
                return cidrCompilerResult3;
            }
            processing = this.myInProcess.get(key);
            if (processing == null) {
                processing = executor.submit(new Callable<CidrCompilerResult<Entry>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public CidrCompilerResult<Entry> call() throws Exception {
                        CidrCompilerResult result2 = CompilerInfoCache.doCollectCompilerInfo(project, compiler, compilerSettings, lang, (CidrCompilerSwitches)keyAndSwitches.second);
                        Object object = CompilerInfoCache.this.myLock;
                        synchronized (object) {
                            CompilerInfoCache.this.myCache.put(key, result2);
                            CompilerInfoCache.this.myInProcess.remove(key);
                        }
                        return result2;
                    }
                });
                this.myInProcess.put(key, processing);
            }
        }
        while (true) {
            ProgressManager.checkCanceled();
            try {
                cidrCompilerResult = processing.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
        if (cidrCompilerResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "getCompilerInfoCache"));
        }
        return cidrCompilerResult;
    }

    @NotNull
    private static CidrCompilerResult<Entry> doCollectCompilerInfo(@NotNull Project project, @NotNull CidrCompiler compiler, @NotNull OCCompilerSettings compilerSettings, @NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches) {
        CidrCompilerResult<Entry> cidrCompilerResult;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "doCollectCompilerInfo"));
        }
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "doCollectCompilerInfo"));
        }
        if (compilerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerSettings", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "doCollectCompilerInfo"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "doCollectCompilerInfo"));
        }
        if (switches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switches", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "doCollectCompilerInfo"));
        }
        try {
            CompilerInfo info = compiler.collectInfo(lang, switches, compilerSettings.getEnvironment());
            HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
            for (HeadersSearchPath each : info.getHeadersSearchPaths()) {
                pathTree.addSearchPathCompacting(each);
            }
            List<HeadersSearchPath> compacted = pathTree.getCompactedPaths();
            ArrayList resultPaths = new ArrayList(compacted.size());
            for (HeadersSearchPath eachPath : compacted) {
                ContainerUtil.addIfNotNull(resultPaths, (Object)((Object)HeadersSearchRoot.createFromHeaderSearchPath(project, eachPath)));
            }
            cidrCompilerResult = CidrCompilerResult.create(new Entry(info.getDefines(), info.getFeatures(), info.getExtensions(), info.getAttributes(), resultPaths));
        }
        catch (com.intellij.execution.ExecutionException e) {
            CidrCompilerResult<Entry> cidrCompilerResult2 = CidrCompilerResult.error(e);
            if (cidrCompilerResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "doCollectCompilerInfo"));
            }
            return cidrCompilerResult2;
        }
        if (cidrCompilerResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/toolchains/CompilerInfoCache", "doCollectCompilerInfo"));
        }
        return cidrCompilerResult;
    }

    public static class Entry {
        public static Entry EMPTY = new Entry("", Collections.<String, String>emptyMap(), Collections.<String, String>emptyMap(), Collections.<String, String>emptyMap(), Collections.<HeadersSearchRoot>emptyList());
        @NotNull
        public final String defines;
        @NotNull
        public final Map<String, String> features;
        @NotNull
        public final Map<String, String> extensions;
        @NotNull
        public final Map<String, String> attributes;
        @NotNull
        public final List<HeadersSearchRoot> headerSearchPaths;

        private Entry(@NotNull String defines, @NotNull Map<String, String> features, @NotNull Map<String, String> extensions, @NotNull Map<String, String> attributes, @NotNull List<HeadersSearchRoot> headerSearchPaths) {
            if (defines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defines", "com/jetbrains/cidr/toolchains/CompilerInfoCache$Entry", "<init>"));
            }
            if (features == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "features", "com/jetbrains/cidr/toolchains/CompilerInfoCache$Entry", "<init>"));
            }
            if (extensions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/jetbrains/cidr/toolchains/CompilerInfoCache$Entry", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/toolchains/CompilerInfoCache$Entry", "<init>"));
            }
            if (headerSearchPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerSearchPaths", "com/jetbrains/cidr/toolchains/CompilerInfoCache$Entry", "<init>"));
            }
            this.defines = defines;
            this.features = features;
            this.extensions = extensions;
            this.attributes = attributes;
            this.headerSearchPaths = Collections.unmodifiableList(headerSearchPaths);
        }
    }
}

