/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.PathTree;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRootsSynchronizer
implements Disposable {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final ModuleType myModuleType;
    @Nullable
    private Set<LocalFileSystem.WatchRequest> myWatchRequest;

    public CidrRootsSynchronizer(@NotNull Project project, @NotNull ModuleType moduleType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/project/CidrRootsSynchronizer", "<init>"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/jetbrains/cidr/project/CidrRootsSynchronizer", "<init>"));
        }
        this.myProject = project;
        this.myModuleType = moduleType;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public void dispose() {
        this.registerWatchRoots(Collections.<File>emptyList());
    }

    public void updateRoots(@NotNull RootsInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/cidr/project/CidrRootsSynchronizer", "updateRoots"));
        }
        Module module = this.getModule();
        if (module != null) {
            CidrRootsSynchronizer.registerRoots(ModuleRootManager.getInstance((Module)module), info);
        }
        this.registerWatchRoots(info.watchRoots);
    }

    @Nullable
    public Module getModule() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!this.myModuleType.equals((Object)ModuleType.get((Module)module))) continue;
            return module;
        }
        return null;
    }

    private void registerWatchRoots(@NotNull List<File> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/cidr/project/CidrRootsSynchronizer", "registerWatchRoots"));
        }
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequest);
            this.myWatchRequest = null;
        }
        if (!roots.isEmpty()) {
            Function<File, String> paths = new Function<File, String>(){

                public String fun(File file2) {
                    return file2.getPath();
                }
            };
            this.myWatchRequest = LocalFileSystem.getInstance().addRootsToWatch((Collection)ContainerUtil.map(roots, (Function)paths), true);
        }
    }

    private static void registerRoots(@NotNull ModuleRootManager rootManager, final @NotNull RootsInfo info) {
        if (rootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootManager", "com/jetbrains/cidr/project/CidrRootsSynchronizer", "registerRoots"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/cidr/project/CidrRootsSynchronizer", "registerRoots"));
        }
        RootTree tree = new RootTree();
        tree.addAll(info.contentRoots, RootKind.CONTENT);
        tree.addAll(info.sourceFiles, RootKind.SOURCE);
        tree.addAll(info.explicitLibraryRoots, RootKind.EXPLICIT_LIBRARY);
        tree.addAll(info.explicitExcludeFolders, RootKind.EXPLICIT_EXCLUDE);
        tree.addAll(info.headerSearchRoots.systemHeaderRoots, RootKind.LIBRARY);
        tree.addAll(info.headerSearchRoots.excludeRoots, RootKind.LIBRARY_EXCLUDE);
        tree.addAll(CidrRootsSynchronizer.removeDuplicatesAndSubdirs(info.headerSearchRoots.userHeaderRoots), RootKind.CONTENT);
        final ModifiableRootModel model = rootManager.getModifiableModel();
        model.clear();
        LibraryTable table = model.getModuleLibraryTable();
        Library library = table.createLibrary(CidrBundle.message("project.view.library.node", new Object[0]));
        final LibraryEx.ModifiableModelEx libraryModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        tree.accept(new RootTree.Visitor(){
            final Stack<State> stack = new Stack();
            State state;

            @Override
            public void enter() {
                this.stack.push(this.state);
                this.state = this.state == null ? new State() : new State(this.state);
            }

            @Override
            public boolean visit(@NotNull Set<RootItem> items) {
                RootItem explicitLibraryItem;
                if (items == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/cidr/project/CidrRootsSynchronizer$2", "visit"));
                }
                if (items.isEmpty()) {
                    return true;
                }
                RootItem excludeItem = this.find(items, RootKind.EXPLICIT_EXCLUDE);
                if (excludeItem != null) {
                    if (this.state.contentEntry != null) {
                        this.state.contentEntry.addExcludeFolder(excludeItem.getUrl());
                    }
                    if (this.state.libraryRoot != null) {
                        libraryModel.addExcludedRoot(excludeItem.getUrl());
                        this.state.libraryRoot = null;
                    }
                    return false;
                }
                if (this.state.libraryRoot == RootKind.EXPLICIT_LIBRARY) {
                    return true;
                }
                RootItem contentItem = this.find(items, RootKind.CONTENT);
                if (contentItem != null && this.state.contentEntry == null) {
                    this.state.contentEntry = model.addContentEntry(contentItem.getUrl());
                    if (this.state.libraryRoot != null) {
                        libraryModel.addExcludedRoot(contentItem.getUrl());
                        this.state.libraryRoot = null;
                    }
                }
                if ((explicitLibraryItem = this.find(items, RootKind.EXPLICIT_LIBRARY)) != null) {
                    if (this.state.libraryRoot == null) {
                        String libraryRootUrl = explicitLibraryItem.getUrl();
                        libraryModel.addRoot(libraryRootUrl, OrderRootType.CLASSES);
                        libraryModel.addRoot(libraryRootUrl, OrderRootType.SOURCES);
                        this.state.libraryRoot = explicitLibraryItem.kind;
                    }
                    return true;
                }
                RootItem sourceItem = this.find(items, RootKind.SOURCE);
                if (sourceItem != null) {
                    if (this.state.contentEntry == null) {
                        this.state.contentEntry = model.addContentEntry(sourceItem.getUrl());
                    }
                    if (this.state.sourceFolder == null) {
                        this.state.sourceFolder = this.state.contentEntry.addSourceFolder(sourceItem.getUrl(), false);
                    }
                    if (this.state.libraryRoot != null) {
                        libraryModel.addExcludedRoot(sourceItem.getUrl());
                        this.state.libraryRoot = null;
                    }
                    return true;
                }
                if (info.registerSystemHeaderRootUnderContentRootAsLibraries || this.state.contentEntry == null) {
                    RootItem libraryItem;
                    RootItem libraryExclude = this.find(items, RootKind.LIBRARY_EXCLUDE);
                    if (libraryExclude != null && this.state.libraryRoot != null) {
                        libraryModel.addExcludedRoot(libraryExclude.getUrl());
                        this.state.libraryRoot = null;
                    } else if (contentItem == null && (libraryItem = this.find(items, RootKind.LIBRARY)) != null && this.state.libraryRoot == null) {
                        String libraryRootUrl = libraryItem.getUrl();
                        libraryModel.addRoot(libraryRootUrl, OrderRootType.CLASSES);
                        libraryModel.addRoot(libraryRootUrl, OrderRootType.SOURCES);
                        this.state.libraryRoot = libraryItem.kind;
                    }
                }
                return true;
            }

            @Nullable
            private RootItem find(Set<RootItem> items, RootKind kind) {
                for (RootItem each : items) {
                    if (each.kind != kind) continue;
                    return each;
                }
                return null;
            }

            @Override
            public void exit() {
                this.state = this.stack.pop();
            }

            class State {
                @Nullable
                ContentEntry contentEntry;
                @Nullable
                SourceFolder sourceFolder;
                @Nullable
                ExcludeFolder excludeFolder;
                @Nullable
                RootKind libraryRoot;

                public State() {
                }

                public State(State other) {
                    this.contentEntry = other.contentEntry;
                    this.sourceFolder = other.sourceFolder;
                    this.excludeFolder = other.excludeFolder;
                    this.libraryRoot = other.libraryRoot;
                }
            }
        });
        libraryModel.commit();
        if (model.isChanged()) {
            model.commit();
        } else {
            model.dispose();
        }
    }

    public static void collectHeaderSearchRoots(@NotNull Collection<? extends HeadersSearchRoot> headerRoots, final @NotNull HeaderSearchRoots result2) {
        if (headerRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerRoots", "com/jetbrains/cidr/project/CidrRootsSynchronizer", "collectHeaderSearchRoots"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/project/CidrRootsSynchronizer", "collectHeaderSearchRoots"));
        }
        for (final HeadersSearchRoot headersSearchRoot : headerRoots) {
            headersSearchRoot.processChildren(new HeadersSearchRootProcessor(){

                @Override
                public boolean shouldProcessRootsOnly() {
                    return true;
                }

                @Override
                public boolean processFramework(@NotNull VirtualFile frameworkRoot) {
                    if (frameworkRoot == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkRoot", "com/jetbrains/cidr/project/CidrRootsSynchronizer$3", "processFramework"));
                    }
                    result2.excludeRoots.add(new File(frameworkRoot.getPath()));
                    return true;
                }

                @Override
                public boolean process(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/project/CidrRootsSynchronizer$3", "process"));
                    }
                    if (file2.isDirectory()) {
                        if (headersSearchRoot.isUserHeaders()) {
                            result2.userHeaderRoots.add(new File(file2.getPath()));
                        } else {
                            result2.systemHeaderRoots.add(new File(file2.getPath()));
                        }
                    }
                    return true;
                }
            });
        }
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file2) {
        return CidrRootsSynchronizer.isUnder(parents, file2, false);
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file2, boolean strict) {
        if (parents == null || file2 == null) {
            return false;
        }
        for (File parent : parents) {
            if (!FileUtil.isAncestor((File)parent, (File)file2, (boolean)strict)) continue;
            return true;
        }
        return false;
    }

    private static List<File> removeDuplicatesAndSubdirs(Collection<File> files) {
        ArrayList answer = ContainerUtil.newArrayList(files);
        Collections.sort(answer, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return FileUtil.compareFiles((File)o1, (File)o2);
            }
        });
        Iterator it = answer.iterator();
        File prev = null;
        while (it.hasNext()) {
            File next = (File)it.next();
            if (prev != null && FileUtil.isAncestor((File)prev, (File)next, (boolean)false)) {
                it.remove();
                continue;
            }
            prev = next;
        }
        return answer;
    }

    private static class RootTree
    extends PathTree<RootTree, RootItem> {
        private RootTree() {
        }

        @Override
        protected RootTree createNewTree(@Nullable RootTree parent) {
            return new RootTree();
        }

        public void addAll(@NotNull Collection<File> files, @NotNull RootKind kind) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/cidr/project/CidrRootsSynchronizer$RootTree", "addAll"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/project/CidrRootsSynchronizer$RootTree", "addAll"));
            }
            for (File each : files) {
                this.addItem(each.getPath(), new RootItem(each, kind));
            }
        }

        public void accept(@NotNull Visitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/project/CidrRootsSynchronizer$RootTree", "accept"));
            }
            visitor.enter();
            if (visitor.visit(this.getItems())) {
                for (RootTree each : this.getChildren()) {
                    each.accept(visitor);
                }
            }
            visitor.exit();
        }

        public static interface Visitor {
            public void enter();

            public boolean visit(@NotNull Set<RootItem> var1);

            public void exit();
        }
    }

    private static class RootItem {
        @NotNull
        final File file;
        @NotNull
        final RootKind kind;

        public RootItem(@NotNull File file2, @NotNull RootKind kind) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/project/CidrRootsSynchronizer$RootItem", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/project/CidrRootsSynchronizer$RootItem", "<init>"));
            }
            this.kind = kind;
            this.file = file2;
        }

        @NotNull
        String getUrl() {
            String string = VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.file.getPath()));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/project/CidrRootsSynchronizer$RootItem", "getUrl"));
            }
            return string;
        }
    }

    private static enum RootKind {
        CONTENT,
        SOURCE,
        LIBRARY,
        LIBRARY_EXCLUDE,
        EXPLICIT_SOURCE,
        EXPLICIT_LIBRARY,
        EXPLICIT_EXCLUDE;

    }

    public static class RootsInfo {
        @NotNull
        public final List<File> watchRoots = new ArrayList<File>();
        @NotNull
        public final List<File> contentRoots = new ArrayList<File>();
        @NotNull
        public final List<File> sourceFiles = new ArrayList<File>();
        @NotNull
        public final List<File> explicitSourceFolders = new ArrayList<File>();
        @NotNull
        public final List<File> explicitLibraryRoots = new ArrayList<File>();
        @NotNull
        public final List<File> explicitExcludeFolders = new ArrayList<File>();
        @NotNull
        public final HeaderSearchRoots headerSearchRoots = new HeaderSearchRoots();
        public boolean registerSystemHeaderRootUnderContentRootAsLibraries = true;

        public void fillHeaderSearchRoots(@NotNull Collection<? extends HeadersSearchRoot> headerRoots) {
            if (headerRoots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerRoots", "com/jetbrains/cidr/project/CidrRootsSynchronizer$RootsInfo", "fillHeaderSearchRoots"));
            }
            CidrRootsSynchronizer.collectHeaderSearchRoots(headerRoots, this.headerSearchRoots);
        }
    }

    public static class HeaderSearchRoots {
        @NotNull
        public final List<File> systemHeaderRoots = new ArrayList<File>();
        @NotNull
        public final List<File> userHeaderRoots = new ArrayList<File>();
        @NotNull
        public final List<File> excludeRoots = new ArrayList<File>();
    }
}

