/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import icons.CidrLangIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AppleFramework
extends HeadersSearchRoot {
    public static boolean SORTED_ITERATION = ApplicationManager.getApplication().isUnitTestMode();
    public static final String HEADERS_DIR_NAME = "Headers";
    public static final String PRIVATE_HEADERS_DIR_NAME = "PrivateHeaders";
    public static final String[] HEADERS_DIR_NAMES = new String[]{"Headers", "PrivateHeaders"};
    @NotNull
    private final String myName;
    static final Condition<VirtualFile> FRAMEWORK_CONDITION = new Condition<VirtualFile>(){

        public boolean value(VirtualFile file2) {
            return file2.isDirectory() && file2.getName().endsWith(".framework");
        }
    };
    private static final Comparator<VirtualFile> FILE_NAME_COMPARATOR = new Comparator<VirtualFile>(){

        @Override
        public int compare(VirtualFile f1, VirtualFile f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };

    protected AppleFramework(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework", "<init>"));
        }
        super(project);
        this.myName = name;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework", "getName"));
        }
        return string;
    }

    @Nullable
    public abstract PsiFileSystemItem getParentSdkOrFrameworkItem();

    public boolean isLibrary() {
        return false;
    }

    @Nullable
    public abstract VirtualFile getMainFile();

    @Nullable
    public static VirtualFile getFrameworkMainFile(@Nullable VirtualFile frameworkPath) {
        return frameworkPath == null ? null : frameworkPath.findFileByRelativePath("Headers/" + frameworkPath.getNameWithoutExtension() + ".h");
    }

    public abstract boolean containsHeader(@Nullable VirtualFile var1);

    public boolean process(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework", "process"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework", "process"));
        }
        if (!processed.add(this.getName())) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            return this.processChildren(processor2);
        }
        return AppleFramework.processFileSystemItem(processor2, this);
    }

    public static boolean processFrameworksUnder(@NotNull PsiFileSystemItem parentSdkOrFramework, @Nullable VirtualFile root, @NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed) {
        if (parentSdkOrFramework == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSdkOrFramework", "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework", "processFrameworksUnder"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework", "processFrameworksUnder"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework", "processFrameworksUnder"));
        }
        if (root != null && root.isDirectory()) {
            List frameworks = ContainerUtil.filter((Object[])root.getChildren(), FRAMEWORK_CONDITION);
            if (SORTED_ITERATION) {
                Collections.sort(frameworks, FILE_NAME_COMPARATOR);
            }
            for (VirtualFile frameworkPath : frameworks) {
                RealFramework framework = new RealFramework(parentSdkOrFramework.getProject(), frameworkPath, parentSdkOrFramework);
                if (framework.process(processor2, processed)) continue;
                return false;
            }
        }
        return true;
    }

    public Icon getIcon(int flags) {
        return CidrLangIcons.Framework;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AppleFramework framework = (AppleFramework)((Object)o);
        return this.myName.equals(framework.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }
}

