/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCCompilerProperty;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInitialInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompilerHelper {
    private static final Key<Map<OCCompilerProperty.PropertyKey, Object>> ENABLED_PROPERTIES = Key.create((String)"ENABLED_PROPERTIES");

    private OCCompilerHelper() {
    }

    @Contract(value="null,null,_->null")
    @Nullable
    public static <T> T getPropertyForFile(@Nullable PsiFile file2, @Nullable OCImmutableInclusionContext fileContext, @NotNull OCCompilerProperty.PropertyKey key) {
        T value;
        Project project;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "getPropertyForFile"));
        }
        if (file2 == null && fileContext == null) {
            return null;
        }
        if (fileContext == null) {
            if (!(file2 instanceof OCFile)) {
                return null;
            }
            fileContext = OCInclusionContextUtil.headerContext(file2);
        }
        if ((project = fileContext.getProject()) != null && (value = OCCompilerHelper.getHint(project, key)) != null) {
            return value;
        }
        return OCInitialInclusionContext.getPropertyFromInitialContext(key, fileContext);
    }

    @Deprecated
    @Nullable
    public static OCCompilerKind getCompiler(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        OCImmutableInclusionContext inclusionContext = OCInclusionContextUtil.headerContext(file2);
        OCResolveConfiguration configuration = inclusionContext.getConfiguration();
        return configuration != null ? configuration.getCompilerSettings().getCompiler(inclusionContext.getLanguageKind()) : null;
    }

    @Contract(value="null,_->false")
    public static boolean isFeatureEnabled(@Nullable PsiFile file2, @NotNull OCCompilerProperty.PropertyKey feature) {
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "isFeatureEnabled"));
        }
        return OCCompilerHelper.getPropertyForFile(file2, null, feature) == Boolean.TRUE;
    }

    @Contract(value="null,_->false")
    public static boolean isFeatureEnabled(@Nullable OCImmutableInclusionContext context, @NotNull OCCompilerProperty.PropertyKey feature) {
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "isFeatureEnabled"));
        }
        return OCCompilerHelper.getPropertyForFile(null, context, feature) == Boolean.TRUE;
    }

    @Contract(value="null,_->false")
    public static boolean isWarningEnabled(@Nullable PsiFile file2, @NotNull OCCompilerProperty.PropertyKey warning) {
        if (warning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warning", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "isWarningEnabled"));
        }
        return OCCompilerHelper.getPropertyForFile(file2, null, warning) == Boolean.TRUE;
    }

    public static void enableARC(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableARC"));
        }
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.OBJC_ARC, value);
    }

    public static boolean isArcDisabled(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "isArcDisabled"));
        }
        return OCCompilerHelper.getPropertyForFile(file2, null, OCCompilerProperty.PropertyKey.OBJC_ARC) == Boolean.FALSE;
    }

    public static boolean isArcEnabled(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "isArcEnabled"));
        }
        return OCCompilerHelper.getPropertyForFile(file2, null, OCCompilerProperty.PropertyKey.OBJC_ARC) == Boolean.TRUE;
    }

    public static boolean supportsIvarsInImplementation() {
        return true;
    }

    public static boolean supportsIvarsInCategories() {
        return true;
    }

    public static boolean supportsLaterMethodDeclaration() {
        return true;
    }

    public static boolean supportsAutosynthesis(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsAutosynthesis(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerHelper.isFeatureEnabled(context, OCCompilerProperty.PropertyKey.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsNullability(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.NULLABILITY);
    }

    public static boolean supportsNullability(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerHelper.isFeatureEnabled(context, OCCompilerProperty.PropertyKey.NULLABILITY);
    }

    public static boolean supportsMicrosoftAttributes(@Nullable PsiFile file2) {
        return OCCompilerHelper.getCompiler(file2) == OCCompilerKind.CLANG;
    }

    public static boolean supportsUnderlyingType(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.UNDERLYING_TYPE);
    }

    public static void enableUnderlyingType(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableUnderlyingType"));
        }
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.UNDERLYING_TYPE, value);
    }

    public static void enableAutosynthesis(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableAutosynthesis"));
        }
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES, value);
    }

    public static boolean supportsExplicitAtomic(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_PROPERTY_EXPLICIT_ATOMIC);
    }

    public static void enableExplicitAtomic(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableExplicitAtomic"));
        }
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.OBJC_PROPERTY_EXPLICIT_ATOMIC, value);
    }

    public static boolean supportsInstancetype(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_INSTANCETYPE);
    }

    public static void enableInstancetype(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableInstancetype"));
        }
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.OBJC_INSTANCETYPE, value);
    }

    public static boolean supportsSubscripting(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_SUBSCRIPTING);
    }

    public static void enableSubscripting(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableSubscripting"));
        }
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.OBJC_SUBSCRIPTING, value);
    }

    public static boolean supportsObjectLiterals(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_ARRAY_LITERALS) && OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_DICTIONARY_LITERALS);
    }

    public static void enableObjectLiterals(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableObjectLiterals"));
        }
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.OBJC_ARRAY_LITERALS, value);
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.OBJC_DICTIONARY_LITERALS, value);
    }

    public static boolean supportsCxxAutoType(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_AUTO_TYPE);
    }

    public static void enableCxxAutoType(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableCxxAutoType"));
        }
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.CXX_AUTO_TYPE, value);
    }

    public static boolean supportsOverrideControl(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_OVERRIDE_CONTROL);
    }

    public static boolean supportsInitializerLists(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_GENERALIZED_INITIALIZERS);
    }

    public static boolean supportsNullptr(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_NULLPTR);
    }

    public static boolean supportsInClassInitialization(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_NONSTATIC_MEMBER_INIT);
    }

    public static boolean doesEmptyReturnFromNonVoidProduceError(@Nullable PsiFile file2) {
        return OCCompilerHelper.isWarningEnabled(file2, OCCompilerProperty.PropertyKey.ERROR_RETURN_TYPE);
    }

    public static void enableNullability(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableNullability"));
        }
        OCCompilerHelper.enableContextProperty(project, OCCompilerProperty.PropertyKey.NULLABILITY, value);
    }

    @Nullable
    public static <T> T getHint(@NotNull Project project, @NotNull OCCompilerProperty.PropertyKey feature) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "getHint"));
        }
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "getHint"));
        }
        Map features = (Map)ENABLED_PROPERTIES.get((UserDataHolder)project);
        return features == null ? null : (T)features.get((Object)feature);
    }

    public static void enableContextProperty(@NotNull Project project, OCCompilerProperty.PropertyKey feature, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "enableContextProperty"));
        }
        ConcurrentHashMap<OCCompilerProperty.PropertyKey, Boolean> enabledFeatures = (ConcurrentHashMap<OCCompilerProperty.PropertyKey, Boolean>)ENABLED_PROPERTIES.get((UserDataHolder)project);
        if (enabledFeatures == null) {
            enabledFeatures = new ConcurrentHashMap<OCCompilerProperty.PropertyKey, Boolean>();
            project.putUserData(ENABLED_PROPERTIES, enabledFeatures);
        }
        enabledFeatures.put(feature, value);
    }

    public static void resetStoredProperties(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerHelper", "resetStoredProperties"));
        }
        project.putUserData(ENABLED_PROPERTIES, null);
    }
}

