/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWorkspaceUtil {
    @NotNull
    public static String getConfigurationDisplayName(@Nullable String targetName, @NotNull String configName, boolean shorten) {
        if (configName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configName", "com/jetbrains/cidr/lang/workspace/OCWorkspaceUtil", "getConfigurationDisplayName"));
        }
        String string = targetName != null ? targetName + " [" + (shorten ? StringUtil.first((String)configName, (int)1, (boolean)false) : configName) + "]" : configName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCWorkspaceUtil", "getConfigurationDisplayName"));
        }
        return string;
    }

    public static int compareConfigurations(@NotNull OCResolveConfiguration a, @NotNull OCResolveConfiguration b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/jetbrains/cidr/lang/workspace/OCWorkspaceUtil", "compareConfigurations"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/jetbrains/cidr/lang/workspace/OCWorkspaceUtil", "compareConfigurations"));
        }
        return a.getDisplayName(false).compareToIgnoreCase(b.getDisplayName(false));
    }

    @NotNull
    public static OCLanguageKind getMaximumLanguageKind(@NotNull Collection<OCLanguageKind> all, @NotNull Project project) {
        if (all == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "all", "com/jetbrains/cidr/lang/workspace/OCWorkspaceUtil", "getMaximumLanguageKind"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/OCWorkspaceUtil", "getMaximumLanguageKind"));
        }
        CLanguageKind result2 = null;
        for (OCLanguageKind each : all) {
            if (result2 != null && (!(each instanceof CLanguageKind) || ((CLanguageKind)each).ordinal() <= result2.ordinal())) continue;
            result2 = (CLanguageKind)each;
        }
        CLanguageKind cLanguageKind = result2 == null ? CLanguageKind.maxLanguage(project) : result2;
        if (cLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCWorkspaceUtil", "getMaximumLanguageKind"));
        }
        return cLanguageKind;
    }
}

