/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKindProvider;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageKindCalculator {
    public static final Key<Boolean> FORCE_FILE_TYPE_IN_TESTS = Key.create((String)"FORCE_FILE_TYPE_IN_TESTS");

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKindFast"));
        }
        Project project = file2.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (virtualFile != null) {
            OCFile associated;
            OCLanguageKind result2 = OCLanguageKindCalculator.tryFileTypeAndExtension(project, virtualFile);
            if (result2 != null) {
                OCLanguageKind oCLanguageKind = result2;
                if (oCLanguageKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKindFast"));
                }
                return oCLanguageKind;
            }
            if (file2 instanceof OCFile && OCInclusionContextUtil.isNeedToFindRoot(file2) && (associated = ((OCFile)file2).getAssociatedFileWithSameName()) != null && !OCInclusionContextUtil.isNeedToFindRoot(associated)) {
                OCLanguageKind oCLanguageKind = OCLanguageKindCalculator.calculateLanguageKindFast(associated);
                if (oCLanguageKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKindFast"));
                }
                return oCLanguageKind;
            }
        } else {
            String name = file2.getName();
            OCLanguageKind result3 = OCLanguageKindCalculator.tryFileExtension(project, name);
            if (result3 != null) {
                OCLanguageKind oCLanguageKind = result3;
                if (oCLanguageKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKindFast"));
                }
                return oCLanguageKind;
            }
        }
        CLanguageKind cLanguageKind = CLanguageKind.maxLanguage(project);
        if (cLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKindFast"));
        }
        return cLanguageKind;
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        OCLanguageKind result2 = OCLanguageKindCalculator.trySpecifiedFileType(project, file2);
        if (result2 != null) {
            return result2;
        }
        result2 = OCLanguageKindCalculator.tryFileExtension(project, file2.getName());
        if (result2 != null) {
            return result2;
        }
        if (file2.getUserData(FORCE_FILE_TYPE_IN_TESTS) == Boolean.TRUE) {
            String ext = file2.getExtension();
            for (OCLanguageKind kind : OCLanguageKindProvider.getAllLanguageKinds()) {
                if (!kind.getDefaultSourceExtension().equalsIgnoreCase(ext)) continue;
                return kind;
            }
        }
        return null;
    }

    @Nullable
    private static OCLanguageKind trySpecifiedFileType(@Nullable Project project, @Nullable VirtualFile file2) {
        if (project == null || file2 == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result2 = each.getSpecifiedLanguage(project, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind tryFileExtension(@Nullable Project project, @Nullable String name) {
        if (project == null || name == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result2 = each.getLanguageByExtension(project, name);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    private static OCLanguageKindCalculatorHelper[] getHelpers() {
        OCLanguageKindCalculatorHelper[] oCLanguageKindCalculatorHelperArray = (OCLanguageKindCalculatorHelper[])Extensions.getExtensions(OCLanguageKindCalculatorHelper.EP_NAME);
        if (oCLanguageKindCalculatorHelperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "getHelpers"));
        }
        return oCLanguageKindCalculatorHelperArray;
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@NotNull OCFile file2) {
        PsiFile containingFile;
        PsiElement context;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
        }
        if (file2 instanceof OCCodeFragment && (context = file2.getContext()) != null && (containingFile = context.getContainingFile()) instanceof OCFile) {
            OCLanguageKind oCLanguageKind = OCLanguageKindCalculator.calculateLanguageKind((OCFile)containingFile);
            if (oCLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
            }
            return oCLanguageKind;
        }
        Project project = file2.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (virtualFile == null) {
            String name = file2.getName();
            OCLanguageKind result2 = OCLanguageKindCalculator.tryFileExtension(project, name);
            if (result2 != null) {
                OCLanguageKind oCLanguageKind = result2;
                if (oCLanguageKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
                }
                return oCLanguageKind;
            }
            CLanguageKind cLanguageKind = CLanguageKind.maxLanguage(project);
            if (cLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
            }
            return cLanguageKind;
        }
        OCLanguageKind oCLanguageKind = OCLanguageKindCalculator.calculateLanguageKind(OCInclusionContextUtil.getActiveConfiguration(file2), virtualFile, project);
        if (oCLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
        }
        return oCLanguageKind;
    }

    @NotNull
    private static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration activeConfig, @NotNull VirtualFile file2, @NotNull Project project) {
        OCLanguageKind result2;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
        }
        if (activeConfig != null) {
            result2 = activeConfig.getDeclaredLanguageKind(file2);
            if (result2 != null) {
                OCLanguageKind oCLanguageKind = result2;
                if (oCLanguageKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
                }
                return oCLanguageKind;
            }
            if (OCInclusionContext.isPrecompiledHeader(file2, activeConfig)) {
                OCLanguageKind oCLanguageKind = activeConfig.getPrecompiledLanguageKind();
                if (oCLanguageKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
                }
                return oCLanguageKind;
            }
        }
        if ((result2 = OCLanguageKindCalculator.tryFileTypeAndExtension(project, file2)) != null) {
            OCLanguageKind oCLanguageKind = result2;
            if (oCLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
            }
            return oCLanguageKind;
        }
        if (OCInclusionContextUtil.isNeedToFindRoot(file2, project)) {
            OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(file2, project);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCResolveConfiguration rootConfig = rootAndConfiguration.getConfiguration();
            if (rootFile != null && rootConfig != null && !rootFile.equals(file2)) {
                result2 = OCLanguageKindCalculator.tryLanguageKindFromPchRoot(rootConfig, file2, rootFile);
                if (result2 != null) {
                    OCLanguageKind oCLanguageKind = result2;
                    if (oCLanguageKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
                    }
                    return oCLanguageKind;
                }
                OCLanguageKind oCLanguageKind = OCLanguageKindCalculator.calculateLanguageKind(rootConfig, rootFile, project);
                if (oCLanguageKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
                }
                return oCLanguageKind;
            }
        }
        OCLanguageKind oCLanguageKind = activeConfig != null ? activeConfig.getMaximumLanguageKind() : CLanguageKind.maxLanguage(project);
        if (oCLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "calculateLanguageKind"));
        }
        return oCLanguageKind;
    }

    @Nullable
    public static OCLanguageKind tryLanguageKindFromPchRoot(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "tryLanguageKindFromPchRoot"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "tryLanguageKindFromPchRoot"));
        }
        if (pchCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pchCandidate", "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator", "tryLanguageKindFromPchRoot"));
        }
        OCImmutableInclusionContext cachedContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, header, pchCandidate);
        return cachedContext != null ? cachedContext.getLanguageKind() : null;
    }
}

