/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.jetbrains.cidr.lang.lexer.OCHighlightingLexer;
import com.jetbrains.cidr.lang.lexer.OCRawStringLexerBase;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCCharLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringLiteralUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.util.OCStringLiteralUtil");
    static final Map<String, OCStringPrefix> STR_PREFIX_TYPE = new HashMap<String, OCStringPrefix>(OCStringPrefix.values().length, 1.0f);
    static final Map<String, OCCharType> CHAR_PREFIX_TYPE = new HashMap<String, OCCharType>(4, 1.0f);

    public static boolean isStringLiteralPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "isStringLiteralPrefix"));
        }
        return STR_PREFIX_TYPE.containsKey(prefix);
    }

    @NotNull
    public static OCStringLiteral concatStrings(@NotNull OCStringLiteral left, @NotNull OCStringLiteral right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "concatStrings"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "concatStrings"));
        }
        if (left == OCStringLiteral.BAD_LITERAL) {
            OCStringLiteral oCStringLiteral = right;
            if (oCStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "concatStrings"));
            }
            return oCStringLiteral;
        }
        if (left.prefix.encoding == right.prefix.encoding || left.prefix.encoding == OCEncoding.NONE || right.prefix.encoding == OCEncoding.NONE) {
            OCStringPrefix newPrefix;
            OCStringPrefix oCStringPrefix = newPrefix = left.prefix.encoding != OCEncoding.NONE ? left.prefix : right.prefix;
            if (right.prefix.isRaw || left.prefix.isRaw) {
                newPrefix = OCStringPrefix.setRaw(newPrefix, true);
            }
            String newContents = left.getContents(!newPrefix.isRaw) + right.getContents(!newPrefix.isRaw);
            OCStringLiteral oCStringLiteral = new OCStringLiteral(newPrefix, newContents);
            if (oCStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "concatStrings"));
            }
            return oCStringLiteral;
        }
        OCStringPrefix newPrefix = OCStringPrefix.setRaw(left.prefix, false);
        String rightContents = newPrefix.encoding.getString(right.prefix.encoding.getBytes(right.getContents(false)));
        String newContents = left.getContents(true) + StringUtil.escapeStringCharacters((String)rightContents);
        OCStringLiteral oCStringLiteral = new OCStringLiteral(newPrefix, newContents);
        if (oCStringLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "concatStrings"));
        }
        return oCStringLiteral;
    }

    @NotNull
    public static OCStringLiteral parseStringLiteral(@Nullable String literalText) {
        String contents;
        if (literalText == null) {
            OCStringLiteral oCStringLiteral = OCStringLiteral.BAD_LITERAL;
            if (oCStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseStringLiteral"));
            }
            return oCStringLiteral;
        }
        int length = literalText.length();
        if (length == 0) {
            OCStringLiteral oCStringLiteral = OCStringLiteral.BAD_LITERAL;
            if (oCStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseStringLiteral"));
            }
            return oCStringLiteral;
        }
        int quoteChar = 34;
        int firstQuotePos = literalText.indexOf(34);
        if (firstQuotePos == -1) {
            LOG.warn("String literal without quote (lexer problem?)");
            OCStringLiteral oCStringLiteral = OCStringLiteral.BAD_LITERAL;
            if (oCStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseStringLiteral"));
            }
            return oCStringLiteral;
        }
        String prefixString = literalText.substring(0, firstQuotePos);
        OCStringPrefix prefix = STR_PREFIX_TYPE.get(prefixString);
        if (prefix == null) {
            OCStringLiteral oCStringLiteral = OCStringLiteral.BAD_LITERAL;
            if (oCStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseStringLiteral"));
            }
            return oCStringLiteral;
        }
        if (firstQuotePos == length - 1) {
            contents = "";
        } else {
            contents = literalText.substring(firstQuotePos + 1);
            if (prefix.isRaw) {
                OCRawStringLexerBase lexer = OCHighlightingLexer.createRawStringLexer();
                lexer.start(literalText, firstQuotePos, length);
                contents = lexer.getRawText();
            } else if (literalText.charAt(length - 1) == '\"') {
                contents = contents.substring(0, contents.length() - 1);
            }
        }
        OCStringLiteral oCStringLiteral = new OCStringLiteral(prefix, contents);
        if (oCStringLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseStringLiteral"));
        }
        return oCStringLiteral;
    }

    @NotNull
    public static OCCharLiteral parseCharLiteral(@Nullable String literalText) {
        String contents;
        if (literalText == null) {
            OCCharLiteral oCCharLiteral = OCCharLiteral.BAD_LITERAL;
            if (oCCharLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseCharLiteral"));
            }
            return oCCharLiteral;
        }
        int length = literalText.length();
        if (length == 0) {
            OCCharLiteral oCCharLiteral = OCCharLiteral.BAD_LITERAL;
            if (oCCharLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseCharLiteral"));
            }
            return oCCharLiteral;
        }
        int quoteChar = 39;
        int firstQuotePos = literalText.indexOf(39);
        if (firstQuotePos == -1) {
            LOG.warn("String literal without quote (lexer problem?)");
            OCCharLiteral oCCharLiteral = OCCharLiteral.BAD_LITERAL;
            if (oCCharLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseCharLiteral"));
            }
            return oCCharLiteral;
        }
        String prefixString = literalText.substring(0, firstQuotePos);
        OCCharType charType = CHAR_PREFIX_TYPE.get(prefixString);
        if (charType == null) {
            OCCharLiteral oCCharLiteral = OCCharLiteral.BAD_LITERAL;
            if (oCCharLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseCharLiteral"));
            }
            return oCCharLiteral;
        }
        if (firstQuotePos == length - 1) {
            contents = "";
        } else {
            contents = literalText.substring(firstQuotePos + 1);
            if (literalText.charAt(length - 1) == '\'') {
                contents = contents.substring(0, contents.length() - 1);
            }
        }
        if (prefixString.isEmpty() && contents.length() > 1) {
            charType = OCCharType.MULTICHAR_LITERAL;
        }
        OCCharLiteral oCCharLiteral = new OCCharLiteral(charType, prefixString, contents);
        if (oCCharLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "parseCharLiteral"));
        }
        return oCCharLiteral;
    }

    @NotNull
    public static String unescapeStringCharactersEx(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "unescapeStringCharactersEx"));
        }
        StringBuilder buffer = new StringBuilder();
        int length = s.length();
        int count = 0;
        int radix = 0;
        int suffixLen = 0;
        boolean decode = false;
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '?': {
                    buffer.append('?');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'v': {
                    buffer.append('\u000b');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    count = 3;
                    radix = 8;
                    suffixLen = 0;
                    decode = true;
                    break;
                }
                case 'x': {
                    count = 2;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'u': {
                    count = 4;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'U': {
                    count = 8;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            if (decode) {
                decode = false;
                StringBuilder sb = new StringBuilder(count);
                for (int pos = idx + suffixLen; pos < length && count > 0; --count, ++pos) {
                    char chl = s.charAt(pos);
                    if (!(radix == 16 && StringUtil.isHexDigit((char)chl) || radix == 8 && StringUtil.isOctalDigit((char)chl))) break;
                    sb.append(chl);
                }
                if (sb.length() != 0) {
                    try {
                        long code = Long.parseLong(sb.toString(), radix);
                        idx += sb.length() + suffixLen - 1;
                        buffer.append((char)code);
                    }
                    catch (NumberFormatException e) {
                        buffer.append('\\').append(ch);
                    }
                } else {
                    buffer.append('\\').append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil", "unescapeStringCharactersEx"));
        }
        return string;
    }

    static {
        for (OCStringPrefix prefix : OCStringPrefix.values()) {
            STR_PREFIX_TYPE.put(prefix.prefix, prefix);
        }
        CHAR_PREFIX_TYPE.put("", OCCharType.CHAR_LITERAL);
        CHAR_PREFIX_TYPE.put("L", OCCharType.WCHAR_LITERAL);
        CHAR_PREFIX_TYPE.put("u", OCCharType.CHAR16_LITERAL);
        CHAR_PREFIX_TYPE.put("U", OCCharType.CHAR32_LITERAL);
    }

    public static enum OCCharType {
        CHAR_LITERAL(OCIntType.INT, OCIntType.CHAR),
        MULTICHAR_LITERAL(OCIntType.INT),
        WCHAR_LITERAL(OCIntType.WCHAR),
        CHAR16_LITERAL(OCIntType.CHAR16),
        CHAR32_LITERAL(OCIntType.CHAR32);

        @NotNull
        public final OCIntType typePlainC;
        @NotNull
        public final OCIntType typeCpp;

        private OCCharType(OCIntType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil$OCCharType", "<init>"));
            }
            this(type, type);
        }

        private OCCharType(OCIntType typePlainC, OCIntType typeCpp) {
            if (typePlainC == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePlainC", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil$OCCharType", "<init>"));
            }
            if (typeCpp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCpp", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil$OCCharType", "<init>"));
            }
            this.typePlainC = typePlainC;
            this.typeCpp = typeCpp;
        }
    }

    public static enum OCStringPrefix {
        PREFIX_EMPTY("", false, OCEncoding.NONE, OCIntType.CHAR, OCIntType.CHAR_CONST),
        PREFIX_R("R", true, OCEncoding.NONE, OCIntType.CHAR, OCIntType.CHAR_CONST),
        PREFIX_L("L", false, OCEncoding.WCHAR, OCIntType.WCHAR, OCIntType.WCHAR_CONST),
        PREFIX_LR("LR", true, OCEncoding.WCHAR, OCIntType.WCHAR, OCIntType.WCHAR_CONST),
        PREFIX_u8("u8", false, OCEncoding.UTF8, OCIntType.CHAR, OCIntType.CHAR_CONST),
        PREFIX_u8R("u8R", true, OCEncoding.UTF8, OCIntType.CHAR, OCIntType.CHAR_CONST),
        PREFIX_u("u", false, OCEncoding.UTF16, OCIntType.CHAR16, OCIntType.CHAR16_CONST),
        PREFIX_uR("uR", true, OCEncoding.UTF16, OCIntType.CHAR16, OCIntType.CHAR16_CONST),
        PREFIX_U("U", false, OCEncoding.UTF32, OCIntType.CHAR32, OCIntType.CHAR32_CONST),
        PREFIX_UR("UR", true, OCEncoding.UTF32, OCIntType.CHAR32, OCIntType.CHAR32_CONST);

        @NotNull
        public final String prefix;
        public final boolean isRaw;
        @NotNull
        public final OCEncoding encoding;
        @NotNull
        public final OCIntType charTypePlainC;
        @NotNull
        public final OCIntType charTypeCpp;

        private OCStringPrefix(@NotNull String prefix, @NotNull boolean isRaw, @NotNull OCEncoding encoding, OCIntType charTypePlainC, OCIntType charTypeCpp) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil$OCStringPrefix", "<init>"));
            }
            if (encoding == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil$OCStringPrefix", "<init>"));
            }
            if (charTypePlainC == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charTypePlainC", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil$OCStringPrefix", "<init>"));
            }
            if (charTypeCpp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charTypeCpp", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil$OCStringPrefix", "<init>"));
            }
            this.prefix = prefix;
            this.isRaw = isRaw;
            this.encoding = encoding;
            this.charTypePlainC = charTypePlainC;
            this.charTypeCpp = charTypeCpp;
        }

        public static OCStringPrefix setRaw(OCStringPrefix prefix, boolean raw) {
            if (raw) {
                switch (prefix) {
                    case PREFIX_EMPTY: {
                        return PREFIX_R;
                    }
                    case PREFIX_L: {
                        return PREFIX_LR;
                    }
                    case PREFIX_u8: {
                        return PREFIX_u8R;
                    }
                    case PREFIX_u: {
                        return PREFIX_uR;
                    }
                    case PREFIX_U: {
                        return PREFIX_UR;
                    }
                }
                return prefix;
            }
            switch (prefix) {
                case PREFIX_R: {
                    return PREFIX_EMPTY;
                }
                case PREFIX_LR: {
                    return PREFIX_L;
                }
                case PREFIX_u8R: {
                    return PREFIX_u8;
                }
                case PREFIX_uR: {
                    return PREFIX_u;
                }
                case PREFIX_UR: {
                    return PREFIX_U;
                }
            }
            return prefix;
        }
    }

    public static enum OCEncoding {
        NONE(Charset.forName("US-ASCII")),
        WCHAR(CharsetToolkit.UTF_16LE_CHARSET),
        UTF8(CharsetToolkit.UTF8_CHARSET),
        UTF16(CharsetToolkit.UTF_16LE_CHARSET),
        UTF32(CharsetToolkit.UTF_32LE_CHARSET);

        @NotNull
        private final Charset charset;

        private OCEncoding(Charset charset) {
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/jetbrains/cidr/lang/util/OCStringLiteralUtil$OCEncoding", "<init>"));
            }
            this.charset = charset;
        }

        public byte[] getBytes(String contents) {
            return contents.getBytes(this.charset);
        }

        public String getString(byte[] bytes) {
            return this.charset.decode(ByteBuffer.wrap(bytes)).toString();
        }
    }
}

