/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import org.jetbrains.annotations.NotNull;

public class OCStringLiteral
implements OCLiteral {
    public static final OCStringLiteral BAD_LITERAL = new OCStringLiteral(OCStringLiteralUtil.OCStringPrefix.PREFIX_EMPTY, "");
    @NotNull
    public final OCStringLiteralUtil.OCStringPrefix prefix;
    @NotNull
    public final String contents;

    public OCStringLiteral(@NotNull OCStringLiteralUtil.OCStringPrefix prefix, @NotNull String contents) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/cidr/lang/util/OCStringLiteral", "<init>"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/jetbrains/cidr/lang/util/OCStringLiteral", "<init>"));
        }
        this.prefix = prefix;
        this.contents = contents;
    }

    public String getContents(boolean escaped) {
        if (this.prefix.isRaw != escaped) {
            return this.contents;
        }
        if (escaped) {
            return StringUtil.escapeStringCharacters((String)this.contents);
        }
        return OCStringLiteralUtil.unescapeStringCharactersEx(this.contents);
    }

    @NotNull
    public OCIntType getElementType(boolean isPlainOldC) {
        OCIntType oCIntType = isPlainOldC ? this.prefix.charTypePlainC : this.prefix.charTypeCpp;
        if (oCIntType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteral", "getElementType"));
        }
        return oCIntType;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull PsiFile file2, boolean isPlainOldC) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/util/OCStringLiteral", "getType"));
        }
        OCArrayType oCArrayType = OCArrayType.to((OCType)this.getElementType(isPlainOldC), this.getContentLengthInCharacters());
        if (oCArrayType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCStringLiteral", "getType"));
        }
        return oCArrayType;
    }

    public int getContentLengthInCharacters() {
        String unescapedContents = this.getContents(false);
        if (this.prefix.encoding == OCStringLiteralUtil.OCEncoding.UTF8) {
            byte[] encodedContents = this.prefix.encoding.getBytes(unescapedContents);
            return encodedContents.length + 1;
        }
        return unescapedContents.length() + 1;
    }

    public String toString() {
        return "OCStringLiteral{prefix=" + (Object)((Object)this.prefix) + ", contents='" + this.contents + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCStringLiteral literal = (OCStringLiteral)o;
        if (this.prefix != literal.prefix) {
            return false;
        }
        return this.contents.equals(literal.contents);
    }

    public int hashCode() {
        int result2 = this.prefix.hashCode();
        result2 = 31 * result2 + this.contents.hashCode();
        return result2;
    }
}

