/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.OCLog;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public class OCNumber
extends BigInteger {
    public static final byte[] MINUS_ONE = new byte[]{-1};
    public static final OCNumber MAX_UINT32_T = new OCNumber(MINUS_ONE, 4, true);
    public static final OCNumber MAX_UINT64_T = new OCNumber(MINUS_ONE, 8, true);
    public static final OCNumber MAX_UINT128_T = new OCNumber(MINUS_ONE, 16, true);
    private static final OCNumber[] SIZE2MASK = new OCNumber[16];
    private final int mySizeInBytes;
    private final boolean myIsSigned;

    public static OCNumber getMask(int sizeInBytes) {
        OCNumber ret = SIZE2MASK[(sizeInBytes = Math.min(sizeInBytes, 16)) - 1];
        if (ret == null) {
            OCNumber.SIZE2MASK[sizeInBytes - 1] = ret = new OCNumber(StringUtil.repeat((String)"FF", (int)sizeInBytes), 16, sizeInBytes, true);
        }
        return ret;
    }

    public OCNumber(byte[] bytes, int sizeInBytes, boolean isSigned) {
        super(bytes);
        this.mySizeInBytes = sizeInBytes;
        this.myIsSigned = isSigned;
    }

    protected OCNumber(String val, int radix, int sizeInBytes, boolean isSigned) {
        super(val, radix);
        this.mySizeInBytes = sizeInBytes;
        this.myIsSigned = isSigned;
    }

    public int getSizeInBytes() {
        return this.mySizeInBytes;
    }

    public boolean isSigned() {
        return this.myIsSigned;
    }

    public static OCNumber parse(String literalText, int sizeInBytes, boolean isSigned) throws NumberFormatException {
        ParseInfo pi = ParseInfo.parse(literalText);
        BigInteger number = new BigInteger(pi.numbers, pi.radix);
        return OCNumber.convert(pi.negative ? number.negate() : number, sizeInBytes, isSigned);
    }

    @Override
    public OCNumber negate() {
        return OCNumber.convert(super.negate(), this);
    }

    public OCNumber inverse() {
        return OCNumber.convert(super.xor(OCNumber.getMask(this.mySizeInBytes)), this);
    }

    @Override
    @NotNull
    public OCNumber add(@NotNull BigInteger arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/util/OCNumber", "add"));
        }
        OCNumber oCNumber = OCNumber.convert(super.add(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "add"));
        }
        return oCNumber;
    }

    @Override
    @NotNull
    public OCNumber subtract(@NotNull BigInteger arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/util/OCNumber", "subtract"));
        }
        OCNumber oCNumber = OCNumber.convert(super.subtract(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "subtract"));
        }
        return oCNumber;
    }

    @Override
    @NotNull
    public OCNumber multiply(@NotNull BigInteger arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/util/OCNumber", "multiply"));
        }
        OCNumber oCNumber = OCNumber.convert(super.multiply(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "multiply"));
        }
        return oCNumber;
    }

    @Override
    @NotNull
    public OCNumber divide(@NotNull BigInteger arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/util/OCNumber", "divide"));
        }
        OCNumber oCNumber = OCNumber.convert(super.divide(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "divide"));
        }
        return oCNumber;
    }

    @Override
    @NotNull
    public OCNumber mod(@NotNull BigInteger arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/util/OCNumber", "mod"));
        }
        OCNumber oCNumber = OCNumber.convert(super.mod(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "mod"));
        }
        return oCNumber;
    }

    @Override
    @NotNull
    public OCNumber or(@NotNull BigInteger arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/util/OCNumber", "or"));
        }
        OCNumber oCNumber = OCNumber.convert(super.or(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "or"));
        }
        return oCNumber;
    }

    @Override
    @NotNull
    public OCNumber and(@NotNull BigInteger arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/util/OCNumber", "and"));
        }
        OCNumber oCNumber = OCNumber.convert(super.and(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "and"));
        }
        return oCNumber;
    }

    @Override
    @NotNull
    public OCNumber xor(@NotNull BigInteger arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/util/OCNumber", "xor"));
        }
        OCNumber oCNumber = OCNumber.convert(super.xor(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "xor"));
        }
        return oCNumber;
    }

    @Override
    @NotNull
    public OCNumber shiftLeft(int arg) {
        OCNumber oCNumber = OCNumber.convert(super.shiftLeft(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "shiftLeft"));
        }
        return oCNumber;
    }

    @Override
    @NotNull
    public OCNumber shiftRight(int arg) {
        OCNumber oCNumber = OCNumber.convert(super.shiftRight(arg), this.maskHolder(arg));
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "shiftRight"));
        }
        return oCNumber;
    }

    @Override
    public int compareTo(@NotNull BigInteger arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/util/OCNumber", "compareTo"));
        }
        OCNumber maskHolder = this.maskHolder(arg);
        if (!maskHolder.myIsSigned) {
            int sigThis = this.signum();
            int sigArg = arg.signum();
            if (sigThis >= 0 && sigArg >= 0) {
                return super.compareTo(arg);
            }
            if (sigThis <= 0 && sigArg <= 0) {
                OCNumber narg = OCNumber.valueOf(arg);
                if (narg.mySizeInBytes == this.mySizeInBytes) {
                    return -super.compareTo(arg);
                }
                if (this.mySizeInBytes > narg.mySizeInBytes) {
                    return narg.myIsSigned ? -super.compareTo(arg) : 1;
                }
                return this.myIsSigned ? -super.compareTo(arg) : -1;
            }
            if (sigThis < 0 && sigArg >= 0) {
                return 1;
            }
            if (sigThis >= 0 && sigArg < 0) {
                return -1;
            }
            assert (false);
        }
        return super.compareTo(arg);
    }

    @Override
    public String toString(int radix) {
        return new BigInteger(this.toByteArray()).toString(radix);
    }

    public String toHexString() {
        return "0x" + super.and(OCNumber.getMask(this.mySizeInBytes)).toString(16) + (this.myIsSigned ? "i" : "u") + this.mySizeInBytes * 8;
    }

    private OCNumber maskHolder(Number arg) {
        if (arg instanceof OCNumber) {
            OCNumber holder = (OCNumber)arg;
            if (holder.mySizeInBytes > this.mySizeInBytes) {
                return holder;
            }
            if (holder.mySizeInBytes == this.mySizeInBytes && !holder.myIsSigned) {
                return holder;
            }
        }
        return this;
    }

    @NotNull
    private static OCNumber convert(@NotNull BigInteger value, OCNumber typeHolder) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/util/OCNumber", "convert"));
        }
        OCNumber oCNumber = OCNumber.convert(value, typeHolder.mySizeInBytes, typeHolder.myIsSigned);
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "convert"));
        }
        return oCNumber;
    }

    @NotNull
    public static OCNumber convert(@NotNull BigInteger value, int sizeInBytes, boolean isSigned) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/util/OCNumber", "convert"));
        }
        byte[] be_bytes = value.toByteArray();
        if (be_bytes.length > sizeInBytes) {
            byte[] new_bytes = new byte[sizeInBytes];
            System.arraycopy(be_bytes, be_bytes.length - sizeInBytes, new_bytes, 0, sizeInBytes);
            be_bytes = new_bytes;
        }
        OCNumber oCNumber = new OCNumber(be_bytes, sizeInBytes, isSigned);
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "convert"));
        }
        return oCNumber;
    }

    @NotNull
    public static OCNumber valueOf(long value) {
        OCNumber oCNumber = OCNumber.valueOf((Object)value);
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "valueOf"));
        }
        return oCNumber;
    }

    @NotNull
    public static OCNumber valueOf(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/cidr/lang/util/OCNumber", "valueOf"));
        }
        if (o instanceof OCNumber) {
            OCNumber oCNumber = (OCNumber)o;
            if (oCNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "valueOf"));
            }
            return oCNumber;
        }
        if (o instanceof BigInteger) {
            OCNumber oCNumber = OCNumber.convert((BigInteger)o, 16, true);
            if (oCNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "valueOf"));
            }
            return oCNumber;
        }
        int byteCount = 0;
        long val = 0L;
        if (o instanceof Boolean) {
            byteCount = 1;
            val = (Boolean)o != false ? 1L : 0L;
        } else if (o instanceof Byte) {
            byteCount = 1;
            val = ((Byte)o).longValue();
        } else if (o instanceof Short) {
            byteCount = 2;
            val = ((Short)o).longValue();
        } else if (o instanceof Integer) {
            byteCount = 4;
            val = ((Integer)o).longValue();
        } else if (o instanceof Long || o instanceof Number) {
            byteCount = 8;
            val = ((Number)o).longValue();
        }
        if (byteCount > 0) {
            byte[] be_bytes = new byte[byteCount];
            for (int i = 0; i < byteCount; ++i) {
                be_bytes[i] = (byte)(val >> (byteCount - 1 - i << 3));
            }
            OCNumber oCNumber = new OCNumber(be_bytes, byteCount, true);
            if (oCNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "valueOf"));
            }
            return oCNumber;
        }
        OCLog.LOG.warn("Unknown type in OCNumber.valueOf:" + o.getClass());
        OCNumber oCNumber = MAX_UINT128_T;
        if (oCNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCNumber", "valueOf"));
        }
        return oCNumber;
    }

    public static final class ParseInfo {
        public int radix = 10;
        public String numbers;
        public int countL = 0;
        public int countU = 0;
        public boolean negative = false;

        public static ParseInfo parse(String literalText) throws NumberFormatException {
            int pos;
            ParseInfo pi = new ParseInfo();
            for (pos = literalText.length() - 1; pos >= 0; --pos) {
                char ch = literalText.charAt(pos);
                if (ch == 'L' || ch == 'l') {
                    ++pi.countL;
                    continue;
                }
                if (ch == 'U' || ch == 'u') {
                    ++pi.countU;
                    continue;
                }
                if (!StringUtil.isHexDigit((char)ch)) continue;
                ++pos;
                break;
            }
            literalText = literalText.substring(0, pos);
            int index = 0;
            if (literalText.length() == 0) {
                throw new NumberFormatException("Zero length string");
            }
            char firstChar = literalText.charAt(0);
            if (firstChar == '-') {
                pi.negative = true;
                ++index;
            } else if (firstChar == '+') {
                ++index;
            }
            if (literalText.startsWith("0x", index) || literalText.startsWith("0X", index)) {
                index += 2;
                pi.radix = 16;
            } else if (literalText.startsWith("0b", index) || literalText.startsWith("0B", index)) {
                index += 2;
                pi.radix = 2;
            } else if (literalText.startsWith("0", index) && literalText.length() > 1 + index) {
                ++index;
                pi.radix = 8;
            }
            if (literalText.startsWith("-", index) || literalText.startsWith("+", index)) {
                throw new NumberFormatException("Sign character in wrong position");
            }
            pi.numbers = literalText.substring(index);
            return pi;
        }
    }
}

