/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCMostlySingularMultiUniqueMap<K, V>
extends MostlySingularMultiMap<K, V> {
    private final TObjectHashingStrategy<? super V> myValueEqualityStrategy;
    protected final Set<V> myAllValues;

    public OCMostlySingularMultiUniqueMap() {
        this(TObjectHashingStrategy.CANONICAL);
    }

    public OCMostlySingularMultiUniqueMap(TObjectHashingStrategy<? super V> valueEqualityStrategy) {
        this.myValueEqualityStrategy = valueEqualityStrategy;
        this.myAllValues = this.createSet();
    }

    @NotNull
    protected Set<V> createSet() {
        THashSet tHashSet = new THashSet(this.myValueEqualityStrategy);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCMostlySingularMultiUniqueMap", "createSet"));
        }
        return tHashSet;
    }

    public void add(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/lang/util/OCMostlySingularMultiUniqueMap", "add"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/util/OCMostlySingularMultiUniqueMap", "add"));
        }
        if (this.myAllValues.add(value)) {
            super.add(key, value);
        }
    }

    public boolean processAllValues(@NotNull Processor<? super V> p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/jetbrains/cidr/lang/util/OCMostlySingularMultiUniqueMap", "processAllValues"));
        }
        return ContainerUtil.process(this.myAllValues, p);
    }

    public boolean remove(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/lang/util/OCMostlySingularMultiUniqueMap", "remove"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/util/OCMostlySingularMultiUniqueMap", "remove"));
        }
        this.myAllValues.remove(value);
        return super.remove(key, value);
    }

    public boolean removeAllValues(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/lang/util/OCMostlySingularMultiUniqueMap", "removeAllValues"));
        }
        this.processForKey(key, new Processor<V>(){

            public boolean process(V v) {
                OCMostlySingularMultiUniqueMap.this.myAllValues.remove(v);
                return true;
            }
        });
        return super.removeAllValues(key);
    }

    public void compact() {
        ((THashMap)this.myAllValues).compact();
        super.compact();
    }

    public void clear() {
        this.myAllValues.clear();
        super.clear();
    }
}

