/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCPragmaOnceContentElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifiedNameOwner;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCEmptyName;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCReferenceWithContext;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReferenceContributor;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCharLiteral;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementUtil {
    private static final OCIntType[] NONE_DEC = new OCIntType[]{OCIntType.INT, OCIntType.LONG, OCIntType.LONGLONG, OCIntType.INT128};
    private static final OCIntType[] NONE_HEX = new OCIntType[]{OCIntType.INT, OCIntType.UINT, OCIntType.LONG, OCIntType.ULONG, OCIntType.LONGLONG, OCIntType.ULONGLONG, OCIntType.INT128, OCIntType.UINT128};
    private static final OCIntType[] U_DEC = new OCIntType[]{OCIntType.UINT, OCIntType.ULONG, OCIntType.ULONGLONG, OCIntType.UINT128};
    private static final OCIntType[] U_HEX = U_DEC;
    private static final OCIntType[] L_DEC = new OCIntType[]{OCIntType.LONG, OCIntType.LONGLONG, OCIntType.INT128};
    private static final OCIntType[] L_HEX = new OCIntType[]{OCIntType.LONG, OCIntType.ULONG, OCIntType.LONGLONG, OCIntType.ULONGLONG, OCIntType.INT128, OCIntType.UINT128};
    private static final OCIntType[] UL_DEC = new OCIntType[]{OCIntType.ULONG, OCIntType.ULONGLONG, OCIntType.INT128};
    private static final OCIntType[] UL_HEX = UL_DEC;
    private static final OCIntType[] LL_DEC = new OCIntType[]{OCIntType.LONGLONG, OCIntType.INT128};
    private static final OCIntType[] LL_HEX = new OCIntType[]{OCIntType.LONGLONG, OCIntType.ULONGLONG, OCIntType.INT128, OCIntType.UINT128};
    private static final OCIntType[] ULL_DEC = new OCIntType[]{OCIntType.ULONGLONG, OCIntType.UINT128};
    private static final OCIntType[] ULL_HEX = ULL_DEC;
    private static final Condition<PsiElement> ELEMENT_NON_WHITESPACE_CONDITION = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return !(element instanceof OCEmptyName) && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element));
        }
    };

    @Contract(value="null -> null;!null -> !null")
    public static IElementType getElementType(@Nullable ASTNode node) {
        return node == null ? null : node.getElementType();
    }

    @Contract(value="null -> null;!null -> !null")
    public static IElementType getElementType(@Nullable PsiElement element) {
        return element == null ? null : OCElementUtil.getElementType(element.getNode());
    }

    @Contract(value="null -> null")
    public static IElementType getObjCKeywordElementType(@Nullable ASTNode node) {
        if (node != null && OCElementUtil.getElementType(node) == OCElementTypes.OBJC_KEYWORD) {
            ASTNode[] children2 = node.getChildren(OCTokenTypes.KEYWORDS_WITH_DOGS);
            return children2.length == 1 ? children2[0].getElementType() : null;
        }
        return null;
    }

    @Nullable
    public static ASTNode findObjCKeyword(@NotNull ASTNode node, @NotNull IElementType type) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/util/OCElementUtil", "findObjCKeyword"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/util/OCElementUtil", "findObjCKeyword"));
        }
        for (ASTNode child : node.getChildren(null)) {
            if (child.getElementType() != OCElementTypes.OBJC_KEYWORD) continue;
            for (ASTNode token : child.getChildren(null)) {
                if (OCElementUtil.getElementType(token) != type) continue;
                return token;
            }
        }
        return null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isAlternativeCppPunctuator(@Nullable IElementType tt, @Nullable CharSequence token) {
        return tt instanceof OCPunctuatorElementType && OCPunctuatorElementType.findByKeyword(token.toString()) != null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isOneOf(@Nullable ASTNode node, PsiElement ... candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/jetbrains/cidr/lang/util/OCElementUtil", "isOneOf"));
        }
        if (node == null) {
            return false;
        }
        for (PsiElement each : candidates) {
            if (each == null || node != each.getNode()) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isMethodOrFunction(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        IElementType type = node.getElementType();
        return type == OCElementTypes.METHOD || type == OCElementTypes.FUNCTION_DEFINITION;
    }

    @Contract(value="null -> false")
    public static boolean isMethodOrFunctionBody(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        return OCElementTypes.BLOCK_STATEMENTS.contains(node.getElementType()) && OCElementUtil.isMethodOrFunction(node.getTreeParent());
    }

    @Contract(value="null -> false")
    public static boolean isVariableDeclaration(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() != OCElementTypes.DECLARATION) {
            return false;
        }
        ASTNode declarator = node.findChildByType((IElementType)OCElementTypes.DECLARATOR);
        return declarator != null && !OCElementUtil.isFunctionDeclaratorOrPredeclarator(node);
    }

    @Contract(value="null -> false")
    public static boolean isFunctionPredeclaration(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() == OCElementTypes.FUNCTION_DECLARATION) {
            return true;
        }
        if (node.getElementType() != OCElementTypes.DECLARATION) {
            return false;
        }
        return OCElementUtil.isFunctionPredeclarator(node.findChildByType((IElementType)OCElementTypes.DECLARATOR));
    }

    @Contract(value="null -> false")
    public static boolean isFunctionPredeclarator(@Nullable ASTNode node) {
        if (!OCElementUtil.isFunctionDeclaratorOrPredeclarator(node)) {
            return false;
        }
        ASTNode parent = node.getTreeParent();
        return parent == null || parent.getElementType() != OCElementTypes.FUNCTION_DEFINITION;
    }

    @Contract(value="null -> false")
    public static boolean isFunctionDeclaratorOrPredeclarator(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() != OCElementTypes.DECLARATOR) {
            return false;
        }
        return node.findChildByType((IElementType)OCElementTypes.PARAMETER_LIST) != null;
    }

    @Contract(value="null -> false")
    public static boolean isRefToken(@Nullable IElementType type) {
        return OCTokenTypes.TYPE_MODIFIERS.contains(type);
    }

    @Contract(value="null -> false")
    public static IElementType getRefInDeclarator(@Nullable ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node.getElementType() != OCElementTypes.DECLARATOR) {
            return null;
        }
        IElementType ret = OCElementUtil.getElementType(OCElementUtil.getFirstNonSpaceChild(node));
        return OCElementUtil.isRefToken(ret) ? ret : null;
    }

    @Contract(value="null -> null")
    public static ASTNode getFirstNonSpaceChild(@Nullable ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode ret = node.getFirstChildNode();
        while (ret instanceof PsiWhiteSpace) {
            ret = ret.getTreeNext();
        }
        return ret;
    }

    @Contract(value="null -> false")
    public static boolean isStructTypeDeclaration(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (!OCElementTypes.STRUCTURE_TYPES.contains(node.getElementType())) {
            return false;
        }
        return node.findChildByType((IElementType)OCTokenTypes.RBRACE) != null;
    }

    @Contract(value="null -> null")
    public static String getStringLiteral(@Nullable PsiElement element) {
        OCLiteralExpression literal;
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCLiteralExpression && (literal = (OCLiteralExpression)element).isNSStringLiteral()) {
            return literal.getUnescapedLiteralText();
        }
        return null;
    }

    @Nullable
    public static OCElementTypes.SelfSuperToken getSelfSuperToken(String name, PsiElement context, @NotNull OCResolveContext resolveContext) {
        OCElementTypes.SelfSuperToken token;
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/util/OCElementUtil", "getSelfSuperToken"));
        }
        if ("self".equals(name)) {
            token = OCElementTypes.SelfSuperToken.SELF;
        } else if ("super".equals(name)) {
            token = OCElementTypes.SelfSuperToken.SUPER;
        } else {
            return null;
        }
        if (PsiTreeUtil.getContextOfType((PsiElement)context, OCMethod.class, (boolean)false) == null) {
            return null;
        }
        OCBlockExpression block = (OCBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)context, OCBlockExpression.class);
        if (block != null) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            OCResolveUtil.processLocalSymbols(name, context, (Processor<OCSymbol>)finder);
            OCSymbol symbol = (OCSymbol)finder.getFoundValue();
            if (symbol != null && !(symbol.getType().resolve(resolveContext) instanceof OCMagicType)) {
                return null;
            }
        }
        return token;
    }

    @Nullable
    public static Object getConstValue(IElementType tt, String text, @Nullable PsiElement element, @Nullable OCInclusionContext context) {
        if (tt == OCTokenTypes.FAKE_TRUE) {
            return 1;
        }
        if (tt == OCTokenTypes.FAKE_FALSE) {
            return 0;
        }
        if (tt == OCTokenTypes.CHARACTER_LITERAL) {
            return OCElementUtil.parseChar(text, element, context);
        }
        if (tt == OCTokenTypes.STRING_LITERAL || tt == OCTokenTypes.AT) {
            return text;
        }
        if (tt == OCTokenTypes.INTEGER_LITERAL) {
            return OCElementUtil.parseInteger((String)text, (PsiElement)element, (OCInclusionContext)context).second;
        }
        if (tt == OCTokenTypes.FLOAT_LITERAL) {
            try {
                return Float.valueOf(Float.parseFloat(text));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (tt == OCTokenTypes.TRUE_CPP_KEYWORD) {
            return Boolean.TRUE;
        }
        if (tt == OCTokenTypes.FALSE_CPP_KEYWORD) {
            return Boolean.FALSE;
        }
        if (tt == OCTokenTypes.__NULL_KEYWORD || tt == OCTokenTypes.NULL_CPP_KEYWORD) {
            return 0;
        }
        return null;
    }

    @Nullable
    private static Number parseChar(@Nullable String text, @Nullable PsiElement element, @Nullable OCInclusionContext context) {
        PsiFile file2 = element == null ? null : element.getContainingFile();
        OCCharLiteral charLiteral = OCStringLiteralUtil.parseCharLiteral(text);
        boolean plainOldC = OCCodeInsightUtil.isInPlainOldC(file2, context);
        OCIntType detectedType = charLiteral.getType(plainOldC);
        OCNumber parsedNumber = null;
        String chars = charLiteral.getContents(false);
        int lenght = chars.length();
        if (lenght > 0) {
            long collector = 0L;
            int bytesPerChar = detectedType.getSizeInBytes(file2, context);
            for (int i = 0; i < lenght; ++i) {
                char ch = chars.charAt(i);
                collector <<= (ch & 0xFF00) != 0 ? 16 : 8;
                collector += (long)ch;
            }
            parsedNumber = OCNumber.convert(BigInteger.valueOf(collector), bytesPerChar, detectedType.isSigned());
        }
        return parsedNumber;
    }

    private static OCIntType[] candidates(boolean hex, boolean unsigned, boolean L, boolean LL) {
        if (unsigned && LL) {
            return hex ? ULL_HEX : ULL_DEC;
        }
        if (LL) {
            return hex ? LL_HEX : LL_DEC;
        }
        if (unsigned && L) {
            return hex ? UL_HEX : UL_DEC;
        }
        if (L) {
            return hex ? L_HEX : L_DEC;
        }
        if (unsigned) {
            return hex ? U_HEX : U_DEC;
        }
        return hex ? NONE_HEX : NONE_DEC;
    }

    @NotNull
    public static Pair<OCIntType, Number> parseInteger(@NotNull String text, @Nullable PsiElement element, @Nullable OCInclusionContext context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementUtil", "parseInteger"));
        }
        OCIntType detectedType = OCIntType.ULONGLONG;
        OCNumber parsedNumber = null;
        try {
            OCNumber.ParseInfo parseInfo = OCNumber.ParseInfo.parse(text);
            OCIntType[] intTypes = OCElementUtil.candidates(parseInfo.radix != 10, parseInfo.countU > 0, parseInfo.countL == 1, parseInfo.countL == 2);
            BigInteger bigInteger = new BigInteger(parseInfo.numbers, parseInfo.radix);
            int magBitCount = bigInteger.bitLength();
            for (OCIntType type : intTypes) {
                int bits = type.getBits(element, context);
                int freeBits = bits - magBitCount;
                if (freeBits <= 0 && (freeBits != 0 || type.isSigned())) continue;
                detectedType = type;
                parsedNumber = OCNumber.convert(parseInfo.negative ? bigInteger.negate() : bigInteger, bits / 8, type.isSigned());
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Pair pair = Pair.create((Object)detectedType, parsedNumber);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "parseInteger"));
        }
        return pair;
    }

    @Nullable
    public static OCType getType(@Nullable PsiElement element) {
        if (element instanceof OCTypeElement) {
            return ((OCTypeElement)element).getType().resolve(element.getContainingFile());
        }
        if (element instanceof OCExpression) {
            return ((OCExpression)element).getResolvedType();
        }
        if (element != null && OCElementUtil.getElementType(element) == OCElementTypes.TYPE_CODE_FRAGMENT) {
            OCType type = null;
            for (PsiElement child : element.getChildren()) {
                if (child instanceof OCTypeElement) {
                    type = OCElementUtil.getType(child);
                    continue;
                }
                if (!OCElementUtil.isElementSignificant(child)) continue;
                return null;
            }
            return type;
        }
        return null;
    }

    @Nullable
    public static OCMacroCall getElementMacroCall(PsiElement element) {
        PsiElement macroCall = OCElementUtil.getPrevSiblingOrParentSibling(element);
        while (macroCall instanceof OCMacroCall) {
            OCMacroCall node = (OCMacroCall)macroCall;
            macroCall = macroCall.getPrevSibling();
            if (node.getTextLength() <= 0) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public static PsiElement getPrevSiblingOrParentSibling(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "getPrevSiblingOrParentSibling"));
        }
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling != null) {
            return prevSibling;
        }
        PsiElement parent = element.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return OCElementUtil.getPrevSiblingOrParentSibling(parent);
    }

    @Nullable
    public static PsiElement getPrevLeaf(@Nullable PsiElement node) {
        while (node != null) {
            PsiElement prev = OCElementUtil.getPrevSiblingOrParentSibling(node);
            if (prev == null) {
                return null;
            }
            PsiElement result2 = prev;
            for (PsiElement lastChild = prev.getLastChild(); lastChild != null; lastChild = lastChild.getLastChild()) {
                result2 = lastChild;
            }
            if (result2 instanceof LeafPsiElement) {
                return result2;
            }
            node = result2;
        }
        return null;
    }

    @Nullable
    public static PsiElement getNextSiblingOrParentSibling(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "getNextSiblingOrParentSibling"));
        }
        PsiElement nextSibling = element.getNextSibling();
        if (nextSibling != null) {
            return nextSibling;
        }
        PsiElement parent = element.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return OCElementUtil.getNextSiblingOrParentSibling(parent);
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceSibling(PsiElement element) {
        PsiElement next;
        for (next = element.getNextSibling(); next != null && OCElementUtil.isWhitespace(next); next = next.getNextSibling()) {
        }
        return next;
    }

    @Nullable
    public static PsiElement getPrevSignificantSibling(PsiElement element) {
        PsiElement prev;
        for (prev = element.getPrevSibling(); prev != null && !OCElementUtil.isElementSignificant(prev); prev = prev.getPrevSibling()) {
        }
        return prev;
    }

    @Nullable
    public static PsiElement getParentOfType(@Nullable PsiFile file2, @NotNull TextRange range, Class<? extends PsiElement> ... parentClasses) {
        PsiElement element;
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/cidr/lang/util/OCElementUtil", "getParentOfType"));
        }
        if (file2 == null) {
            return null;
        }
        for (element = file2.findElementAt(range.getStartOffset()); element != null && OCElementUtil.getRangeWithMacros(element).getEndOffset() < range.getEndOffset(); element = element.getParent()) {
        }
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])parentClasses);
    }

    public static boolean isPartOfMacroSubstitution(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "isPartOfMacroSubstitution"));
        }
        return element.getTextLength() == 0;
    }

    @Nullable
    public static PsiElement replaceWithIdentifier(@Nullable PsiElement oldElement, String newName, PsiElement context) {
        PsiElement newElement;
        if (oldElement == null) {
            return null;
        }
        IElementType oldElementType = OCElementUtil.getElementType(oldElement);
        assert (oldElementType == OCTokenTypes.IDENTIFIER || oldElementType == OCTokenTypes.THIS_CPP_KEYWORD);
        if (newName.equals(oldElement.getText())) {
            return oldElement;
        }
        PsiElement psiElement = newElement = ((OCFile)oldElement.getContainingFile()).isCpp() && newName.equals("this") ? OCElementFactory.create(OCTokenTypes.THIS_CPP_KEYWORD, context) : OCElementFactory.createIdentifier(newName, context);
        if (oldElement instanceof OCMacroForeignLeafElement) {
            OCMacroRange range = OCElementUtil.getRangeInMacroCall(oldElement);
            if (range != null && range.mapsToArguments()) {
                range.getFirstElement().replace(newElement);
            }
            return oldElement.replace((PsiElement)OCElementFactory.createMacroForeignIdentifier(newName, (OCMacroForeignLeafElement)oldElement));
        }
        return oldElement.replace(newElement);
    }

    public static void changeQualifiedName(OCNamespaceQualifierOwner element, OCQualifiedName newName) {
        if (newName == OCQualifiedName.GLOBAL) {
            OCChangeUtil.clear(element);
            ASTNode parentNode = element.getParent().getNode();
            ASTNode oldColon2x = parentNode.findChildByType((IElementType)OCTokenTypes.COLON2X);
            if (oldColon2x != null) {
                CodeEditUtil.removeChild(parentNode, oldColon2x);
            }
            return;
        }
        OCCppNamespaceQualifier oldQualifier = element.getNamespaceQualifier();
        ASTNode elementNode = element.getNode();
        if (newName.getQualifier() != null) {
            OCCppNamespaceQualifier newQualifier;
            String qualifierName = newName.getQualifier().toString();
            OCCppNamespaceQualifier oCCppNamespaceQualifier = newQualifier = qualifierName.isEmpty() ? null : OCElementFactory.createNamespaceQualifier(qualifierName, element);
            if (oldQualifier != null) {
                if (newQualifier != null) {
                    OCChangeUtil.replaceHandlingMacros(oldQualifier, newQualifier);
                } else {
                    OCChangeUtil.delete(oldQualifier);
                }
            } else {
                PsiElement referenceToken;
                PsiElement psiElement = referenceToken = element instanceof OCNamespaceQualifiedNameOwner ? ((OCNamespaceQualifiedNameOwner)element).getNameIdentifier() : ((PsiNameIdentifierOwner)element).getNameIdentifier();
                if (newQualifier != null) {
                    element.addBefore(newQualifier, referenceToken);
                }
                CodeEditUtil.addChild(elementNode, OCElementFactory.createColon2x(element), referenceToken.getNode());
            }
        } else {
            ASTNode oldColon2x;
            if (oldQualifier != null) {
                OCChangeUtil.delete(oldQualifier);
            }
            if ((oldColon2x = elementNode.findChildByType((IElementType)OCTokenTypes.COLON2X)) != null) {
                CodeEditUtil.removeChild(elementNode, oldColon2x);
            }
        }
        PsiElement nameIdentifier = element instanceof OCNamespaceQualifiedNameOwner ? ((OCNamespaceQualifiedNameOwner)element).getNameIdentifier() : ((PsiNameIdentifierOwner)element).getNameIdentifier();
        OCElementUtil.replaceWithIdentifier(nameIdentifier, newName.getName(), element);
    }

    public static void fillChildrenRecursive(PsiElement parent, List<PsiElement> result2) {
        for (PsiElement kid = parent.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            result2.add(kid);
            OCElementUtil.fillChildrenRecursive(kid, result2);
        }
    }

    public static List<PsiElement> getAllChildren(PsiElement element) {
        return ContainerUtil.mapNotNull((Object[])element.getNode().getChildren(null), (Function)new Function<ASTNode, PsiElement>(){

            public PsiElement fun(ASTNode node) {
                return node.getPsi();
            }
        });
    }

    @Nullable
    public static OCMacroRange getRangeInMacroCall(@Nullable PsiElement psiElement) {
        TextRange callTextRange;
        OCMacroCall call;
        if (!(psiElement != null && psiElement.getFirstChild() != null && psiElement.findElementAt(0) == null || psiElement instanceof OCMacroForeignLeafElement)) {
            return null;
        }
        PsiElement leaf = psiElement;
        for (PsiElement parent = leaf.getParent(); parent != null && OCElementUtil.isPartOfMacroSubstitution(parent); parent = parent.getParent()) {
            leaf = parent;
        }
        while ((call = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)(leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf)), (Class[])new Class[]{OCMacroCall.class})) == null || call.getTextRange().isEmpty()) {
            if (leaf != null && (!(leaf instanceof LeafPsiElement) || leaf instanceof OCMacroForeignLeafElement)) continue;
            return null;
        }
        int offset = psiElement instanceof OCMacroForeignLeafElement ? psiElement.getParent().getTextOffset() : psiElement.getTextOffset();
        if (offset < (callTextRange = call.getTextRange()).getStartOffset() || offset > callTextRange.getEndOffset()) {
            return null;
        }
        return OCElementUtil.getRangeInMacroCall(psiElement, call);
    }

    public static OCMacroRange getRangeInMacroCall(PsiElement psiElement, OCMacroCall call) {
        int index;
        OCReferenceElement macroReferenceElement = call.getMacroReferenceElement();
        String macroName = macroReferenceElement != null ? macroReferenceElement.getCanonicalText() : null;
        PsiElement firstLeaf = PsiTreeUtil.firstChild((PsiElement)psiElement);
        PsiElement lastLeaf = PsiTreeUtil.lastChild((PsiElement)psiElement);
        OCMacroForeignLeafElement firstMacroLeaf = firstLeaf instanceof OCMacroForeignLeafElement ? (OCMacroForeignLeafElement)firstLeaf : null;
        OCMacroForeignLeafElement lastMacroLeaf = lastLeaf instanceof OCMacroForeignLeafElement ? (OCMacroForeignLeafElement)lastLeaf : null;
        int n = index = firstMacroLeaf != null ? firstMacroLeaf.getMacroArgumentIndex() : -1;
        if (lastMacroLeaf != null && index != -1 && index < call.getArguments().size() && firstMacroLeaf.getMacroName().equals(macroName) && lastMacroLeaf.getMacroName().equals(macroName) && index == lastMacroLeaf.getMacroArgumentIndex()) {
            OCMacroCallArgument argument = call.getArguments().get(index);
            OCMacroRange outer = OCElementUtil.getRangeInMacroCall(call);
            if (outer != null && outer.getMacroCall() != call && outer.mapsToArguments()) {
                return outer;
            }
            return new OCMacroRange(call, argument.findElementAt(firstMacroLeaf.getRangeInMacroArgument().getStartOffset()), argument.findElementAt(lastMacroLeaf.getRangeInMacroArgument().getEndOffset() - 1));
        }
        return new OCMacroRange(call);
    }

    public static void replaceDeclarationQualifiers(PsiElement dest, PsiElement source) {
        PsiElement nextSibling;
        PsiElement child = dest.getFirstChild();
        while (child != null) {
            IElementType tt = child.getNode().getElementType();
            nextSibling = child.getNextSibling();
            if (OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(tt) || tt == OCTokenTypes.TYPEDEF_KEYWORD || tt == OCTokenTypes.AUTO_KEYWORD) {
                OCChangeUtil.delete(child);
            }
            child = nextSibling;
        }
        PsiElement anchor = PsiTreeUtil.skipSiblingsForward((PsiElement)dest.getFirstChild(), (Class[])new Class[]{PsiWhiteSpace.class});
        child = source.getFirstChild();
        while (child != null) {
            nextSibling = child.getNextSibling();
            IElementType elementType = child.getNode().getElementType();
            if (elementType == OCTokenTypes.TYPEDEF_KEYWORD) {
                dest.addBefore(child, dest.getFirstChild());
                if (nextSibling instanceof PsiWhiteSpace) {
                    OCChangeUtil.addHandlingMacros(dest, nextSibling, dest.getFirstChild().getNextSibling());
                } else if (anchor != null) {
                    OCChangeUtil.addHandlingMacros(dest, OCElementFactory.spaceFromText(source), anchor);
                }
            } else if (OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(elementType) || elementType == OCTokenTypes.AUTO_KEYWORD) {
                ASTNode lastChildNode = dest.getNode().getLastChildNode();
                if (lastChildNode != null && !(lastChildNode.getPsi() instanceof PsiWhiteSpace)) {
                    OCChangeUtil.addHandlingMacros(dest, OCElementFactory.spaceFromText(source), null);
                }
                dest.addBefore(child, anchor);
                if (lastChildNode == null) {
                    OCChangeUtil.addHandlingMacros(dest.getParent(), OCElementFactory.spaceFromText(source), dest, false);
                } else if (nextSibling instanceof PsiWhiteSpace) {
                    OCChangeUtil.addHandlingMacros(dest, nextSibling, anchor);
                } else if (anchor != null) {
                    OCChangeUtil.addHandlingMacros(dest, OCElementFactory.spaceFromText(source), anchor);
                }
            }
            child = nextSibling;
        }
    }

    public static void replaceComments(PsiElement dest, PsiElement source) {
        PsiElement sourceFirstChild = source.getFirstChild();
        PsiElement lastChild = null;
        for (PsiElement sourceChild = sourceFirstChild; sourceChild != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(sourceChild)); sourceChild = sourceChild.getNextSibling()) {
            lastChild = sourceChild;
        }
        if (lastChild != null) {
            dest.addRangeBefore(sourceFirstChild, lastChild, dest.getFirstChild());
        }
    }

    public static void restoreFunction(OCFunctionDeclaration sourceFunction, OCFunctionDeclaration destFunction) {
        OCConstructorInitializationList initializationList;
        OCChangeUtil.replaceHandlingMacros(destFunction.getTypeElement(), sourceFunction.getTypeElement());
        OCChangeUtil.replaceHandlingMacros(destFunction.getParameterList(), sourceFunction.getParameterList());
        OCElementUtil.replaceDeclarationQualifiers(destFunction, sourceFunction);
        OCElementUtil.replaceDeclarationQualifiers(destFunction.getTypeElement(), sourceFunction.getTypeElement());
        if (sourceFunction instanceof OCFunctionDefinition && (initializationList = ((OCFunctionDefinition)sourceFunction).getConstructorInitializationList()) != null && destFunction instanceof OCFunctionDefinition) {
            ((OCFunctionDefinition)destFunction).setConstructorInitializationList(initializationList);
        }
    }

    @Nullable
    public static VirtualFile getFilePath(@Nullable PsiFile file2) {
        return file2 != null ? file2.getOriginalFile().getVirtualFile() : null;
    }

    public static boolean startsWithWord(String name, String word) {
        if (name.startsWith(word)) {
            if (name.length() == word.length()) {
                return true;
            }
            char nextChar = name.charAt(word.length());
            if (Character.isUpperCase(nextChar) || !Character.isLetterOrDigit(nextChar)) {
                return true;
            }
        }
        return false;
    }

    public static boolean endsWithIgnoringFirstLetterCase(String name, String suffix) {
        char nameLetter;
        if (suffix.isEmpty()) {
            return true;
        }
        if (name.length() < suffix.length()) {
            return false;
        }
        char firstSuffixLetter = Character.toLowerCase(suffix.charAt(0));
        return firstSuffixLetter == (nameLetter = Character.toLowerCase(name.charAt(name.length() - suffix.length()))) && name.endsWith(suffix.substring(1));
    }

    public static boolean isRetainMethod(OCCallable method) {
        if (method instanceof OCMethod && OCElementUtil.isRetainSelector(((OCMethod)method).getSelector())) {
            return true;
        }
        OCSymbol symbol = method != null ? method.getSymbol() : null;
        return symbol != null && symbol.hasAttribute("ns_returns_retained");
    }

    public static boolean isRetainSelector(String selector) {
        return selector.equals("retain") || OCElementUtil.startsWithWord(selector, "alloc") || OCElementUtil.startsWithWord(selector, "new") || OCElementUtil.startsWithWord(selector, "copy") || selector.endsWith("Copy");
    }

    public static boolean isReleaseSelector(String selector) {
        return selector.endsWith("release") || selector.equals("drain");
    }

    public static boolean isRetainCall(@Nullable PsiElement element, boolean checkNestedCalls) {
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCConditionalExpression) {
            OCConditionalExpression condExpr = (OCConditionalExpression)element;
            return OCElementUtil.isRetainCall(condExpr.getPositiveExpression(true), checkNestedCalls) || OCElementUtil.isRetainCall(condExpr.getNegativeExpression(), checkNestedCalls);
        }
        if (!(element instanceof OCSendMessageExpression)) {
            return false;
        }
        OCSendMessageExpression expression = (OCSendMessageExpression)element;
        if (OCElementUtil.isRetainSelector(expression.getMessageSelector())) {
            return true;
        }
        OCMethodSymbol symbol = expression.getProbableResponders().getKnownResponder();
        return symbol != null && symbol.hasAttribute("ns_returns_retained") || checkNestedCalls && !OCElementUtil.isReleaseCall(element) && OCElementUtil.isRetainCall(expression.getReceiverExpression(), true);
    }

    public static boolean isReleaseCall(@Nullable PsiElement element) {
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCConditionalExpression) {
            OCConditionalExpression condExpr = (OCConditionalExpression)element;
            return OCElementUtil.isReleaseCall(condExpr.getPositiveExpression(true)) || OCElementUtil.isReleaseCall(condExpr.getNegativeExpression());
        }
        if (!(element instanceof OCSendMessageExpression)) {
            return false;
        }
        String selector = ((OCSendMessageExpression)element).getMessageSelector();
        return OCElementUtil.isReleaseSelector(selector);
    }

    private static Condition<PsiElement> elementSignificantCondition(final boolean macroCallIsSignificant) {
        return new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return !(element instanceof OCDefineDirective) && !(element instanceof OCDirective) && (macroCallIsSignificant || !(element instanceof OCMacroCall)) && ELEMENT_NON_WHITESPACE_CONDITION.value((Object)element);
            }
        };
    }

    public static boolean isElementSignificant(PsiElement element) {
        return OCElementUtil.elementSignificantCondition(false).value((Object)element);
    }

    public static boolean isElementEmpty(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "isElementEmpty"));
        }
        if (element instanceof LeafPsiElement) {
            return !OCElementUtil.isElementSignificant(element) || element.getTextLength() == 0;
        }
        for (PsiElement child : OCElementUtil.getAllChildren(element)) {
            if (child == null || !OCElementUtil.isElementSignificant(child)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "isWhitespace"));
        }
        if (element instanceof LeafPsiElement) {
            return !ELEMENT_NON_WHITESPACE_CONDITION.value((Object)element);
        }
        for (PsiElement child : OCElementUtil.getAllChildren(element)) {
            if (child == null || !ELEMENT_NON_WHITESPACE_CONDITION.value((Object)child)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement e1, @NotNull PsiElement e2, boolean differentMacrosAreEquivalent) {
        if (e1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/jetbrains/cidr/lang/util/OCElementUtil", "areElementsEquivalent"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e2", "com/jetbrains/cidr/lang/util/OCElementUtil", "areElementsEquivalent"));
        }
        return OCElementUtil.areElementsEquivalent(e1, e2, differentMacrosAreEquivalent, new OCResolveContext(e1));
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement e1, @NotNull PsiElement e2, boolean differentMacrosAreEquivalent, final @NotNull OCResolveContext context) {
        if (e1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/jetbrains/cidr/lang/util/OCElementUtil", "areElementsEquivalent"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e2", "com/jetbrains/cidr/lang/util/OCElementUtil", "areElementsEquivalent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementUtil", "areElementsEquivalent"));
        }
        if (!differentMacrosAreEquivalent && OCElementUtil.isPartOfMacroSubstitution(e1)) {
            OCMacroRange range2;
            OCMacroCall macroCall2;
            if (!OCElementUtil.isPartOfMacroSubstitution(e2)) {
                return false;
            }
            OCMacroRange range1 = OCElementUtil.getRangeInMacroCall(e1);
            OCMacroCall macroCall1 = range1 != null ? range1.getMacroCall() : null;
            if (macroCall1 == null ^ (macroCall2 = (range2 = OCElementUtil.getRangeInMacroCall(e2)) != null ? range2.getMacroCall() : null) == null || !OCElementUtil.getTextWithMacros(macroCall1).equals(OCElementUtil.getTextWithMacros(macroCall2))) {
                return false;
            }
        }
        if (e1 instanceof OCElement && ((OCElement)e1).isEmpty() && e2 instanceof OCElement && ((OCElement)e2).isEmpty()) {
            return true;
        }
        if (e1.getTextLength() == 0 != (e2.getTextLength() == 0)) {
            return false;
        }
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e1, (PsiElement)e2, (Comparator)new Comparator<PsiReference>(){

            @Override
            public int compare(PsiReference ref1, PsiReference ref2) {
                PsiElement resolved2;
                if (ref1 instanceof OCReferenceWithContext && ref2 instanceof OCReferenceWithContext) {
                    Object symbol2;
                    Object symbol1 = ((OCReferenceWithContext)ref1).resolveToSymbol(context);
                    return Comparing.equal(symbol1, symbol2 = ((OCReferenceWithContext)ref2).resolveToSymbol(context)) ? 0 : 1;
                }
                if (ref1 instanceof OCReference && ref2 instanceof OCReference) {
                    OCSymbol symbol2;
                    OCSymbol symbol1 = ((OCReference)ref1).resolveToSymbol();
                    return Comparing.equal((Object)symbol1, (Object)(symbol2 = ((OCReference)ref2).resolveToSymbol())) ? 0 : 1;
                }
                PsiElement resolved1 = ref1.resolve();
                return Comparing.equal((Object)resolved1, (Object)(resolved2 = ref2.resolve())) ? 0 : 1;
            }
        }, (Comparator)new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                return Comparing.compare((Comparable)((Object)o1.getText()), (Comparable)((Object)o2.getText()));
            }
        }, OCElementUtil.elementSignificantCondition(!differentMacrosAreEquivalent), (boolean)false);
    }

    @Nullable
    public static Pair<PsiElement, PsiElement> getElementsDiff(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/jetbrains/cidr/lang/util/OCElementUtil", "getElementsDiff"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/jetbrains/cidr/lang/util/OCElementUtil", "getElementsDiff"));
        }
        if (element1 == element2) {
            return null;
        }
        ASTNode node1 = element1.getNode();
        ASTNode node2 = element2.getNode();
        Pair different = Pair.create((Object)element1, (Object)element2);
        if (node1.getElementType() != node2.getElementType()) {
            return different;
        }
        if (OCElementUtil.isPartOfMacroSubstitution(element1) || OCElementUtil.isPartOfMacroSubstitution(element2)) {
            return OCElementUtil.areElementsEquivalent(element1, element2, false) ? null : different;
        }
        List children1 = ContainerUtil.filter(OCElementUtil.getAllChildren(element1), OCElementUtil.elementSignificantCondition(false));
        List children2 = ContainerUtil.filter(OCElementUtil.getAllChildren(element2), OCElementUtil.elementSignificantCondition(false));
        if (children1.size() != children2.size()) {
            return different;
        }
        Pair<PsiElement, PsiElement> currentDiff = null;
        for (int i = 0; i < children1.size(); ++i) {
            PsiElement child2;
            PsiElement child1 = (PsiElement)children1.get(i);
            Pair<PsiElement, PsiElement> subDiff = OCElementUtil.getElementsDiff(child1, child2 = (PsiElement)children2.get(i));
            if (subDiff == null) continue;
            if (currentDiff == null) {
                currentDiff = subDiff;
                continue;
            }
            return different;
        }
        if (children1.size() == 0 && !element1.textMatches(element2)) {
            return different;
        }
        return currentDiff;
    }

    @Nullable
    public static PsiElement getPreviousNonEmptyElement(PsiElement element) {
        ASTNode node = element.getNode();
        PsiElement psiElement = node.getPsi();
        while (psiElement != null && OCElementUtil.isElementEmpty(psiElement)) {
            psiElement = (node = node.getTreePrev()) != null ? node.getPsi() : null;
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getNextNonEmptyElement(PsiElement element) {
        ASTNode node = element.getNode();
        PsiElement psiElement = node.getPsi();
        while (psiElement != null && OCElementUtil.isElementEmpty(psiElement)) {
            node = node.getTreeNext();
            psiElement = node.getPsi();
        }
        return psiElement;
    }

    @Nullable
    public static <T extends PsiElement> T getAdjacentParentOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/cidr/lang/util/OCElementUtil", "getAdjacentParentOfType"));
        }
        if (element == null) {
            return null;
        }
        int offset = element.getTextRange().getStartOffset();
        while (element != null) {
            if (aClass.isInstance(element)) {
                return (T)element;
            }
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling != null && aClass.isInstance(prevSibling) && prevSibling.getTextRange().getEndOffset() == offset) {
                return (T)prevSibling;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getAdjacentParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/jetbrains/cidr/lang/util/OCElementUtil", "getAdjacentParentOfType"));
        }
        if (element == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])classes);
        if (parent != null) {
            return (T)parent;
        }
        return (T)PsiTreeUtil.getNonStrictParentOfType((PsiElement)PsiTreeUtil.prevLeaf((PsiElement)element), (Class[])classes);
    }

    public static TextRange getTrimmedRange(PsiElement element) {
        return OCElementUtil.getTrimmedRange(element.getTextRange(), element.getContainingFile());
    }

    public static TextRange getTrimmedRange(TextRange range, PsiFile file2) {
        int start;
        String text = file2.getText().substring(range.getStartOffset(), range.getEndOffset());
        if (text.length() == 0 || text.length() != range.getLength()) {
            return range;
        }
        int end = text.length() - 1;
        for (start = 0; start <= end && text.charAt(start) <= ' '; ++start) {
        }
        while (start <= end && text.charAt(end) <= ' ') {
            --end;
        }
        return new TextRange(range.getStartOffset() + start, range.getEndOffset() + end - text.length() + 1);
    }

    public static TextRange getRangeInParent(ASTNode node) {
        return OCElementUtil.getRangeInParent(node.getPsi());
    }

    public static TextRange getRangeInParent(PsiElement element) {
        TextRange range = element.getTextRange();
        int parentOffset = element.getParent().getTextOffset();
        return range.isEmpty() ? range : range.shiftRight(-parentOffset);
    }

    private static boolean isCorrespondingMacroCall(@Nullable PsiElement macroCall, PsiElement element) {
        if (!(macroCall instanceof OCMacroCall)) {
            return false;
        }
        PsiElement leaf = ((OCMacroCall)macroCall).getFirstExpansionLeaf();
        return leaf != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)leaf, (boolean)false);
    }

    @NotNull
    public static String getTextWithMacros(@Nullable PsiElement element) {
        if (element == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getTextWithMacros"));
            }
            return "";
        }
        OCMacroRange range = OCElementUtil.getRangeInMacroCall(element);
        if (range == null) {
            PsiElement macroCall = OCElementUtil.getPrevSiblingOrParentSibling(element);
            if (OCElementUtil.isCorrespondingMacroCall(macroCall, element)) {
                StringBuilder result2 = new StringBuilder(element.getText());
                while (OCElementUtil.isCorrespondingMacroCall(macroCall, element)) {
                    result2.insert(0, macroCall.getText());
                    macroCall = OCElementUtil.getPrevSiblingOrParentSibling(macroCall);
                }
                String string = result2.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getTextWithMacros"));
                }
                return string;
            }
            String string = element.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getTextWithMacros"));
            }
            return string;
        }
        TextRange textRange = range.getArgumentRange();
        String callText = range.getMacroCall().getTextWithMacros();
        if (textRange == null) {
            String string = callText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getTextWithMacros"));
            }
            return string;
        }
        textRange = textRange.shiftRight(-range.getMacroCall().getTextRange().getStartOffset());
        String string = callText.substring(textRange.getStartOffset(), textRange.getEndOffset());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getTextWithMacros"));
        }
        return string;
    }

    public static String getTextFromLeaves(@NotNull PsiElement element) {
        PsiElement curLeaf;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "getTextFromLeaves"));
        }
        PsiElement nextLeaf = PsiTreeUtil.firstChild((PsiElement)element);
        PsiElement lastLeaf = PsiTreeUtil.lastChild((PsiElement)element);
        StringBuilder builder = new StringBuilder();
        do {
            curLeaf = nextLeaf;
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)curLeaf);
            builder.append(curLeaf.getText());
        } while (curLeaf != lastLeaf && nextLeaf != null);
        return builder.toString();
    }

    @NotNull
    public static TextRange getRangeWithMacros(PsiElement element) {
        OCMacroRange range = OCElementUtil.getRangeInMacroCall(element);
        if (range == null) {
            OCMacroCall macroCall = OCElementUtil.getElementMacroCall(element);
            TextRange textRange = element.getTextRange();
            if (macroCall != null && macroCall.getTextOffset() <= textRange.getEndOffset()) {
                TextRange textRange2 = new TextRange(macroCall.getTextOffset(), textRange.getEndOffset());
                if (textRange2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getRangeWithMacros"));
                }
                return textRange2;
            }
            TextRange textRange3 = textRange;
            if (textRange3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getRangeWithMacros"));
            }
            return textRange3;
        }
        TextRange callRange = range.getMacroCall().getRangeWithMacros();
        TextRange textRange = range.getArgumentRange();
        if (textRange != null) {
            TextRange textRange4 = textRange;
            if (textRange4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getRangeWithMacros"));
            }
            return textRange4;
        }
        TextRange textRange5 = callRange;
        if (textRange5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getRangeWithMacros"));
        }
        return textRange5;
    }

    public static boolean isEqualWithMacros(@Nullable PsiElement element1, @Nullable PsiElement element2) {
        if (element1 == null || element2 == null || !Comparing.equal(element1.getClass(), element2.getClass())) {
            return false;
        }
        if (Comparing.equal((Object)element1, (Object)element2)) {
            return true;
        }
        OCMacroRange range1 = OCElementUtil.getRangeInMacroCall(element1);
        if (range1 != null && range1.mapsToArguments()) {
            return range1.getTextRange().equals((Object)element2.getTextRange());
        }
        OCMacroRange range2 = OCElementUtil.getRangeInMacroCall(element2);
        if (range2 != null && range2.mapsToArguments()) {
            return range2.getTextRange().equals((Object)element1.getTextRange());
        }
        return false;
    }

    public static TextRange getTextRangeWithoutComments(PsiElement element) {
        PsiElement child = element.getFirstChild();
        if (child instanceof PsiComment) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child != null) {
                return new TextRange(child.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
            }
        }
        return element.getTextRange();
    }

    public static boolean isVisibilityKeyword(@Nullable ASTNode node) {
        return OCElementUtil.isOCVisibilityKeyword(node) || OCElementUtil.isCPPVisibilityKeyword(node);
    }

    @Contract(value="null->false")
    public static boolean isOCVisibilityKeyword(@Nullable ASTNode node) {
        if (node != null) {
            IElementType type = node.getElementType();
            if (type == OCElementTypes.OBJC_KEYWORD) {
                type = OCElementUtil.getObjCKeywordElementType(node);
                return OCTokenTypes.IVAR_VISIBILITY_KEYWORDS.contains(type) || OCTokenTypes.PROTOCOL_METHODS_KEYWORDS.contains(type);
            }
            if (type == OCElementTypes.OBJC_ERROR_KEYWORD) {
                return OCElementUtil.getElementType(node.getTreeParent()) == OCElementTypes.INSTANCE_VARIABLES_LIST;
            }
        }
        return false;
    }

    public static boolean isCPPVisibilityKeyword(@Nullable ASTNode node) {
        return node != null && OCTokenTypes.CPP_VISIBILITY_KEYWORDS.contains(node.getElementType());
    }

    @Nullable
    public static String getTypeTextWithModifiers(@NotNull OCDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/cidr/lang/util/OCElementUtil", "getTypeTextWithModifiers"));
        }
        List<OCDeclarator> declarators = declaration.getDeclarators();
        return declarators.size() == 1 ? OCElementUtil.getTypeTextWithModifiers(declarators.get(0)) : null;
    }

    @Nullable
    public static String getTypeTextWithModifiers(OCDeclarator declarator) {
        OCDeclaration declaration = (OCDeclaration)declarator.getParent();
        OCTypeElement typeElement = declaration.getTypeElement();
        if (typeElement != null && (declaration instanceof OCFunctionDeclaration || OCCodeInsightUtil.isSimpleDeclaration(declarator.getTextWithMacros(), declarator.getName()))) {
            return typeElement.getTextWithMacros() + declarator.getModifiersText();
        }
        return null;
    }

    @Nullable
    public static String getTypeTextWithModifiers(OCDeclaratorSymbol symbol) {
        PsiNameIdentifierOwner definition = (PsiNameIdentifierOwner)symbol.locateDefinition();
        if (definition instanceof OCDeclarator) {
            return OCElementUtil.getTypeTextWithModifiers((OCDeclarator)definition);
        }
        if (definition instanceof OCMethodSelectorPart) {
            OCTypeElement typeElement = ((OCMethodSelectorPart)definition).getTypeElement();
            return typeElement != null ? typeElement.getTextWithMacros() : null;
        }
        return null;
    }

    @Nullable
    public static String getReturnTypeTextWithModifiers(OCFunctionSymbol symbol) {
        OCFunctionDeclaration funDefinition = symbol.locateFunctionDefinition();
        return funDefinition != null ? OCElementUtil.getTypeTextWithModifiers(funDefinition) : null;
    }

    @Nullable
    public static String getReturnTypeText(OCMethodSymbol symbol) {
        Object methodDefinition = symbol.locateDefinition();
        OCTypeElement returnType = methodDefinition instanceof OCMethod ? ((OCMethod)methodDefinition).getReturnTypeElement() : null;
        return returnType != null ? returnType.getTextWithMacros() : null;
    }

    @Nullable
    public static OCPragma getPragmaAt(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        IElementType type = element.getNode().getElementType();
        if (type == OCTokenTypes.PRAGMA_DIRECTIVE || type == OCTokenTypes.BLOCK_COMMENT || type instanceof OCPragmaOnceContentElementType) {
            element = element.getParent();
        }
        if (element instanceof OCPragma) {
            return (OCPragma)element;
        }
        return null;
    }

    @NotNull
    public static String getLeadingCommentsAndWhitespaces(@NotNull PsiElement element, boolean skipWhitespaces) {
        OCMacroRange curRange;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "getLeadingCommentsAndWhitespaces"));
        }
        String text = "";
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        OCMacroCall macroCall = macroRange != null ? macroRange.getMacroCall() : null;
        PsiElement prevSibling = PsiTreeUtil.prevLeaf((PsiElement)element);
        while (prevSibling != null && OCElementUtil.isElementEmpty(prevSibling) && (!OCElementUtil.isPartOfMacroSubstitution(prevSibling) || (curRange = OCElementUtil.getRangeInMacroCall(prevSibling)) == null || curRange.getMacroCall() != macroCall)) {
            if (!skipWhitespaces || !OCTokenTypes.WHITESPACES.contains(OCElementUtil.getElementType(prevSibling))) {
                text = OCElementUtil.getTextWithMacros(prevSibling) + text;
            }
            prevSibling = PsiTreeUtil.prevLeaf((PsiElement)prevSibling);
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getLeadingCommentsAndWhitespaces"));
        }
        return string;
    }

    @NotNull
    public static String getTrailingCommentsAndWhitespaces(@NotNull PsiElement element, boolean skipWhitespaces) {
        OCMacroRange curRange;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "getTrailingCommentsAndWhitespaces"));
        }
        StringBuilder text = new StringBuilder();
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        OCMacroCall macroCall = macroRange != null ? macroRange.getMacroCall() : null;
        PsiElement nextSibling = PsiTreeUtil.nextLeaf((PsiElement)element);
        while (nextSibling != null && OCElementUtil.isElementEmpty(nextSibling) && (!OCElementUtil.isPartOfMacroSubstitution(nextSibling) || (curRange = OCElementUtil.getRangeInMacroCall(nextSibling)) == null || curRange.getMacroCall() != macroCall)) {
            if (!skipWhitespaces || !OCTokenTypes.WHITESPACES.contains(OCElementUtil.getElementType(nextSibling))) {
                text.append(OCElementUtil.getTextWithMacros(nextSibling));
            }
            nextSibling = PsiTreeUtil.nextLeaf((PsiElement)nextSibling);
        }
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getTrailingCommentsAndWhitespaces"));
        }
        return string;
    }

    @Nullable
    public static PsiReference findReferenceInMacro(final @Nullable PsiElement element) {
        if (element == null || OCElementUtil.getElementType(element) != OCTokenTypes.STRING_LITERAL) {
            return null;
        }
        OCMacroCallArgument argument = (OCMacroCallArgument)PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCallArgument.class);
        if (argument == null) {
            return null;
        }
        final PsiElement macroCall = argument.getParent();
        if (macroCall instanceof OCMacroCall) {
            final Ref result2 = Ref.create(null);
            OCResourceReferenceContributor.processReferenceProviders(new Processor<OCResourceCompletionProvider>(){

                public boolean process(OCResourceCompletionProvider provider) {
                    OCResourceReference ref = provider.getReferenceByCall(macroCall, element);
                    if (ref != null) {
                        result2.set((Object)ref);
                        return false;
                    }
                    return true;
                }
            });
            if (!result2.isNull()) {
                return (PsiReference)result2.get();
            }
        }
        return null;
    }

    @NotNull
    public static SearchScope getUseScope(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "getUseScope"));
        }
        if (!(element instanceof OCDefineDirective) && (parent = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCCallable.class})) != null && (parent != element.getContext() || element instanceof OCMethodSelectorPart)) {
            Pair<List<OCElement>, OCSymbolKind> pair = OCCodeInsightUtil.getScopeAndKind(element);
            if (!((List)pair.getFirst()).isEmpty()) {
                LocalSearchScope localSearchScope = new LocalSearchScope(((List)pair.getFirst()).toArray(new PsiElement[((List)pair.getFirst()).size()]));
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getUseScope"));
                }
                return localSearchScope;
            }
            LocalSearchScope localSearchScope = new LocalSearchScope(parent);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getUseScope"));
            }
            return localSearchScope;
        }
        Project project = element.getProject();
        if (OCSearchScope.isInProjectSources(element)) {
            GlobalSearchScope globalSearchScope = OCSearchScope.getProjectSourcesScope(project);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getUseScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = OCSearchScope.getProjectSourcesScope(project).union((SearchScope)ProjectScope.getLibrariesScope((Project)project));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementUtil", "getUseScope"));
        }
        return globalSearchScope;
    }

    public static String getIdentifierName(PsiElement element, boolean skipParameterList) {
        if (element instanceof OCEmptyName) {
            return "id";
        }
        if (element == null) {
            return "<unnamed>";
        }
        ASTNode token = element.getNode();
        if (token == null) {
            return "<unnamed>";
        }
        StringBuilder result2 = new StringBuilder();
        if (token.getElementType() instanceof ForeignLeafType) {
            result2.append(((ForeignLeafType)token.getElementType()).getValue());
        } else if (element instanceof ForeignLeafPsiElement) {
            result2.append(OCElementUtil.getTextFromLeaves(element));
        } else {
            result2.append(token.getText());
        }
        if (OCElementUtil.getElementType(element) == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
            PsiElement sibling = element;
            boolean first = true;
            while ((sibling = sibling.getNextSibling()) != null) {
                IElementType type = sibling.getNode().getElementType();
                if (!skipParameterList || type != OCElementTypes.PARAMETER_LIST) {
                    if (!OCElementUtil.isElementSignificant(sibling)) continue;
                    if (first) {
                        result2.setLength(0);
                        result2.append(OCElementUtil.getOperatorName(OCTokenTypes.OPERATOR_CPP_KEYWORD.getName(), sibling.getNode().getElementType(), OCElementUtil.getTextFromLeaves(sibling)));
                    } else {
                        result2.append(OCElementUtil.getTextFromLeaves(sibling));
                    }
                    first = false;
                    continue;
                }
                break;
            }
        } else {
            PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
            if (prevSibling != null && "~".equals(OCElementUtil.getTextFromLeaves(prevSibling))) {
                result2.insert(0, OCElementUtil.getTextFromLeaves(prevSibling));
            }
        }
        return result2.toString().trim();
    }

    public static String getElementDebugName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "getElementDebugName"));
        }
        String IMPL = "Impl";
        String className = element.getClass().getSimpleName();
        className = className.endsWith("Impl") ? className.substring(0, className.length() - "Impl".length()) : className;
        return element instanceof PsiNamedElement ? className + "(" + ((PsiNamedElement)element).getName() + ")" : className;
    }

    public static String getOperatorName(@NotNull String prefix, @NotNull IElementType signType, @NotNull String signText) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/cidr/lang/util/OCElementUtil", "getOperatorName"));
        }
        if (signType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signType", "com/jetbrains/cidr/lang/util/OCElementUtil", "getOperatorName"));
        }
        if (signText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signText", "com/jetbrains/cidr/lang/util/OCElementUtil", "getOperatorName"));
        }
        return signType == OCTokenTypes.IDENTIFIER || signType == OCElementTypes.TYPE_ELEMENT || OCTokenTypes.KEYWORDS.contains(signType) ? prefix + " " + signText : prefix + signText;
    }

    public static IElementType getUnwrappedTokeType(@Nullable IElementType base) {
        while (base instanceof ForeignLeafType) {
            base = ((ForeignLeafType)base).getDelegate();
        }
        return base;
    }

    public static boolean containsDirectives(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/util/OCElementUtil", "containsDirectives"));
        }
        for (ASTNode child : node.getChildren(null)) {
            if (!OCTokenTypes.DIRECTIVES.contains(child.getElementType()) && !OCElementUtil.containsDirectives(child)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDirectives(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "containsDirectives"));
        }
        return OCElementUtil.containsDirectives(element.getNode());
    }

    @Nullable
    public static OCClassDeclaration resolveClassDeclaration(@Nullable OCSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        Object element = symbol.locateDefinition();
        return element instanceof OCClassDeclaration ? (OCClassDeclaration)element : null;
    }

    @Nullable
    public static TextRange getUserVisibleRangeInDocument(@NotNull PsiElement element) {
        TextRange range;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "getUserVisibleRangeInDocument"));
        }
        OCMacroRange rangeInMacroCall = OCElementUtil.getRangeInMacroCall(element);
        if (rangeInMacroCall == null) {
            LeafElement fl = TreeUtil.findFirstLeaf(element.getNode());
            ASTNode ll = TreeUtil.findLastLeaf(element.getNode());
            if (fl != null && fl.getPsi() instanceof OCMacroForeignLeafElement || ll != null && ll.getPsi() instanceof OCMacroForeignLeafElement) {
                return null;
            }
            range = OCElementUtil.getRangeWithMacros(element);
        } else {
            range = rangeInMacroCall.mapsToArguments() ? rangeInMacroCall.getTextRange() : null;
        }
        return range;
    }

    public static boolean isEssentialNode(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil", "isEssentialNode"));
        }
        return !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element)) && !element.getTextRange().isEmpty() && !(element instanceof OCPragma);
    }

    private static boolean isLocalGuardIfndef(@NotNull OCDirective directive) {
        if (directive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directive", "com/jetbrains/cidr/lang/util/OCElementUtil", "isLocalGuardIfndef"));
        }
        IElementType directiveType = OCElementUtil.getElementType(directive.getHeaderToken());
        if (directiveType == OCTokenTypes.IFNDEF_DIRECTIVE) {
            PsiElement next = OCElementUtil.getNextNonWhitespaceSibling(directive);
            if (!(next instanceof OCDefineDirective)) {
                return false;
            }
            String name = null;
            boolean firstChild = true;
            for (PsiElement child : directive.getChildren()) {
                if (child instanceof OCReferenceElement) {
                    name = ((OCReferenceElement)child).getName();
                }
                if (!firstChild && OCElementUtil.isEssentialNode(child)) {
                    return false;
                }
                firstChild = false;
            }
            return name != null && name.equals(((OCDefineDirective)next).getName());
        }
        return false;
    }

    @Nullable
    public static OCDirective getGuardIfndef(final @NotNull PsiFile file2, boolean maybeWithoutLastEndif) {
        class CancelException
        extends RuntimeException {
            CancelException() {
            }
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/util/OCElementUtil", "getGuardIfndef"));
        }
        final OCDirective[] candidate = new OCDirective[]{null};
        try {
            final PsiElement[] lastEssential = new PsiElement[]{null};
            final PsiElement[] lastEndif = new PsiElement[]{null};
            file2.accept((PsiElementVisitor)new OCRecursiveVisitor(){
                int nestLevel = 0;
                int directivesAtZeroNestLevel = 0;

                @Override
                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCElementUtil$7", "visitElement"));
                    }
                    super.visitElement(element);
                    if (OCElementUtil.isEssentialNode(element)) {
                        if (candidate[0] == null) {
                            throw new CancelException();
                        }
                        if (element != file2) {
                            lastEssential[0] = element;
                        }
                    }
                }

                @Override
                public void visitPragma(@NotNull OCPragma pragma) {
                    if (pragma == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pragma", "com/jetbrains/cidr/lang/util/OCElementUtil$7", "visitPragma"));
                    }
                }

                @Override
                public void visitDirective(@NotNull OCDirective directive) {
                    if (directive == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directive", "com/jetbrains/cidr/lang/util/OCElementUtil$7", "visitDirective"));
                    }
                    IElementType directiveType = OCElementUtil.getElementType(directive.getHeaderToken());
                    if (candidate[0] == null && OCElementUtil.isLocalGuardIfndef(directive)) {
                        candidate[0] = directive;
                    }
                    if (OCTokenTypes.ENDIF_DIRECTIVE == directiveType) {
                        --this.nestLevel;
                        if (this.nestLevel < 0) {
                            candidate[0] = null;
                            throw new CancelException();
                        }
                        lastEndif[0] = directive;
                    }
                    if (this.nestLevel == 0) {
                        ++this.directivesAtZeroNestLevel;
                        if (this.directivesAtZeroNestLevel > 2) {
                            candidate[0] = null;
                            throw new CancelException();
                        }
                    }
                    if (OCTokenTypes.IF_DIRECTIVES.contains(directiveType)) {
                        ++this.nestLevel;
                    }
                    super.visitDirective(directive);
                }
            });
            if (!maybeWithoutLastEndif && lastEssential[0] != lastEndif[0]) {
                candidate[0] = null;
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        return candidate[0];
    }

    public static boolean isInBlockEnclosed(@NotNull ASTNode child, @NotNull ASTNode parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/lang/util/OCElementUtil", "isInBlockEnclosed"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/util/OCElementUtil", "isInBlockEnclosed"));
        }
        boolean isInlineEnclosed = false;
        boolean afterLBrace = false;
        for (ASTNode node = parent.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            if (child == node) {
                isInlineEnclosed = true;
                continue;
            }
            if (node.getElementType() == OCTokenTypes.LBRACE) {
                afterLBrace = true;
                continue;
            }
            if (afterLBrace && !isInlineEnclosed && node.textContains('\n')) {
                return false;
            }
            if (!afterLBrace || node.getElementType() == OCTokenTypes.RBRACE || OCElementUtil.isWhitespace(node.getPsi())) continue;
            return false;
        }
        return isInlineEnclosed;
    }

    @Nullable
    public static <T extends PsiElement> SmartPsiElementPointer<T> createPsiElementPointer(@Nullable T element) {
        if (element == null) {
            return null;
        }
        for (PsiElement child : element.getChildren()) {
            if (!child.getTextRange().equals((Object)element.getTextRange()) || !child.getClass().equals(element.getClass())) continue;
            return OCElementUtil.createPsiElementPointer(child);
        }
        return SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element, element.getContainingFile());
    }

    @Nullable
    public static <T extends PsiElement> T getPsiElementByPointer(@Nullable SmartPsiElementPointer<T> pointer) {
        PsiElement element;
        PsiElement psiElement = element = pointer != null ? pointer.getElement() : null;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent == null || parent.getClass() != element.getClass() || !parent.getTextRange().equals((Object)element.getTextRange())) {
                return (T)element;
            }
            element = parent;
        }
        return null;
    }
}

