/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.util.OCElementFactory");

    private OCElementFactory() {
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        OCDeclarationStatement oCDeclarationStatement = OCElementFactory.declarationStatement(null, name, type, initializer, context);
        if (oCDeclarationStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationStatement"));
        }
        return oCDeclarationStatement;
    }

    @NotNull
    public static OCDeclaration declaration(String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(null, name, type, initializer, context).getDeclaration();
        if (oCDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declaration"));
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclaration declaration(@Nullable String modifier, String name, OCType type, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(modifier, name, type, null, context).getDeclaration();
        if (oCDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declaration"));
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@Nullable String modifier, String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        String declText = OCElementFactory.declarationText(modifier != null ? Collections.singletonList(modifier) : Collections.emptyList(), name, type, initializer != null ? "0" : null, context, null, false);
        OCDeclarationStatement statement = (OCDeclarationStatement)OCElementFactory.statementFromText(declText, context, true);
        if (initializer != null) {
            OCChangeUtil.replaceHandlingMacros(statement.getDeclaration().getDeclarators().get(0).getInitializer(), initializer);
        }
        OCDeclarationStatement oCDeclarationStatement = statement;
        if (oCDeclarationStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationStatement"));
        }
        return oCDeclarationStatement;
    }

    @NotNull
    public static OCDeclaration declarationFromText(String text, PsiElement context) {
        OCDeclaration oCDeclaration = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context);
        if (oCDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationFromText"));
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclaration declarationFromText(String text, PsiElement context, boolean reformat) {
        OCDeclaration oCDeclaration = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context, reformat);
        if (oCDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationFromText"));
        }
        return oCDeclaration;
    }

    @NotNull
    public static String declarationText(String name, OCType type, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationText"));
        }
        String string = OCElementFactory.declarationText(Collections.<String>emptyList(), name, type, null, context, null, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationText"));
        }
        return string;
    }

    @NotNull
    public static String declarationText(String name, OCType type, String typeNameHint, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationText"));
        }
        String string = OCElementFactory.declarationText(Collections.<String>emptyList(), name, type, null, context, typeNameHint, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationText"));
        }
        return string;
    }

    @NotNull
    public static OCDeclaration declarationByNameAndType(String name, OCType type, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(name, type, null, context).getDeclaration();
        if (oCDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationByNameAndType"));
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationFromText(String text, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "paramDeclarationFromText"));
        }
        OCParameterDeclaration oCParameterDeclaration = ((OCFunctionDefinition)OCElementFactory.topLevelDeclarationFromText("void f(" + text + "){}", context)).getParameterList().getParameterDeclarations().get(0);
        if (oCParameterDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "paramDeclarationFromText"));
        }
        return oCParameterDeclaration;
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationByNameAndType(String name, OCType type, PsiElement context) {
        OCParameterDeclaration oCParameterDeclaration = OCElementFactory.paramDeclarationFromText(OCElementFactory.declarationText(name, type, context), context);
        if (oCParameterDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "paramDeclarationByNameAndType"));
        }
        return oCParameterDeclaration;
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context) {
        OCProperty oCProperty = OCElementFactory.propertyDeclaration(name, type, context, null, false);
        if (oCProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "propertyDeclaration"));
        }
        return oCProperty;
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly) {
        OCProperty oCProperty = OCElementFactory.propertyDeclaration(name, type, context, semantics, readonly, null);
        if (oCProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "propertyDeclaration"));
        }
        return oCProperty;
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly, @Nullable String additionalAttributes) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        OCProperty oCProperty = OCElementFactory.propertyDeclaration(name, type, context, semantics, settings == null || settings.PROPERTY_NONATOMIC, readonly, additionalAttributes);
        if (oCProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "propertyDeclaration"));
        }
        return oCProperty;
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean nonatomic, boolean readonly, @Nullable String additionalAttributes) {
        ArrayList<String> attributes = new ArrayList<String>();
        if (nonatomic) {
            attributes.add("nonatomic");
        }
        if (readonly) {
            attributes.add("readonly");
        }
        if (semantics == null && type.isPointerToObjectCompatible()) {
            semantics = OCPropertySymbolImpl.getDefaultSemanticsForType(type, context);
        }
        if (semantics == OCPropertySymbol.PropertySemantics.ASSIGN) {
            attributes.add("assign");
        } else if (semantics == OCPropertySymbol.PropertySemantics.WEAK) {
            attributes.add("weak");
        } else if (type.isPointerToObjectCompatible() && !readonly) {
            if (semantics == OCPropertySymbol.PropertySemantics.STRONG) {
                attributes.add("strong");
            } else if (semantics == OCPropertySymbol.PropertySemantics.RETAIN) {
                attributes.add("retain");
            } else if (semantics == OCPropertySymbol.PropertySemantics.COPY) {
                attributes.add("copy");
            }
        }
        StringBuilder attributesText = new StringBuilder();
        if (!attributes.isEmpty()) {
            attributesText.append('(');
            attributesText.append(StringUtil.join(attributes, (String)","));
            attributesText.append(')');
        }
        if (!StringUtil.isEmpty((String)additionalAttributes)) {
            if (attributesText.length() > 0) {
                attributesText.append(' ');
            }
            attributesText.append(additionalAttributes);
            attributesText.append(' ');
        }
        String text = "@interface c @property " + attributesText + OCElementFactory.declarationText(Collections.<String>emptyList(), name, type, null, context, null, true) + "; @end";
        OCProperty oCProperty = ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0);
        if (oCProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "propertyDeclaration"));
        }
        return oCProperty;
    }

    @NotNull
    public static OCDeclaration enumConst(String name, PsiElement context) {
        OCDeclaration oCDeclaration = ((OCEnum)OCElementFactory.typeElementFromText("enum { " + name + "}", context).getFirstChild()).getFields().get(0);
        if (oCDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "enumConst"));
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCExpression booleanConstant(boolean value, PsiElement context) {
        String constant = OCIntType.getAppropriateBool((OCElement)context.getContainingFile()).getValue(value);
        OCExpression oCExpression = OCElementFactory.expressionFromText(constant, context, false);
        if (oCExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "booleanConstant"));
        }
        return oCExpression;
    }

    @NotNull
    public static OCSendMessageExpression sendMessageExpression(List<String> paramStubs, PsiElement context) {
        StringBuilder text = new StringBuilder("[ 0 ");
        for (String paramStub : paramStubs) {
            text.append(paramStub).append(' ');
        }
        text.append("]");
        OCSendMessageExpression oCSendMessageExpression = (OCSendMessageExpression)OCElementFactory.expressionFromText(text.toString(), context);
        if (oCSendMessageExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "sendMessageExpression"));
        }
        return oCSendMessageExpression;
    }

    @NotNull
    public static OCCallExpression callExpression(@Nullable String functionName, List<String> paramStubs, PsiElement context) {
        if (functionName == null || functionName.isEmpty()) {
            functionName = "__empty";
        }
        StringBuilder text = new StringBuilder(functionName);
        text.append('(');
        boolean isFirst = true;
        for (String paramStub : paramStubs) {
            if (!isFirst) {
                text.append(',');
            }
            text.append(paramStub);
            isFirst = false;
        }
        text.append(')');
        OCCallExpression oCCallExpression = (OCCallExpression)OCElementFactory.expressionFromText(text.toString(), context);
        if (oCCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "callExpression"));
        }
        return oCCallExpression;
    }

    @NotNull
    public static OCInterface interfaceByName(String name, PsiElement context) {
        OCInterface oCInterface = (OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface " + name + " @end", context, true);
        if (oCInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "interfaceByName"));
        }
        return oCInterface;
    }

    @NotNull
    public static OCMethod methodFromText(String text, PsiElement context, boolean reformat) {
        OCMethod oCMethod = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface i " + text + " @end", context, reformat)).getMethods().get(0);
        if (oCMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "methodFromText"));
        }
        return oCMethod;
    }

    @NotNull
    public static OCDefineDirective macroDeclarationFromText(String name, String defaultValue, PsiFile file2) {
        OCDefineDirective oCDefineDirective = (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText("#define " + name + " " + defaultValue, (PsiElement)file2);
        if (oCDefineDirective == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "macroDeclarationFromText"));
        }
        return oCDefineDirective;
    }

    @NotNull
    public static OCMethod methodFromSignature(@NotNull String signature, @NotNull PsiElement context, boolean needBody, boolean reformat) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/jetbrains/cidr/lang/util/OCElementFactory", "methodFromSignature"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "methodFromSignature"));
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        String semicolon = settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE ? ";" : "";
        OCMethod oCMethod = OCElementFactory.methodFromText(signature + (needBody ? semicolon + "{\n}" : ";"), context, reformat);
        if (oCMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "methodFromSignature"));
        }
        return oCMethod;
    }

    @NotNull
    public static OCUnaryExpression unaryExpression(PsiElement operand, OCElementType operator) {
        OCUnaryExpression expression = (OCUnaryExpression)OCElementFactory.expressionFromText(operator.getName() + " a", operand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getOperand(), operand);
        OCUnaryExpression oCUnaryExpression = expression;
        if (oCUnaryExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "unaryExpression"));
        }
        return oCUnaryExpression;
    }

    @NotNull
    public static OCBinaryExpression binaryExpression(PsiElement leftOperand, PsiElement rightOperand, OCElementType operator) {
        OCBinaryExpression expression = (OCBinaryExpression)OCElementFactory.expressionFromText("a " + operator.getName() + " b", leftOperand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getLeft(), leftOperand);
        OCChangeUtil.replaceHandlingMacros(expression.getRight(), rightOperand);
        OCBinaryExpression oCBinaryExpression = expression;
        if (oCBinaryExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "binaryExpression"));
        }
        return oCBinaryExpression;
    }

    @NotNull
    public static PsiElement binaryOperatorFromText(String operator, PsiElement context) {
        PsiElement psiElement = ((OCBinaryExpression)OCElementFactory.expressionFromText("a" + operator + "b", context)).getOperationSignNode().getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "binaryOperatorFromText"));
        }
        return psiElement;
    }

    @NotNull
    public static ASTNode typeModifierFromText(String modifier, PsiElement context) {
        ASTNode aSTNode = OCElementFactory.typeElementFromText(modifier + " int", context).getNode().getFirstChildNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeModifierFromText"));
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement ivarScopeSpecifier(OCVisibility scope, PsiElement context) {
        OCInstanceVariablesList clazz = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c { @" + (Object)((Object)scope) + "} #end", context)).getInstanceVariablesList();
        for (PsiElement kid = clazz.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (OCVisibility.getVisibilityFromElement(kid) != scope) continue;
            PsiElement psiElement = kid;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "ivarScopeSpecifier"));
            }
            return psiElement;
        }
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "ivarScopeSpecifier"));
        }
        return null;
    }

    @NotNull
    public static OCInstanceVariablesList instanceVariableList(PsiElement context) {
        OCInstanceVariablesList oCInstanceVariablesList = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c {} @end", context)).getInstanceVariablesList();
        if (oCInstanceVariablesList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "instanceVariableList"));
        }
        return oCInstanceVariablesList;
    }

    @NotNull
    public static OCDeclaration constructorFromText(String text, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.constructorFromText(text, context, false);
        if (oCDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "constructorFromText"));
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclaration constructorFromText(String text, PsiElement context, boolean reformat) {
        String name = text.substring(0, text.indexOf(40));
        OCTypeElement type = OCElementFactory.typeElementFromTextOrNull("struct " + name + " { " + text + ";}", context, reformat);
        OCStruct struct = (OCStruct)type.getFirstChild();
        OCDeclaration oCDeclaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)struct, OCFunctionDeclaration.class);
        if (oCDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "constructorFromText"));
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCConstructorInitializationList constructorInitializationList(OCElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : y(1) {}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCChangeUtil.delete(list.getInitializers().get(0));
        OCConstructorInitializationList oCConstructorInitializationList = list;
        if (oCConstructorInitializationList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "constructorInitializationList"));
        }
        return oCConstructorInitializationList;
    }

    @NotNull
    public static OCConstructorFieldInitializer constructorFieldInitializerFromText(String text, PsiElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : " + text + "{}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCConstructorFieldInitializer oCConstructorFieldInitializer = list.getInitializers().get(0);
        if (oCConstructorFieldInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "constructorFieldInitializerFromText"));
        }
        return oCConstructorFieldInitializer;
    }

    @NotNull
    public static OCPropertyAttributesList propertyAttributeList(OCPropertySymbol.PropertyAttribute attribute, @Nullable String value, PsiElement context) {
        String text = "@interface c @property (" + attribute.getTokenName() + (value != null ? "=" + value : "") + ") int x; @end";
        OCPropertyAttributesList oCPropertyAttributesList = ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0).getPropertyAttributesList();
        if (oCPropertyAttributesList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "propertyAttributeList"));
        }
        return oCPropertyAttributesList;
    }

    @NotNull
    public static OCSynthesizePropertiesList synthesizeList(String myKeyword, String property, @Nullable String ivar, PsiElement context) {
        String text = "@implementation i " + myKeyword + " " + property + (ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        OCSynthesizePropertiesList oCSynthesizePropertiesList = (OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class);
        if (oCSynthesizePropertiesList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "synthesizeList"));
        }
        return oCSynthesizePropertiesList;
    }

    @NotNull
    public static OCSynthesizeProperty synthesize(String property, @Nullable String ivar, PsiElement context) {
        String text = "@implementation i @synthesize " + property + (ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        OCSynthesizeProperty oCSynthesizeProperty = ((OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class)).getProperties().get(0);
        if (oCSynthesizeProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "synthesize"));
        }
        return oCSynthesizeProperty;
    }

    @NotNull
    private static String declaratorText(String name, OCType type, PsiElement context, boolean eraseARCAttributes) {
        if (type.getAliasName() == null) {
            if (type instanceof OCArrayType) {
                OCArrayType arrayType = (OCArrayType)type;
                int length = arrayType.getLength();
                if (name.startsWith("*")) {
                    name = "(" + name + ")";
                }
                String string = OCElementFactory.declaratorText(name + " [" + (arrayType.hasLength() ? Integer.valueOf(length) : "") + "]", arrayType.getRefType(), context, eraseARCAttributes);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declaratorText"));
                }
                return string;
            }
            if (type instanceof OCPointerType) {
                OCPointerType pointerType = (OCPointerType)type;
                if (!(pointerType.getRefType() instanceof OCIdType)) {
                    name = (type instanceof OCBlockPointerType ? "^" : "*") + (pointerType.isConst() ? " const " : "") + (pointerType.isVolatile() ? " volatile " : "") + name;
                }
                String string = (!eraseARCAttributes && pointerType.getARCAttribute() != null ? pointerType.getARCAttribute().getTokenName() + " " : "") + OCElementFactory.declaratorText(name, pointerType.getRefType(), context, eraseARCAttributes);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declaratorText"));
                }
                return string;
            }
            if (type instanceof OCFunctionType) {
                OCFunctionType funType = (OCFunctionType)type;
                StringBuilder b = new StringBuilder();
                b.append(funType.getReturnType().getBestNameInContext(context));
                b.append(" (").append(name).append(")");
                b.append(OCTypeNameVisitor.getFunctionSignature(context, funType, "", false, null));
                String string = b.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declaratorText"));
                }
                return string;
            }
        }
        String string = type.getBestNameInContext(context) + " " + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declaratorText"));
        }
        return string;
    }

    @NotNull
    public static String declarationText(@NotNull List<String> modifiers, String name, OCType type, @Nullable String initializerText, @NotNull PsiElement context, @Nullable String typeNameHint, boolean eraseARCAttributes) {
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationText"));
        }
        if (type instanceof OCFunctionType && type.getAliasName() == null) {
            type = OCPointerType.to(type);
        }
        if (type == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationText"));
            }
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (String modifier : modifiers) {
            b.append(modifier).append(' ');
        }
        if (type instanceof OCPointerType && type.getAliasName() == null) {
            b.append(OCElementFactory.declaratorText(name, type, context, eraseARCAttributes));
        } else {
            if (type instanceof OCUnknownType) {
                PsiFile file2 = context.getContainingFile();
                if (file2 instanceof OCFile) {
                    b.append(((OCFile)file2).getKind().isObjC() ? "id" : "int");
                } else {
                    b.append("id");
                }
            } else {
                b.append(type.getBestNameInContext(context));
            }
            b.append(' ').append(name);
        }
        String declarationText = b.toString();
        if (typeNameHint != null && OCCodeInsightUtil.isSimpleDeclaration(b.toString(), name) && modifiers.isEmpty() && type.equalsAfterResolving(typeNameHint, new OCResolveContext(context))) {
            declarationText = typeNameHint + " " + name;
        }
        if (initializerText != null) {
            String string = declarationText + '=' + initializerText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationText"));
            }
            return string;
        }
        String string = declarationText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "declarationText"));
        }
        return string;
    }

    @NotNull
    public static PsiElement createIdentifier(String name, PsiElement context) {
        OCCodeFragment fragment = OCElementFactory.codeFragment("int " + name, context.getProject(), null, false, false);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)fragment, OCElement.class);
        List<OCDeclarator> declarators = declaration != null ? declaration.getDeclarators() : null;
        LOG.assertTrue(declarators != null && !declarators.isEmpty(), (Object)("Bad identifier name " + name));
        PsiElement psiElement = declarators.get(0).getNameIdentifier();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "createIdentifier"));
        }
        return psiElement;
    }

    @NotNull
    public static OCMacroForeignLeafElement createMacroForeignIdentifier(String name, OCMacroForeignLeafElement sample) {
        OCCodeFragment fragment = OCElementFactory.codeFragment("#define M(x) x\nint M(" + name + ")", sample.getProject(), null, false, false);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)fragment, OCDeclaration.class);
        List<OCDeclarator> declarators = declaration != null ? declaration.getDeclarators() : null;
        LOG.assertTrue(declarators != null && !declarators.isEmpty(), (Object)("Bad identifier name " + name));
        OCMacroForeignLeafElement identifier = (OCMacroForeignLeafElement)declarators.get(0).getNameIdentifier();
        identifier.copyFromElement(sample);
        OCMacroForeignLeafElement oCMacroForeignLeafElement = identifier;
        if (oCMacroForeignLeafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "createMacroForeignIdentifier"));
        }
        return oCMacroForeignLeafElement;
    }

    @NotNull
    public static OCCppNamespaceQualifier createNamespaceQualifier(String name, PsiElement context) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct " + name + "::XXXX {}", context, true).getTypeElement().getFirstChild();
        OCCppNamespaceQualifier oCCppNamespaceQualifier = struct.getNamespaceQualifier();
        if (oCCppNamespaceQualifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "createNamespaceQualifier"));
        }
        return oCCppNamespaceQualifier;
    }

    @NotNull
    public static ASTNode createColon2x(PsiElement context) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct A::B{}", context).getTypeElement().getFirstChild();
        ASTNode aSTNode = struct.getNode().findChildByType((IElementType)OCTokenTypes.COLON2X);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "createColon2x"));
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "topLevelDeclarationFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "topLevelDeclarationFromText"));
        }
        PsiElement psiElement = OCElementFactory.topLevelDeclarationFromText(text, context, false);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "topLevelDeclarationFromText"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "topLevelDeclarationFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "topLevelDeclarationFromText"));
        }
        OCCodeFragment element = OCElementFactory.codeFragment(text, context.getProject(), context, false, reformat);
        PsiElement child = element.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof OCMacroCall) {
            child = child.getNextSibling();
        }
        PsiElement psiElement = child;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "topLevelDeclarationFromText"));
        }
        return psiElement;
    }

    @NotNull
    public static OCTypeElement typeElementFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeElementFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeElementFromText"));
        }
        OCTypeElement oCTypeElement = OCElementFactory.typeElementFromTextOrNull(text, context, true);
        if (oCTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeElementFromText"));
        }
        return oCTypeElement;
    }

    @Nullable
    public static OCTypeElement typeElementFromTextOrNull(@NotNull String text, @NotNull PsiElement context, boolean formatToCodestyle) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeElementFromTextOrNull"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeElementFromTextOrNull"));
        }
        return (OCTypeElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.typeCodeFragment(text, context.getProject(), context, false, formatToCodestyle), OCTypeElement.class);
    }

    @Nullable
    public static OCReferenceElement referenceElementFromText(@NotNull String name, @NotNull PsiElement context, boolean formatToCodestyle) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/util/OCElementFactory", "referenceElementFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "referenceElementFromText"));
        }
        return (OCReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionFromText(name, context, formatToCodestyle), OCReferenceElement.class);
    }

    @Nullable
    public static OCExpression expressionFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionFromText"));
        }
        return OCElementFactory.expressionFromText(text, context, true);
    }

    @Nullable
    public static OCExpression expressionFromText(@NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionFromText"));
        }
        return (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(text, context.getProject(), context, false, reformat), OCExpression.class);
    }

    public static OCStatement statementFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "statementFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "statementFromText"));
        }
        return OCElementFactory.statementFromText(text, context, false);
    }

    public static OCStatement statementFromText(@NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "statementFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "statementFromText"));
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        text = builder.append("void _______dummy(){").append(text).append(";}").toString();
        StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        OCCodeFragment element = OCElementFactory.codeFragment(text, context.getProject(), context, false, reformat);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCFunctionDefinition.class);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCBlockStatement.class);
        return (OCStatement)PsiTreeUtil.getChildOfType((PsiElement)element, OCStatement.class);
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean reformat) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project, context, OCTokenTypes.OC_FILE, physical, reformat);
        if (oCCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionCodeFragment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionCodeFragment"));
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle);
        if (oCCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionCodeFragment"));
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle, OCLanguageKind kind) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionCodeFragment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionCodeFragment"));
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project, context, (IFileElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, kind);
        if (oCCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionCodeFragment"));
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragmentCpp(@NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionCodeFragmentCpp"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionCodeFragmentCpp"));
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project, context, (IFileElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, true, formatToCodestyle);
        if (oCCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionCodeFragmentCpp"));
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment expressionOrStatementsCodeFragment(@NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionOrStatementsCodeFragment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionOrStatementsCodeFragment"));
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project, context, OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT, physical, formatToCodestyle);
        if (oCCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "expressionOrStatementsCodeFragment"));
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeCodeFragment"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeCodeFragment"));
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.typeCodeFragment(text, context.getProject(), context, true, false);
        if (oCCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeCodeFragment"));
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NotNull String text, @NotNull Project project, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeCodeFragment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeCodeFragment"));
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project, context, OCElementTypes.TYPE_CODE_FRAGMENT, physical, formatToCodestyle);
        if (oCCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "typeCodeFragment"));
        }
        return oCCodeFragment;
    }

    public static OCCodeFragment getTypeCodeFragmentInWriteAction(final String text, final @NotNull Project project, final @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "getTypeCodeFragmentInWriteAction"));
        }
        return (OCCodeFragment)new WriteCommandAction<OCCodeFragment>(project, new PsiFile[0]){

            protected void run(@NotNull Result<OCCodeFragment> result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/util/OCElementFactory$1", "run"));
                }
                result2.setResult((Object)OCElementFactory.typeCodeFragment(text, project, context, true, true));
            }
        }.execute().getResultObject();
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle) {
        PsiFile file2;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        boolean isCpp = false;
        if (context != null && (file2 = context.getContainingFile()) instanceof OCFile) {
            isCpp = ((OCFile)file2).isCpp();
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project, context, type, physical, isCpp, formatToCodestyle);
        if (oCCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean isCpp, boolean formatToCodestyle) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project, context, type, physical, formatToCodestyle, isCpp ? OCLanguageKind.OBJ_CPP : OCLanguageKind.OBJ_C);
        if (oCCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, final @NotNull Project project, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle, OCLanguageKind kind) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        text = text.trim();
        String name = "fragment." + (kind.isCpp() ? (kind.isObjC() ? "mm" : "cpp") : (kind.isObjC() ? "m" : "c"));
        final OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(project, name, text, physical, (IElementType)type);
        if (context != null && context.isValid()) {
            fragment.setContext(context);
        }
        Application app = ApplicationManager.getApplication();
        if (formatToCodestyle) {
            if (app.isWriteAccessAllowed()) {
                PostprocessReformattingAspect.getInstance(project).disablePostprocessFormattingInside(new Runnable(){

                    @Override
                    public void run() {
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)fragment);
                    }
                });
            } else {
                LOG.error("Write access is required");
            }
        }
        OCCodeFragmentImpl oCCodeFragmentImpl = fragment;
        if (oCCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "codeFragment"));
        }
        return oCCodeFragmentImpl;
    }

    @NotNull
    public static PsiElement create(@NotNull OCElementType type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/util/OCElementFactory", "create"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "create"));
        }
        OCCodeFragment fragment = OCElementFactory.codeFragment(type.getName(), context.getProject(), context, true, false);
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)fragment, LeafPsiElement.class);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "create"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement spaceFromText(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "spaceFromText"));
        }
        PsiElement psiElement = OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("a b", context)).get(1);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "spaceFromText"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement newlineFromText(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCElementFactory", "newlineFromText"));
        }
        PsiElement psiElement = OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("a\nb", context)).get(1);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCElementFactory", "newlineFromText"));
        }
        return psiElement;
    }

    public static void initIndentFromContext(@NotNull PsiElement oldElement, @NotNull PsiElement newElement) {
        if (oldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/jetbrains/cidr/lang/util/OCElementFactory", "initIndentFromContext"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/cidr/lang/util/OCElementFactory", "initIndentFromContext"));
        }
        PsiFile context = oldElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)newElement.getNode(), IndentHelper.getInstance().getIndent(context.getProject(), context.getFileType(), oldElement.getNode()));
    }
}

