/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCNonStaticOperatorType;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCodeInsightUtil {
    private OCCodeInsightUtil() {
    }

    public static boolean isInPlainOldC(@Nullable PsiElement element) {
        if (element != null && element.isValid() && element.getContainingFile() instanceof OCFile) {
            return !((OCFile)element.getContainingFile()).isCpp();
        }
        return false;
    }

    public static boolean isInPlainOldC(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        if (context != null) {
            return !context.getLanguageKind().isCpp();
        }
        if (file2 != null) {
            return OCCodeInsightUtil.isInPlainOldC((PsiElement)file2);
        }
        return true;
    }

    public static boolean isValid(@Nullable PsiElement element) {
        if (!OCSearchScope.isInProjectSources(element)) {
            return false;
        }
        OCMacroRange rangeInMacroCall = OCElementUtil.getRangeInMacroCall(element);
        if (rangeInMacroCall == null) {
            return true;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element);
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)element);
        PsiElement firstChild = PsiTreeUtil.firstChild((PsiElement)element);
        if (!(firstChild instanceof OCMacroForeignLeafElement)) {
            return false;
        }
        String macroName = ((OCMacroForeignLeafElement)firstChild).getMacroName();
        if (prevLeaf instanceof PsiErrorElement || nextLeaf instanceof PsiErrorElement) {
            return false;
        }
        if (prevLeaf instanceof OCMacroForeignLeafElement && Comparing.equal((String)((OCMacroForeignLeafElement)prevLeaf).getMacroName(), (String)macroName)) {
            return false;
        }
        return !(nextLeaf instanceof OCMacroForeignLeafElement) || !Comparing.equal((String)((OCMacroForeignLeafElement)nextLeaf).getMacroName(), (String)macroName);
    }

    @Nullable
    public static OCClassSymbol getClassInFile(OCFile file2) {
        final String fileName = FileUtil.getNameWithoutExtension((String)file2.getName());
        final OCClassSymbol[] result2 = new OCClassSymbol[]{null};
        file2.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (result2[0] == null || Comparing.equal((String)dcl.getName(), (String)fileName) && (!Comparing.equal((String)result2[0].getName(), (String)fileName) || dcl.getCategory() == null)) {
                    result2[0] = dcl.getSymbol();
                }
            }
        });
        return result2[0];
    }

    @Nullable
    public static OCExpression findExpressionAtRange(PsiFile file2, int startOffset, int endOffset) {
        return OCCodeInsightUtil.findElementAtRange(file2, startOffset, endOffset, OCExpression.class, true);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file2, TextRange range, Class<E> elementClass, boolean requireExactRange) {
        return OCCodeInsightUtil.findElementAtRange(file2, range.getStartOffset(), range.getEndOffset(), elementClass, requireExactRange);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file2, int startOffset, int endOffset, Class<E> elementClass, boolean requireExactRange) {
        PsiElement nameIdentifier;
        TextRange nodeRange;
        PsiElement parent;
        PsiElement node = file2.findElementAt(startOffset);
        while (node != null) {
            TextRange range = node.getTextRange();
            if (range == null) {
                return null;
            }
            if (range.containsRange(startOffset, endOffset)) break;
            if (node instanceof OCMacroCall) {
                if ((node = ((OCMacroCall)node).getExpansionExpression()) == null || range.getStartOffset() != startOffset) continue;
                startOffset = node.getTextRange().getStartOffset();
                continue;
            }
            node = node.getParent();
        }
        if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)node, (Class[])new Class[]{elementClass, OCMacroCall.class})) != null) {
            node = parent;
        }
        TextRange textRange = nodeRange = node != null ? node.getTextRange() : null;
        if (node instanceof OCMacroCall) {
            node = ((OCMacroCall)node).getExpansionExpression();
        }
        if (node instanceof OCMacroCallArgument && node.getChildren().length >= 1) {
            node = node.getChildren()[0];
        }
        if (elementClass.equals(OCExpression.class) && node instanceof OCExpressionStatement) {
            node = ((OCExpressionStatement)node).getExpression();
            nodeRange = node.getTextRange();
        }
        if (elementClass.equals(OCDeclarator.class) && node instanceof OCDeclarator && (nameIdentifier = ((OCDeclarator)node).getNameIdentifier()) != null && nameIdentifier.getTextRange().equalsToRange(startOffset, endOffset)) {
            requireExactRange = false;
        }
        if (requireExactRange && nodeRange != null && !nodeRange.equalsToRange(startOffset, endOffset)) {
            return null;
        }
        return (E)(elementClass.isInstance(node) ? node : null);
    }

    @Nullable
    public static PsiElement[] findStatementsAtRange(PsiFile file2, int startOffset, int endOffset, boolean requireExactRange) {
        PsiElement nextSibling;
        PsiElement lastItem;
        PsiElement element1 = file2.findElementAt(startOffset);
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file2.findElementAt(endOffset - 1);
        }
        if (OCElementUtil.getElementType(element2) == OCTokenTypes.EOL_COMMENT && element1 != element2) {
            element2 = element2.getNextSibling();
            endOffset = element2.getTextRange().getEndOffset();
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof OCBlockStatement) && !(parent instanceof OCCodeFragment)) {
            if (parent instanceof OCStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent == null || parent instanceof OCFile) {
                return null;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (requireExactRange && startOffset != element1.getTextRange().getStartOffset()) {
            return null;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (requireExactRange && endOffset != element2.getTextRange().getEndOffset() && (endOffset + 1 != element2.getTextRange().getEndOffset() || file2.getText().charAt(endOffset) != ';')) {
            return null;
        }
        if (parent instanceof OCBlockStatement && (requireExactRange ? parent.getFirstChild() == element1 && parent.getLastChild() == element2 : parent.getFirstChild() == element1 || parent.getLastChild() == element2)) {
            PsiElement[] psiElementArray;
            if (parent.getParent() instanceof OCCallable) {
                psiElementArray = null;
            } else {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = parent;
            }
            return psiElementArray;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        if (element2 instanceof OCMacroCall) {
            PsiElement nextSibling2 = element2.getNextSibling();
            element2 = nextSibling2 != null ? nextSibling2 : element2;
        }
        boolean flag = false;
        for (PsiElement child : OCElementUtil.getAllChildren(parent)) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof OCMacroCall)) {
                array.add(child);
            }
            if (!child.equals(element2)) continue;
            break;
        }
        if ((lastItem = (PsiElement)ContainerUtil.getLastItem(array)) instanceof OCDirective && (nextSibling = lastItem.getNextSibling()) != null && OCElementUtil.isWhitespace(nextSibling)) {
            array.add(nextSibling);
        }
        for (PsiElement element : array) {
            if (element instanceof OCStatement || !OCElementUtil.isElementSignificant(element)) continue;
            return null;
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    public static <E extends PsiElement> List<E> findElementOccurrences(@Nullable PsiElement scope, @NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "findElementOccurrences"));
        }
        ArrayList<E> answer = new ArrayList<E>();
        if (scope == null || !PsiTreeUtil.isAncestor((PsiElement)scope, element, (boolean)false)) {
            answer.add(element);
        }
        if (element instanceof OCExpression && OCElementUtil.getRangeInMacroCall(element) == null) {
            element = OCParenthesesUtils.diveIntoParentheses((OCExpression)element);
        }
        if (scope != null) {
            OCCodeInsightUtil.addOccurrencesIn(element, OCElementUtil.getElementType(element), scope, answer);
        }
        return answer;
    }

    private static <E extends PsiElement> void addOccurrencesIn(E element, IElementType elementType, PsiElement scope, List<E> answer) {
        if (OCElementUtil.getElementType(scope) == elementType && OCElementUtil.areElementsEquivalent(element, scope, false)) {
            if (scope instanceof OCExpression) {
                scope = OCParenthesesUtils.topmostParenthesized((OCExpression)scope);
            }
            answer.add(scope);
        } else {
            for (PsiElement c : scope.getChildren()) {
                OCCodeInsightUtil.addOccurrencesIn(element, elementType, c, answer);
            }
        }
    }

    public static boolean isLValue(OCExpression expr) {
        OCExpression unparen = OCParenthesesUtils.topmostParenthesized(expr);
        return OCCodeInsightUtil.isAssignmentLHS(unparen) || unparen.getParent() instanceof OCUnaryExpression && ((OCUnaryExpression)unparen.getParent()).isGetAddress();
    }

    public static boolean isAssignmentLHS(OCExpression expr) {
        OCExpression unparen = OCParenthesesUtils.topmostParenthesized(expr);
        PsiElement parent = unparen.getParent();
        if (parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getReceiverExpression() == unparen) {
            return true;
        }
        if (parent instanceof OCPostfixExpression) {
            OCElementType sign = ((OCPostfixExpression)parent).getOperationSign();
            return sign == OCTokenTypes.PLUSPLUS || sign == OCTokenTypes.MINUSMINUS;
        }
        if (parent instanceof OCPrefixExpression) {
            OCElementType sign = ((OCPrefixExpression)parent).getOperationSign();
            return sign == OCTokenTypes.PLUSPLUS || sign == OCTokenTypes.MINUSMINUS;
        }
        return false;
    }

    public static boolean hasSideEffects(@NotNull OCElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "hasSideEffects"));
        }
        final Ref result2 = Ref.create((Object)false);
        element.accept(new OCRecursiveVisitor(){

            @Override
            public void visitPrefixExpression(OCPrefixExpression expression) {
                if (expression.getOperationSign() == OCTokenTypes.PLUSPLUS || expression.getOperationSign() == OCTokenTypes.MINUSMINUS) {
                    result2.set((Object)true);
                } else {
                    super.visitPrefixExpression(expression);
                }
            }

            @Override
            public void visitPostfixExpression(OCPostfixExpression expression) {
                if (expression.getOperationSign() == OCTokenTypes.PLUSPLUS || expression.getOperationSign() == OCTokenTypes.MINUSMINUS) {
                    result2.set((Object)true);
                } else {
                    super.visitPostfixExpression(expression);
                }
            }

            @Override
            public void visitAssignmentExpression(OCAssignmentExpression expression) {
                result2.set((Object)true);
            }

            @Override
            public void visitCallExpression(OCCallExpression expression) {
                result2.set((Object)true);
            }

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                result2.set((Object)true);
            }

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                result2.set((Object)true);
            }

            @Override
            public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
                result2.set((Object)true);
            }

            @Override
            public void visitStatementExpression(OCStatementExpression statementExpression) {
                result2.set((Object)true);
            }

            @Override
            public void visitCppNewExpression(OCCppNewExpression expression) {
                result2.set((Object)true);
            }
        });
        return (Boolean)result2.get();
    }

    public static <E extends PsiElement> void collectElements(PsiFile file2, Editor editor, int offset, Class<E> elementClass, List<? super E> elements) {
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else if (!Character.isJavaIdentifierPart(text.charAt(correctedOffset))) {
            if (text.charAt(correctedOffset) == ';') {
                --correctedOffset;
            }
            if (text.charAt(correctedOffset) != ')') {
                correctedOffset = offset;
            }
        }
        PsiElement elementAtCaret = file2.findElementAt(correctedOffset);
        PsiElement context = OCCodeInsightUtil.getElementOrMacroCall(elementAtCaret, elementClass);
        while (context != null) {
            PsiElement element;
            if (!elementClass.isInstance(context)) {
                if (!(context instanceof OCMacroCall)) break;
                if (elementClass.equals(OCExpression.class) && (element = ((OCMacroCall)context).getExpansionExpression()) != null) {
                    elements.add(element);
                }
                context = OCCodeInsightUtil.getElementOrMacroCall(context, elementClass);
                continue;
            }
            element = context;
            if (!(elements.contains(element) || element instanceof OCParenthesizedExpression || element instanceof OCAssignmentExpression || element instanceof OCExpression && ((OCExpression)element).getResolvedType().isVoid() || element instanceof OCReferenceExpression && ((OCReferenceExpression)element).getResolvedType() instanceof OCObjectType)) {
                elements.add(element);
            }
            context = OCCodeInsightUtil.getElementOrMacroCall(context, elementClass);
        }
    }

    @Nullable
    private static <E extends PsiElement> PsiElement getElementOrMacroCall(PsiElement context, Class<E> elementClass) {
        return PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{elementClass, OCMacroCall.class});
    }

    public static boolean isUniqueInScope(@Nullable OCSymbolKind symbolKind, String name, @Nullable PsiElement scope, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "isUniqueInScope"));
        }
        return OCCodeInsightUtil.resolveNameInScope(symbolKind, name, null, scope, project) == null;
    }

    public static OCSymbol resolveNameInScope(final @Nullable OCSymbolKind symbolKind, final String name, final @Nullable String categoryName, @Nullable PsiElement scope, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "resolveNameInScope"));
        }
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                if (symbol.isSynthetic()) {
                    return false;
                }
                if (categoryName != null && symbol instanceof OCClassSymbol && !categoryName.equals(((OCClassSymbol)symbol).getCategoryName())) {
                    return false;
                }
                return symbolKind == null || OCResolveUtil.isDuplicate(symbolKind, symbol.getKind());
            }
        };
        if (scope == null) {
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<OCSymbol>)processor2, name);
        } else {
            OCResolveUtil.processSymbols(name, scope, (Processor<OCSymbol>)processor2);
        }
        if (processor2.isFound()) {
            return (OCSymbol)processor2.getFoundValue();
        }
        OCBlockStatement block = (OCBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)scope, OCBlockStatement.class, (boolean)false, (Class[])new Class[]{OCBlockExpression.class, OCLambdaExpression.class});
        if (block == null) {
            return null;
        }
        try {
            block.accept(new OCVisitor(){

                @Override
                public void visitOCElement(OCElement elem) {
                    elem.acceptChildren(this);
                }

                @Override
                public void visitDeclarator(OCDeclarator declarator) {
                    if (name.equals(declarator.getName())) {
                        throw new CancelException(declarator);
                    }
                }
            });
        }
        catch (CancelException e) {
            return e.getDeclarator().getSymbol();
        }
        return null;
    }

    public static void selectBody(Editor editor, OCBlockStatement body) {
        if (body == null) {
            return;
        }
        ASTNode firstNode = body.getNode().getFirstChildNode().getTreeNext();
        ASTNode lastNode = body.getNode().getLastChildNode().getTreePrev();
        while (OCTokenTypes.WHITESPACES.contains(firstNode.getElementType())) {
            firstNode = firstNode.getTreeNext();
        }
        while (OCTokenTypes.WHITESPACES.contains(lastNode.getElementType())) {
            lastNode = lastNode.getTreePrev();
        }
        if (firstNode != body.getNode().getLastChildNode()) {
            OCCodeInsightUtil.selectRange(editor, firstNode.getStartOffset(), lastNode.getTextRange().getEndOffset());
        } else {
            OCCodeInsightUtil.selectRange(editor, body.getTextOffset() + 1, body.getTextOffset() + 1);
        }
    }

    public static void selectElement(PsiElement element) {
        if (element == null) {
            return;
        }
        Editor editor = EditorHelper.openInEditor(element);
        if (editor != null) {
            OCCodeInsightUtil.selectRange(editor, element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
        }
    }

    public static void selectRange(Editor editor, int startOffset, int endOffset) {
        editor.getCaretModel().moveToOffset(startOffset);
        editor.getSelectionModel().setSelection(startOffset, endOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public static String getClassNameWithCategory(String className, String categoryName) {
        if (categoryName == null) {
            return className;
        }
        StringBuilder builder = new StringBuilder(className.length() + categoryName.length() + 3);
        builder.append(className).append(" + ").append(categoryName.isEmpty() ? "()" : categoryName);
        return builder.toString();
    }

    @Nullable
    public static OCClassDeclaration getPrivateCategory(OCClassDeclarationBase declaration) {
        for (PsiElement child : declaration.getContainingFile().getChildren()) {
            if (!(child instanceof OCClassDeclaration)) continue;
            OCClassDeclaration category = (OCClassDeclaration)child;
            if (!declaration.getName().equals(category.getName()) || !"".equals(category.getCategory())) continue;
            return category;
        }
        return null;
    }

    @Nullable
    public static OCType getReturnTypeOfBeginEndPair(OCExpression expr, @NotNull OCStructType structType, @NotNull OCFile file2) {
        if (structType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structType", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getReturnTypeOfBeginEndPair"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getReturnTypeOfBeginEndPair"));
        }
        OCResolveContext context = new OCResolveContext(file2);
        CVQualifiers cvQualifiers = OCCodeInsightUtil.getCVQualifiers(expr, structType);
        Collection<OCSymbol> beginSymbols = structType.collectMethods("begin", context);
        OCSymbol beginSymbol = OCResolveOverloadsUtil.resolveOverloads(beginSymbols, Collections.<OCType>emptyList(), null, cvQualifiers, context, null, true, true, false);
        if (beginSymbol == null) {
            return null;
        }
        assert (beginSymbol instanceof OCFunctionSymbol);
        OCType beginReturnType = beginSymbol.getEffectiveType().resolve(file2);
        Collection<OCSymbol> endSymbols = structType.collectMethods("end", context);
        OCSymbol endSymbol = OCResolveOverloadsUtil.resolveOverloads(endSymbols, Collections.<OCType>emptyList(), null, cvQualifiers, context, null, true, true, false);
        if (endSymbol == null) {
            return null;
        }
        assert (endSymbol instanceof OCFunctionSymbol);
        OCType endReturnType = beginSymbol.getEffectiveType().resolve(file2);
        if (endReturnType.equals((Object)beginReturnType, file2)) {
            return beginReturnType;
        }
        return null;
    }

    public static boolean isCodeInsightAvailable(long fileLength) {
        return fileLength >= 0L && fileLength <= (long)OCCodeInsightUtil.getMaxFileLength();
    }

    public static int getMaxFileLength() {
        return OCCodeInsightUtil.getMaxFileLengthRegistryKey().asInteger();
    }

    public static void setMaxFileLength(int newValue) {
        if (newValue > 0) {
            OCCodeInsightUtil.getMaxFileLengthRegistryKey().setValue(newValue);
        }
    }

    public static void resetMaxFileLength() {
        OCCodeInsightUtil.getMaxFileLengthRegistryKey().resetToDefault();
    }

    @NotNull
    private static RegistryValue getMaxFileLengthRegistryKey() {
        RegistryValue registryValue = Registry.get((String)"cidr.max.intellisense.file.length");
        if (registryValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getMaxFileLengthRegistryKey"));
        }
        return registryValue;
    }

    public static Pair<List<OCElement>, OCSymbolKind> getScopeAndKind(PsiElement element) {
        OCElement scopeElement;
        OCSymbolKind kind = null;
        List<Object> scope = null;
        if (element.getParent().getParent() instanceof OCTemplateParameterList) {
            kind = OCSymbolKind.TEMPLATE_VALUE_PARAMETER;
            scopeElement = null;
        } else {
            scopeElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCLocalScopeable.class, OCEnum.class});
            if (scopeElement instanceof OCEnum && !((OCEnum)scopeElement).isEnumClass()) {
                kind = OCSymbolKind.ENUM_CONST;
                scopeElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCLocalScopeable.class});
            } else if (scopeElement instanceof OCStructLike) {
                kind = element instanceof OCFunctionDefinition ? (((OCFunctionDefinition)element).getBody() != null ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.FUNCTION_PREDECLARATION) : OCSymbolKind.STRUCT_FIELD;
            } else if (scopeElement instanceof OCParameterList) {
                PsiElement parent = scopeElement.getContext();
                if (parent instanceof OCCatchSection) {
                    kind = OCSymbolKind.CATCH_EXCEPTION_VARIABLE;
                    scopeElement = ((OCCatchSection)parent).getBody();
                } else {
                    kind = OCSymbolKind.PARAMETER;
                    PsiElement callable = PsiTreeUtil.getContextOfType((PsiElement)scopeElement, (Class[])new Class[]{OCCallable.class, OCParameterList.class, OCMethodSelectorPart.class, OCDeclarator.class, OCTypeElement.class});
                    if (callable instanceof OCDeclarator && callable.getParent() instanceof OCCallable) {
                        callable = callable.getParent();
                    }
                    if (callable instanceof OCCallable) {
                        if (callable instanceof OCFunctionDefinition && (PsiTreeUtil.getChildOfType((PsiElement)((OCFunctionDefinition)callable).getDeclarator(), OCConstructorInitializationList.class) != null || PsiTreeUtil.getChildOfType((PsiElement)callable, OCCatchSection.class) != null)) {
                            scopeElement = (OCFunctionDefinition)callable;
                        } else {
                            scope = new ArrayList();
                            OCBlockStatement body = ((OCCallable)callable).getBody();
                            OCNoexceptSpecifier noexceptSpecifier = ((OCCallable)callable).getNoexceptSpecifier();
                            OCTypeElement typeElement = callable instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)callable).getTrailingReturnTypeElement() : ((OCCallable)callable).getReturnTypeElement();
                            scope.add(body != null ? body : scopeElement);
                            if (noexceptSpecifier != null) {
                                scope.add(noexceptSpecifier);
                            }
                            if (typeElement != null) {
                                scope.add(typeElement);
                            }
                        }
                    }
                }
            } else if (scopeElement instanceof OCMethod) {
                kind = OCSymbolKind.PARAMETER;
                scopeElement = ((OCMethod)scopeElement).getBody();
            }
        }
        if (scope == null) {
            scope = scopeElement != null ? Collections.singletonList(scopeElement) : Collections.emptyList();
        }
        return Pair.create(scope, (Object)((Object)kind));
    }

    public static boolean isNonStaticFieldAccess(@NotNull OCDeclaratorSymbol symbol, @NotNull OCStructSymbol parent, OCExpression expression) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "isNonStaticFieldAccess"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "isNonStaticFieldAccess"));
        }
        return !symbol.isStatic() && !symbol.isMutable() && OCCodeInsightUtil.isMemberAccess(symbol, parent, expression);
    }

    public static boolean isMemberAccess(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCStructSymbol parent, OCExpression expression) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "isMemberAccess"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "isMemberAccess"));
        }
        if (!(symbol instanceof OCFunctionSymbol) && symbol.getKind() != OCSymbolKind.STRUCT_FIELD) {
            return false;
        }
        OCSymbolWithQualifiedName memberParent = symbol.getResolvedOwner();
        if (!(memberParent instanceof OCStructSymbol) || !((OCStructSymbol)memberParent).isAncestor(parent)) {
            return false;
        }
        return expression instanceof OCReferenceExpression || expression instanceof OCQualifiedExpression && ((OCQualifiedExpression)expression).getQualifier() instanceof OCReferenceExpression && ((OCReferenceExpression)((OCQualifiedExpression)expression).getQualifier()).isCppThis();
    }

    @Nullable
    public static CVQualifiers getOuterFunctionCVQualifiers(@NotNull OCDeclaratorSymbol symbol, OCExpression expression, @Nullable Ref<OCFunctionSymbol> functionSymbolRef) {
        OCSymbolWithQualifiedName parent;
        OCFunctionSymbol functionSymbol;
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getOuterFunctionCVQualifiers"));
        }
        OCFunctionDefinition function = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)expression, OCFunctionDefinition.class);
        OCFunctionSymbol oCFunctionSymbol = functionSymbol = function != null ? function.getSymbol() : null;
        if (functionSymbolRef != null) {
            functionSymbolRef.set((Object)functionSymbol);
        }
        if (functionSymbol != null && (parent = functionSymbol.getResolvedOwner()) instanceof OCStructSymbol && OCCodeInsightUtil.isNonStaticFieldAccess(symbol, (OCStructSymbol)parent, expression)) {
            return functionSymbol.getType().getCVQualifiers();
        }
        return null;
    }

    @NotNull
    public static CVQualifiers getCVQualifiers(OCExpression expression, OCType type) {
        boolean considerOuterFunction = type instanceof OCStructType;
        CVQualifiers modifiers = type.getTerminalType().getCVQualifiers();
        if (considerOuterFunction && expression instanceof OCReferenceExpression) {
            CVQualifiers functionCVQualifiers;
            OCSymbol symbol = ((OCReferenceExpression)expression).resolveToSymbol();
            CVQualifiers cVQualifiers = functionCVQualifiers = symbol instanceof OCDeclaratorSymbol ? OCCodeInsightUtil.getOuterFunctionCVQualifiers((OCDeclaratorSymbol)symbol, expression, null) : null;
            if (functionCVQualifiers != null) {
                modifiers = modifiers.or(functionCVQualifiers);
            }
        }
        CVQualifiers cVQualifiers = modifiers;
        if (cVQualifiers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getCVQualifiers"));
        }
        return cVQualifiers;
    }

    public static String getPrettyNameFromClassName(Class clazz) {
        String className = clazz.getSimpleName();
        if (clazz.isAnonymousClass()) {
            className = clazz.getSuperclass().getSimpleName();
        }
        StringBuilder result2 = new StringBuilder();
        if (className.startsWith("OC")) {
            className = className.substring("OC".length());
        }
        if (className.endsWith("Inspection")) {
            className = className.substring(0, className.length() - "Inspection".length());
        }
        if (className.endsWith("IntentionAction")) {
            className = className.substring(0, className.length() - "IntentionAction".length());
        }
        for (String word : StringUtil.findMatches((String)className, (Pattern)Pattern.compile("([A-Z][a-z]*)"))) {
            if (result2.length() > 0) {
                result2.append(' ').append(StringUtil.decapitalize((String)word));
                continue;
            }
            result2.append(word);
        }
        return result2.toString();
    }

    public static boolean isLikeNull(@Nullable String literal) {
        return literal != null && ("nil".equals(literal) || "NULL".equals(literal) || "nullptr".equals(literal));
    }

    public static boolean isInitializerListType(OCType type, @Nullable PsiFile file2) {
        if (OCCompilerHelper.supportsInitializerLists(file2) && type instanceof OCStructType) {
            OCQualifiedName name = ((OCStructType)type).getSymbol().getResolvedQualifiedName(false);
            return name != null && name.toString().equals("::std::initializer_list");
        }
        return false;
    }

    public static boolean isSimpleDeclaration(String declarationText, String name) {
        return declarationText.endsWith(name);
    }

    @Nullable
    public static OCType getCollectionElementType(@NotNull OCExpression expr, OCType type) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getCollectionElementType"));
        }
        OCFile file2 = expr.getContainingOCFile();
        OCResolveContext context = new OCResolveContext(file2);
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        OCType iteratorType = null;
        if (type instanceof OCArrayType) {
            iteratorType = type;
        } else {
            if (type instanceof OCStructType) {
                iteratorType = OCCodeInsightUtil.getReturnTypeOfBeginEndPair(expr, (OCStructType)type, file2);
            }
            if (iteratorType == null) {
                OCSymbol begin = OCCodeInsightUtil.getGlobalBeginOrEnd("begin", type, expr, file2, context);
                OCSymbol end = OCCodeInsightUtil.getGlobalBeginOrEnd("end", type, expr, file2, context);
                if (begin != null && end != null) {
                    OCType endReturnType;
                    assert (begin instanceof OCFunctionSymbol);
                    assert (end instanceof OCFunctionSymbol);
                    OCType beginReturnType = begin.getEffectiveType().resolve(file2);
                    if (beginReturnType.equals((Object)(endReturnType = end.getEffectiveType().resolve(file2)), file2)) {
                        iteratorType = beginReturnType;
                    }
                }
            }
        }
        return OCCodeInsightUtil.getDereferencedType(expr, iteratorType);
    }

    @Nullable
    private static OCSymbol getGlobalBeginOrEnd(@NotNull String methodName, @NotNull OCType type, @NotNull OCExpression expr, @NotNull OCFile file2, @NotNull OCResolveContext context) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getGlobalBeginOrEnd"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getGlobalBeginOrEnd"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getGlobalBeginOrEnd"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getGlobalBeginOrEnd"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getGlobalBeginOrEnd"));
        }
        OCQualifiedName beginName = OCQualifiedName.interned(methodName);
        List<OCSymbol<Object>> symbols = new ArrayList<OCSymbol>(OCSymbolReference.getGlobalReference(beginName).resolveToSymbols(file2));
        symbols = ContainerUtil.filter(symbols, (Condition)new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol;
            }
        });
        List<OCType> argTypes = Collections.singletonList(type);
        List<OCExpression> argExprs = Collections.singletonList(expr);
        Collection<OCSymbol> symbolsWithADL = OCArgumentDepLookupAccumulator.doArgDepLookup(symbols, argTypes, argExprs, beginName, file2);
        return OCResolveOverloadsUtil.resolveOverloads(symbolsWithADL, argTypes, argExprs, null, context, null, true, true, false);
    }

    @Nullable
    public static OCType getDereferencedType(@NotNull OCExpression expr, @Nullable OCType iteratorType) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil", "getDereferencedType"));
        }
        OCFile file2 = expr.getContainingOCFile();
        if (iteratorType instanceof OCPointerType) {
            return ((OCPointerType)iteratorType).getRefType();
        }
        if (iteratorType instanceof OCStructType) {
            OCFunctionSymbol operator = OCNonStaticOperatorType.resolveUnaryMulOperator(expr, (OCStructType)iteratorType);
            return operator != null ? operator.getEffectiveType().resolve(file2) : null;
        }
        if (iteratorType instanceof OCMagicType) {
            return new OCMagicType();
        }
        return null;
    }

    public static boolean isUnnamed(OCDeclaratorSymbol field) {
        OCType fieldType = field.getType();
        return fieldType instanceof OCStructType && ((OCStructType)fieldType).isUnnamed();
    }

    static class CancelException
    extends RuntimeException {
        private final OCDeclarator myDeclarator;

        public CancelException(OCDeclarator declarator) {
            this.myDeclarator = declarator;
        }

        public OCDeclarator getDeclarator() {
            return this.myDeclarator;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

