/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallableUtil {
    public static final String IMPLEMENTED_METHOD_TEMPLATE_NAME = "OC Implemented Method Body.m";
    public static final String OVERRIDDEN_METHOD_TEMPLATE_NAME = "OC Overridden Method Body.m";
    private static final String OVERRIDDEN_INIT_METHOD_TEMPLATE_NAME = "OC Overridden InitWith Method Body.m";
    private static final String OVERRIDDEN_IS_EQUAL_METHOD_TEMPLATE_NAME = "OC Overridden IsEqual Method Body.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME1 = "OC Overridden Description Body 1.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME2 = "OC Overridden Description Body 2.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME3 = "OC Overridden Description Body 3.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME1 = "OC Overridden CopyWithZone Body 1.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME2 = "OC Overridden CopyWithZone Body 2.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME3 = "OC Overridden CopyWithZone Body 3.m";
    private static final String PROPERTY_GETTER_TEMPLATE_NAME = "OC Property Getter Body.m";
    private static final String PROPERTY_SETTER_TEMPLATE_NAME = "OC Property Setter Body.m";
    private static final String CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME = "C++ Implemented Function Body.cc";
    private static final String CPP_OVERRIDDEN_FUNCTION_TEMPLATE_NAME = "C++ Overridden Function Body.cc";
    private static final String CONTAINING_CLASS_TEMPLATE_PROPERTY = "CONTAINING_CLASS";
    private static final String RETURN_TYPE_TEMPLATE_PROPERTY = "RETURN_TYPE";
    private static final String DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY = "DEFAULT_RETURN_VALUE";
    private static final String CALL_SUPER_TEMPLATE_PROPERTY = "CALL_SUPER";
    private static final String CUSTOM_CODE_TEMPLATE_PROPERTY = "CUSTOM_CODE";
    public static final String IVAR_IS_AVAILABLE_TEMPLATE_PROPERTY = "IVAR_IS_AVAILABLE";
    private static final String IVAR_TEMPLATE_PROPERTY = "IVAR";
    private static final String PARAM_TEMPLATE_PROPERTY = "PARAM";
    private static final String SETTER_SEMANTICS_TEMPLATE_PROPERTY = "SETTER_SEMANTICS";

    private OCCallableUtil() {
    }

    public static String methodText(@NotNull OCMethodSymbol baseMethod, String customCode, PsiElement context) {
        if (baseMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethod", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodText"));
        }
        return OCCallableUtil.methodText(baseMethod, null, OCCallableUtil.methodSignature(baseMethod, context), customCode, context);
    }

    public static String methodFromTemplate(@NotNull OCMethodSymbol baseMethod, String customTemplate, PsiElement context, @Nullable Map<String, String> customProperties) {
        if (baseMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethod", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodFromTemplate"));
        }
        OCType returnType = baseMethod.getReturnType().resolve(baseMethod.getContainingOCFile());
        return OCCallableUtil.methodText(baseMethod, returnType, customTemplate, OCCallableUtil.methodSignature(baseMethod, context), "", context, customProperties);
    }

    public static String methodFromTemplate(@NotNull OCMethodSymbol baseMethod, String customTemplate, String customCode, PsiElement context) {
        if (baseMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethod", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodFromTemplate"));
        }
        return OCCallableUtil.methodText(baseMethod, customTemplate, OCCallableUtil.methodSignature(baseMethod, context), customCode, context);
    }

    public static String methodWithSignature(@NotNull OCType returnType, String signature, PsiElement context) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodWithSignature"));
        }
        return OCCallableUtil.methodText(null, returnType, IMPLEMENTED_METHOD_TEMPLATE_NAME, signature, "", context, null);
    }

    public static String functionWithSignature(@NotNull OCType returnType, String signature, PsiElement context) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/jetbrains/cidr/lang/util/OCCallableUtil", "functionWithSignature"));
        }
        StringBuilder answer = new StringBuilder();
        answer.append(signature).append("{\n ");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance(context.getProject());
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME);
        if (bodyTemplate != null) {
            Properties templateProperties = new Properties(FileTemplateManager.getInstance(context.getProject()).getDefaultProperties());
            templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, returnType.getBestNameInContext(context));
            templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, returnType.getDefaultValue(context));
            try {
                answer.append(bodyTemplate.getText(templateProperties));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME)), e);
            }
        }
        answer.append("\n}\n");
        return answer.toString();
    }

    public static String methodWithSignature(@NotNull OCMethodSymbol baseMethod, String signature, String customCode, PsiElement context) {
        if (baseMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethod", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodWithSignature"));
        }
        return OCCallableUtil.methodText(baseMethod, null, signature, customCode, context);
    }

    public static String methodText(@NotNull OCMethodSymbol baseMethod, String customTemplate, String signature, String customCode, PsiElement context) {
        if (baseMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethod", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodText"));
        }
        OCType returnType = baseMethod.getReturnType().resolve(baseMethod.getContainingOCFile());
        return OCCallableUtil.methodText(baseMethod, returnType, customTemplate, signature, customCode, context, null);
    }

    public static String methodText(@NotNull String signature, @NotNull String body, @NotNull PsiElement context) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodText"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodText"));
        }
        StringBuilder answer = new StringBuilder();
        answer.append(signature);
        Project project = context.getProject();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        if (settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE) {
            answer.append(";");
        }
        answer.append("{\n ");
        answer.append(body);
        answer.append("\n}\n");
        return answer.toString();
    }

    private static String methodText(@Nullable OCMethodSymbol baseMethod, @NotNull OCType returnType, @Nullable String customTemplate, String signature, String customCode, @NotNull PsiElement context, @Nullable Map<String, String> customProperties) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodText"));
        }
        StringBuilder answer = new StringBuilder();
        answer.append(signature);
        Project project = context.getProject();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        if (settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE) {
            answer.append(";");
        }
        answer.append("{\n ");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance(project);
        OCPropertySymbol property = baseMethod != null ? baseMethod.getGeneratedFromProperty() : null;
        OCInstanceVariableSymbol ivar = property != null ? property.getAssociatedIvar() : null;
        OCClassDeclaration parentClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)context, OCClassDeclaration.class, (boolean)false);
        String templateName = property != null && ivar != null ? (baseMethod.isSetter() ? PROPERTY_SETTER_TEMPLATE_NAME : PROPERTY_GETTER_TEMPLATE_NAME) : (customTemplate != null && customTemplate != OVERRIDDEN_METHOD_TEMPLATE_NAME ? customTemplate : (baseMethod != null && OCElementUtil.startsWithWord(baseMethod.getName(), "init") ? OVERRIDDEN_INIT_METHOD_TEMPLATE_NAME : (baseMethod != null && baseMethod.getName().equals("isEqual:") ? OVERRIDDEN_IS_EQUAL_METHOD_TEMPLATE_NAME : (baseMethod != null && baseMethod.getName().equals("description") ? OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME2 : (baseMethod != null && baseMethod.getName().equals("copyWithZone:") ? OVERRIDDEN_COPY_TEMPLATE_NAME2 : (customTemplate != null ? customTemplate : OVERRIDDEN_METHOD_TEMPLATE_NAME))))));
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(templateName);
        if (bodyTemplate != null) {
            Properties templateProperties = new Properties(FileTemplateManager.getInstance(project).getDefaultProperties());
            if (customProperties != null) {
                for (Map.Entry<String, String> entry : customProperties.entrySet()) {
                    templateProperties.setProperty(entry.getKey(), entry.getValue());
                }
            }
            templateProperties.setProperty(CONTAINING_CLASS_TEMPLATE_PROPERTY, parentClass != null ? parentClass.getName() : "");
            templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, returnType.getBestNameInContext(context));
            templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, returnType.getDefaultValue(context));
            templateProperties.setProperty(CALL_SUPER_TEMPLATE_PROPERTY, OCCallableUtil.getCallSuperText(baseMethod, context));
            templateProperties.setProperty(CUSTOM_CODE_TEMPLATE_PROPERTY, customCode != null ? customCode : "");
            boolean arcEnabled = OCCompilerHelper.isArcEnabled(context.getContainingFile());
            if (property != null && ivar != null) {
                OCDeclaratorSymbol parameter;
                templateProperties.setProperty(IVAR_TEMPLATE_PROPERTY, ivar.getName());
                if (baseMethod.isSetter() && (parameter = baseMethod.getSelectors().get(0).getParameter()) != null) {
                    templateProperties.setProperty(PARAM_TEMPLATE_PROPERTY, OCNameSuggester.suggestUniqueName(parameter, context));
                }
                if (property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                    templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, arcEnabled ? "copyArc" : "copy");
                } else if (property.hasAttribute(OCPropertySymbol.PropertyAttribute.RETAIN) && !arcEnabled) {
                    templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, "retain");
                } else {
                    templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, "assign");
                }
            }
            try {
                if (baseMethod == null || !baseMethod.getName().equals("dealloc") || !arcEnabled) {
                    answer.append(bodyTemplate.getText(templateProperties));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
            }
        }
        answer.append("\n}\n");
        return answer.toString();
    }

    @NotNull
    public static String functionText(@NotNull OCFunctionSymbol function, @NotNull String signature, @NotNull PsiElement context, @Nullable OCFunctionSymbol overridingFunction) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/lang/util/OCCallableUtil", "functionText"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/jetbrains/cidr/lang/util/OCCallableUtil", "functionText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "functionText"));
        }
        String string = signature + "{\n " + OCCallableUtil.fillFunctionBodyTemplate(function, overridingFunction, context) + "\n}\n";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCallableUtil", "functionText"));
        }
        return string;
    }

    @NotNull
    private static String fillFunctionBodyTemplate(@NotNull OCFunctionSymbol function, @Nullable OCFunctionSymbol overridingFunction, @NotNull PsiElement context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/lang/util/OCCallableUtil", "fillFunctionBodyTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "fillFunctionBodyTemplate"));
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance(function.getProject());
        String templateName = overridingFunction != null ? CPP_OVERRIDDEN_FUNCTION_TEMPLATE_NAME : CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME;
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(templateName);
        OCType returnType = function.getEffectiveResolvedType();
        if (function.isCppConstructor() || function.isCppDestructor()) {
            returnType = OCVoidType.instance();
        }
        if (bodyTemplate != null) {
            String string;
            Properties templateProperties = new Properties(FileTemplateManager.getInstance(function.getProject()).getDefaultProperties());
            templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, returnType.getBestNameInContext(context));
            templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, returnType.getDefaultValue(context));
            if (overridingFunction != null) {
                templateProperties.setProperty(CALL_SUPER_TEMPLATE_PROPERTY, overridingFunction.getVisibility() != OCVisibility.PRIVATE ? OCCallableUtil.getBaseCallText(function, overridingFunction) : "");
            }
            try {
                string = bodyTemplate.getText(templateProperties);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCallableUtil", "fillFunctionBodyTemplate"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCallableUtil", "fillFunctionBodyTemplate"));
        }
        return "";
    }

    private static String getAdHocParameterName(String methodName, boolean isFirstParameter) {
        if (methodName.startsWith("isEqual") && isFirstParameter) {
            return "other";
        }
        if (methodName.equals("encodeWithCoder:") || methodName.equals("initWithCoder:")) {
            return "coder";
        }
        return null;
    }

    private static String getCallSuperText(@Nullable OCMethodSymbol baseMethod, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "getCallSuperText"));
        }
        if (baseMethod == null) {
            return "";
        }
        StringBuilder callSuper = new StringBuilder();
        callSuper.append("[super ");
        boolean first = true;
        for (OCMethodSymbol.SelectorPartSymbol part : baseMethod.getSelectors()) {
            if (!first) {
                callSuper.append(' ');
            }
            callSuper.append(part.getSelectorName()).append(' ');
            OCDeclaratorSymbol param = part.getParameter();
            if (param != null) {
                String parameterName = OCCallableUtil.getAdHocParameterName(baseMethod.getName(), first);
                if (parameterName != null) {
                    callSuper.append(parameterName);
                } else {
                    callSuper.append(OCNameSuggester.suggestUniqueName(param, context));
                }
            }
            first = false;
        }
        callSuper.append("]");
        return callSuper.toString();
    }

    private static String getBaseCallText(@NotNull OCFunctionSymbol override, @NotNull OCFunctionSymbol baseToCall) {
        if (override == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "override", "com/jetbrains/cidr/lang/util/OCCallableUtil", "getBaseCallText"));
        }
        if (baseToCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseToCall", "com/jetbrains/cidr/lang/util/OCCallableUtil", "getBaseCallText"));
        }
        if (baseToCall.isCppConstructor() || baseToCall.isCppDestructor()) {
            return "";
        }
        return baseToCall.getParent().getName() + "::" + OCCallableUtil.getBaseCallExpression(override, baseToCall);
    }

    private static String getBaseCallExpression(@NotNull OCFunctionSymbol override, @NotNull OCFunctionSymbol baseToCall) {
        OCDeclaratorSymbol param;
        OCType type;
        if (override == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "override", "com/jetbrains/cidr/lang/util/OCCallableUtil", "getBaseCallExpression"));
        }
        if (baseToCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseToCall", "com/jetbrains/cidr/lang/util/OCCallableUtil", "getBaseCallExpression"));
        }
        StringBuilder callSuper = new StringBuilder();
        callSuper.append(baseToCall.getName()).append("(");
        boolean first = true;
        Iterator<OCDeclaratorSymbol> iterator = override.getParameterSymbols().iterator();
        while (iterator.hasNext() && !((type = (param = iterator.next()).getType()) instanceof OCEllipsisType) && !(type instanceof OCVoidType)) {
            if (!first) {
                callSuper.append(",");
            }
            callSuper.append(param.getName());
            first = false;
        }
        callSuper.append(")");
        return callSuper.toString();
    }

    @NotNull
    public static String methodSignature(OCMethodSymbol method, PsiElement context) {
        StringBuilder answer = new StringBuilder();
        answer.append(method.isStatic() ? (char)'+' : '-');
        answer.append('(');
        if (method.getReturnType().isVoid() && method.hasAttribute("ibaction")) {
            answer.append("IBAction");
        } else {
            answer.append(method.getReturnType().getBestNameInContext(context, OCElementUtil.getReturnTypeText(method)));
        }
        answer.append(')');
        boolean first = true;
        for (OCMethodSymbol.SelectorPartSymbol part : method.getSelectors()) {
            if (!first) {
                answer.append(' ');
            }
            answer.append(part.getSelectorName());
            OCDeclaratorSymbol param = part.getParameter();
            if (param != null) {
                OCType type = param.getType();
                answer.append('(').append(type.getBestNameInContext(context, OCElementUtil.getTypeTextWithModifiers(param))).append(')');
                String parameterName = OCCallableUtil.getAdHocParameterName(method.getName(), first);
                if (parameterName != null) {
                    answer.append(parameterName);
                } else {
                    answer.append(OCNameSuggester.suggestUniqueName(param, context));
                }
            }
            first = false;
        }
        if (method.isVararg()) {
            answer.append(",...");
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCallableUtil", "methodSignature"));
        }
        return string;
    }

    @NotNull
    public static String exactFunctionSignature(@NotNull OCFunctionSymbol function, @NotNull String qualifier, @NotNull PsiElement context) {
        OCTypeElement trailingType;
        OCTemplateParameterList templateParameterList;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/lang/util/OCCallableUtil", "exactFunctionSignature"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/cidr/lang/util/OCCallableUtil", "exactFunctionSignature"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "exactFunctionSignature"));
        }
        StringBuilder answer = new StringBuilder();
        OCFunctionDeclaration funDefinition = function.locateFunctionDefinition();
        OCTemplateParameterList oCTemplateParameterList = templateParameterList = funDefinition != null ? funDefinition.getTemplateParameterList() : null;
        if (templateParameterList != null) {
            answer.append("template");
            answer.append(templateParameterList.getTextWithMacros());
            answer.append(' ');
        }
        if (function.isConstexpr()) {
            answer.append("constexpr ");
        }
        if (function.isVirtual()) {
            answer.append("virtual ");
        }
        if (function.isFriendFunction()) {
            answer.append("friend ");
        }
        if (function.isStatic() && !function.isFriendFunction()) {
            answer.append("static ");
        }
        if (function.isExplicit()) {
            answer.append("explicit ");
        }
        if (!(function.isCppConstructor() || function.isCppDestructor() || function.isCppConversionOperator())) {
            answer.append(function.getEffectiveResolvedType().getBestNameInContext(context, OCElementUtil.getReturnTypeTextWithModifiers(function)));
            answer.append(' ');
        }
        answer.append(qualifier);
        answer.append(function.getName());
        answer.append('(');
        boolean isFirstParam = true;
        for (OCDeclaratorSymbol param : function.getParameterSymbols()) {
            OCType type;
            if (!isFirstParam) {
                answer.append(", ");
            }
            if ((type = param.getType()) instanceof OCEllipsisType || type instanceof OCVoidType || param.isUnnamed()) {
                answer.append(type.getBestNameInContext(context, OCElementUtil.getTypeTextWithModifiers(param)));
            } else {
                answer.append(OCElementFactory.declarationText(param.getName(), type, OCElementUtil.getTypeTextWithModifiers(param), context));
            }
            isFirstParam = false;
        }
        answer.append(')');
        function.getType().getCVQualifiers().appendCVQualifiers(answer);
        if (function.isOverride()) {
            answer.append(" override");
        }
        if (function.isFinal()) {
            answer.append(" final");
        }
        if (function.isPureVirtual()) {
            answer.append(" = 0");
        }
        if (function.isDefault()) {
            answer.append(" = default");
        }
        if (function.isDelete()) {
            answer.append(" = delete");
        }
        if (funDefinition != null && (trailingType = funDefinition.getTrailingReturnTypeElement()) != null) {
            answer.append(" -> ").append(trailingType.getType().resolve(context.getContainingFile()).getBestNameInContext(context, trailingType.getTextWithMacros()));
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCallableUtil", "exactFunctionSignature"));
        }
        return string;
    }

    @NotNull
    public static String getFunctionParentQualifier(@NotNull OCFunctionSymbol function, @NotNull PsiElement context, boolean isFriend) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/lang/util/OCCallableUtil", "getFunctionParentQualifier"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "getFunctionParentQualifier"));
        }
        String parentName = "";
        final OCSymbolWithQualifiedName functionParent = function.getParent();
        if (functionParent instanceof OCNamespaceSymbol) {
            boolean isCorrectScope = false;
            OCSymbolDeclarator parent = (OCSymbolDeclarator)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class});
            while (parent != null) {
                OCNamespaceSymbol parentSymbol = (OCNamespaceSymbol)parent.getSymbol();
                if (parentSymbol != null && (functionParent.isSameSymbol(parentSymbol) || parentSymbol instanceof OCStructSymbol && !((OCStructSymbol)parentSymbol).processAllBaseClasses(new OCStructSymbol.BaseClassProcessor(){

                    @Override
                    public boolean process(OCSymbol symbol, OCVisibility visibility) {
                        return !functionParent.equals(symbol);
                    }
                }))) {
                    isCorrectScope = true;
                }
                parent = (OCSymbolDeclarator)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class});
            }
            if (!isCorrectScope) {
                if (functionParent instanceof OCStructSymbol) {
                    parentName = functionParent.getType().getBestNameInContext(context);
                    if (isFriend) {
                        OCSymbolWithQualifiedName parentNamespace;
                        for (parentNamespace = functionParent.getParent(); parentNamespace != null && parentNamespace.getKind() != OCSymbolKind.NAMESPACE; parentNamespace = parentNamespace.getParent()) {
                        }
                        parentName = parentNamespace != null ? parentNamespace.getResolvedQualifiedName().getNameWithParent() : "";
                    }
                } else {
                    OCQualifiedName qualifiedName = functionParent.getResolvedQualifiedName();
                    parentName = qualifiedName != null ? qualifiedName.getCanonicalName(true) : functionParent.getName();
                }
            }
        }
        String string = parentName.isEmpty() ? parentName : parentName + "::";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCallableUtil", "getFunctionParentQualifier"));
        }
        return string;
    }

    @NotNull
    public static String exactFunctionText(@NotNull OCFunctionSymbol function, @Nullable OCFunctionSymbol baseToCall, boolean isDefinition, @NotNull String qualifier, @NotNull PsiElement context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/lang/util/OCCallableUtil", "exactFunctionText"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/cidr/lang/util/OCCallableUtil", "exactFunctionText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "exactFunctionText"));
        }
        StringBuilder answer = new StringBuilder(OCCallableUtil.exactFunctionSignature(function, qualifier, context));
        if (isDefinition) {
            if (function.isCppConstructor() && baseToCall != null) {
                answer.append(':');
                answer.append(OCCallableUtil.getBaseCallExpression(function, baseToCall));
            }
            answer.append("{\n ");
            answer.append(OCCallableUtil.fillFunctionBodyTemplate(function, baseToCall, context));
            answer.append("\n}\n");
        } else {
            answer.append(";\n");
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCallableUtil", "exactFunctionText"));
        }
        return string;
    }

    @NotNull
    public static String functionSignature(@NotNull OCFunctionSymbol function, boolean appendDeclaratorAttributes, @NotNull PsiElement context) {
        OCTypeElement trailingType;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/lang/util/OCCallableUtil", "functionSignature"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "functionSignature"));
        }
        OCFunctionDeclaration funDefinition = function.locateFunctionDefinition();
        OCTemplateParameterList templateParameterList = funDefinition != null ? funDefinition.getTemplateParameterList() : null;
        StringBuilder answer = new StringBuilder();
        if (templateParameterList != null) {
            answer.append("template");
            answer.append(templateParameterList.getTextWithMacros());
        }
        if (!function.isCppConstructor()) {
            if (appendDeclaratorAttributes && function.isStatic()) {
                answer.append("static ");
            }
            if (appendDeclaratorAttributes && function.isVirtual()) {
                answer.append("virtual ");
            }
        }
        if (!(function.isCppConstructor() || function.isCppDestructor() || function.isCppConversionOperator())) {
            answer.append(function.getEffectiveResolvedType().getBestNameInContext(context, OCElementUtil.getReturnTypeTextWithModifiers(function)));
            answer.append(' ');
        }
        answer.append(OCCallableUtil.getFunctionParentQualifier(function, context, function.isFriendFunction()));
        answer.append(function.getName());
        boolean isFirstParam = true;
        answer.append('(');
        ArrayList<String> createdNames = new ArrayList<String>();
        for (OCDeclaratorSymbol param : function.getParameterSymbols()) {
            OCType type;
            if (!isFirstParam) {
                answer.append(", ");
            }
            if ((type = param.getType()) instanceof OCEllipsisType || type instanceof OCVoidType) {
                answer.append(type.getBestNameInContext(context, OCElementUtil.getTypeTextWithModifiers(param)));
            } else {
                Collection<String> suggestedNames;
                String paramName = param.isUnnamed() ? ((suggestedNames = OCNameSuggester.suggestForType(type, context, createdNames)).isEmpty() ? "param" : suggestedNames.iterator().next()) : param.getName();
                createdNames.add(paramName);
                answer.append(OCElementFactory.declarationText(paramName, type, OCElementUtil.getTypeTextWithModifiers(param), context));
            }
            isFirstParam = false;
        }
        answer.append(')');
        function.getType().getCVQualifiers().appendCVQualifiers(answer);
        if (funDefinition != null && (trailingType = funDefinition.getTrailingReturnTypeElement()) != null) {
            answer.append("->").append(trailingType.getType().resolve(context.getContainingFile()).getBestNameInContext(context, trailingType.getTextWithMacros()));
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCallableUtil", "functionSignature"));
        }
        return string;
    }

    public static String getNewFunctionName(OCFunctionSymbol member, OCSymbolWithQualifiedName parent) {
        String newName = parent != null && member.isCppConstructor() ? parent.getName() : (parent != null && member.isCppDestructor() ? "~" + parent.getName() : member.getName());
        return newName;
    }

    @NotNull
    public static OCFunctionSymbol createOverridingFunction(@NotNull OCFunctionSymbol base, @Nullable OCNamespaceSymbol newParent, @NotNull PsiElement context, @Nullable OCVisibility visibility, boolean isInsideClass, boolean insertOverride) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/jetbrains/cidr/lang/util/OCCallableUtil", "createOverridingFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/util/OCCallableUtil", "createOverridingFunction"));
        }
        int newAttributes = base.getFunctionAttributes();
        newAttributes &= 0xFFFFFBFF;
        if (isInsideClass) {
            if (!base.isCppConstructor()) {
                newAttributes |= 2;
            }
            if (insertOverride && !base.isCppConstructor() && !base.isCppDestructor()) {
                newAttributes |= 0x2000;
            } else if (!insertOverride) {
                newAttributes &= 0xFFFFDFFF;
            }
        } else {
            newAttributes &= 0xFFFFC9C1;
        }
        List<OCDeclaratorSymbol> oldParamSymbols = base.getParameterSymbols();
        ArrayList<OCDeclaratorSymbol> newParamSymbols = new ArrayList<OCDeclaratorSymbol>(oldParamSymbols.size());
        ArrayList<String> createdNames = new ArrayList<String>();
        for (OCDeclaratorSymbol param : oldParamSymbols) {
            Collection<String> suggestedNames;
            String paramName = param.isUnnamed() ? ((suggestedNames = OCNameSuggester.suggestForType(param.getType(), context, createdNames)).isEmpty() ? "param" : suggestedNames.iterator().next()) : param.getName();
            createdNames.add(paramName);
            newParamSymbols.add(new OCDeclaratorSymbol(param, param.getSubstitution(), OCQualifiedName.with(param.getQualifier(), paramName), null, new OCResolveContext(context)));
        }
        OCFunctionSymbol oCFunctionSymbol = new OCFunctionSymbol(base.getProject(), base.getContainingFile(), base.getOffset(), newParent, OCQualifiedName.with(null, OCCallableUtil.getNewFunctionName(base, newParent)), base.getTemplateParameters(), newAttributes, base.getAttributes(), base.getType(), newParamSymbols, base.getKind(), visibility);
        if (oCFunctionSymbol == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/util/OCCallableUtil", "createOverridingFunction"));
        }
        return oCFunctionSymbol;
    }
}

