/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.ui.OCSymbolTextFieldCompletionProvider;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTextFieldWithSymbolAutoCompletion
extends TextFieldWithAutoCompletion<OCSymbol> {
    private final ProgressIndicator myMainCollectionProgress;

    public OCTextFieldWithSymbolAutoCompletion(@NotNull Project project, @NotNull TextFieldWithAutoCompletionListProvider<OCSymbol> provider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion", "<init>"));
        }
        this(project, provider, null);
    }

    public OCTextFieldWithSymbolAutoCompletion(@NotNull Project project, @NotNull TextFieldWithAutoCompletionListProvider<OCSymbol> provider, @Nullable ProgressIndicator mainCollectionProgress) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion", "<init>"));
        }
        super(project, provider, false, null);
        this.myMainCollectionProgress = mainCollectionProgress;
    }

    public static OCTextFieldWithSymbolAutoCompletion create(@NotNull Project project, boolean topLevelOnly, @Nullable Condition<OCSymbol> condition) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion", "create"));
        }
        return OCTextFieldWithSymbolAutoCompletion.create(project, topLevelOnly, null, condition, null);
    }

    public static OCTextFieldWithSymbolAutoCompletion create(final @NotNull Project project, final boolean topLevelOnly, @Nullable Function<OCSymbol, String> nameMapper, final @Nullable Condition<OCSymbol> condition, final @Nullable ProcessListener myProcessListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion", "create"));
        }
        final CountDownLatch collectionFinished = new CountDownLatch(1);
        final OCSymbolTextFieldCompletionProvider provider = new OCSymbolTextFieldCompletionProvider(nameMapper){
            private static final int THRESHOLD_LENGTH = 2;
            private int startedEventsCount;

            @NotNull
            private Collection<OCSymbol> collectItemsForPrefix(final @Nullable String prefix, CompletionParameters parameters) {
                ProgressIndicator prefixIndicator;
                final Ref prefixResult = Ref.create();
                if (prefix != null && prefix.length() > 2) {
                    prefixIndicator = OCTextFieldWithSymbolAutoCompletion.createIndicator();
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            Collection result2 = (Collection)ProgressManager.getInstance().runProcess((Computable)new Computable<Collection<OCSymbol>>(){

                                public Collection<OCSymbol> compute() {
                                    final PrefixMatcher matcher = this.createPrefixMatcher(prefix);
                                    return this.collectSymbols(project, topLevelOnly, new Condition<OCSymbol>(){

                                        public boolean value(OCSymbol symbol) {
                                            return matcher.prefixMatches(symbol.getName()) && (condition == null || condition.value((Object)symbol));
                                        }
                                    });
                                }
                            }, prefixIndicator);
                            prefixResult.set((Object)result2);
                        }
                    });
                } else {
                    prefixIndicator = null;
                }
                while (true) {
                    Collection<OCSymbol> collection;
                    ProgressManager.checkCanceled();
                    if (!prefixResult.isNull()) {
                        Collection collection2 = (Collection)prefixResult.get();
                        if (collection2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion$1", "collectItemsForPrefix"));
                        }
                        return collection2;
                    }
                    try {
                        if (!collectionFinished.await(100L, TimeUnit.MILLISECONDS)) continue;
                        if (prefixIndicator != null) {
                            prefixIndicator.cancel();
                        }
                        collection = super.getItems(prefix, false, parameters);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion$1", "collectItemsForPrefix"));
                    }
                    return collection;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            public Collection<OCSymbol> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                Collection<OCSymbol> collection;
                block7: {
                    Collection<OCSymbol> cachedItems = super.getItems(prefix, cached, parameters);
                    if (!cachedItems.isEmpty() || cached) {
                        Collection<OCSymbol> collection2 = cachedItems;
                        if (collection2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion$1", "getItems"));
                        }
                        return collection2;
                    }
                    if (myProcessListener != null) {
                        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (startedEventsCount++ == 0) {
                                    myProcessListener.onStarted();
                                }
                            }
                        });
                    }
                    try {
                        collection = this.collectItemsForPrefix(prefix, parameters);
                        if (myProcessListener == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (myProcessListener != null) {
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (startedEventsCount-- > 0) {
                                        myProcessListener.onFinished();
                                    }
                                }
                            });
                        }
                        throw throwable;
                    }
                    UIUtil.invokeLaterIfNeeded((Runnable)new /* invalid duplicate definition of identical inner class */);
                }
                Collection<OCSymbol> collection3 = collection;
                if (collection3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCTextFieldWithSymbolAutoCompletion$1", "getItems"));
                }
                return collection3;
            }
        };
        final ProgressIndicator progress = OCTextFieldWithSymbolAutoCompletion.createIndicator();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    @Override
                    public void run() {
                        Collection<Object> finalItems;
                        Collection<Object> items = ContainerUtil.emptyList();
                        try {
                            finalItems = items = provider.collectSymbols(project, topLevelOnly, (Condition<OCSymbol>)condition);
                        }
                        catch (Throwable throwable) {
                            List finalItems2 = items;
                            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(finalItems2){
                                final /* synthetic */ Collection val$finalItems;
                                {
                                    this.val$finalItems = collection;
                                }

                                @Override
                                public void run() {
                                    provider.setItems(this.val$finalItems);
                                }
                            });
                            collectionFinished.countDown();
                            throw throwable;
                        }
                        UIUtil.invokeAndWaitIfNeeded((Runnable)new /* invalid duplicate definition of identical inner class */);
                        collectionFinished.countDown();
                    }
                }, progress);
            }
        });
        return new OCTextFieldWithSymbolAutoCompletion(project, provider, progress);
    }

    private static ProgressIndicator createIndicator() {
        ProgressIndicator mainIndicator = ProgressManager.getInstance().getProgressIndicator();
        return mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new ProgressIndicatorBase();
    }

    public void cancelRunningTasks() {
        if (this.myMainCollectionProgress != null) {
            this.myMainCollectionProgress.cancel();
        }
    }

    public static interface ProcessListener {
        public void onStarted();

        public void onFinished();
    }
}

