/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveLanguageAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationAdapter;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveContextPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    public static final String ID = "ActiveOCBuildConfiguration";
    private final TextPanel myComponent;
    private volatile boolean myActionEnabled;
    private volatile boolean myHasList;
    private JLabel myArrowsIcon;
    private final AsyncProcessIcon myRepoActivityIcon;
    private ProgressIndicator myCurrentProgress;

    @NotNull
    private static AsyncProcessIcon createActivityIcon(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "createActivityIcon"));
        }
        AsyncProcessIcon icon = new AsyncProcessIcon(name).setUseMask(false);
        icon.setPaintPassiveIcon(false);
        icon.setOpaque(false);
        icon.suspend();
        AsyncProcessIcon asyncProcessIcon = icon;
        if (asyncProcessIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "createActivityIcon"));
        }
        return asyncProcessIcon;
    }

    public OCResolveContextPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "<init>"));
        }
        super(project);
        this.myArrowsIcon = new JLabel(AllIcons.Ide.Statusbar_arrows);
        this.myRepoActivityIcon = OCResolveContextPanel.createActivityIcon("Resolve Context Activity");
        this.myComponent = new TextPanel(){

            @Override
            public void doLayout() {
                super.doLayout();
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                Dimension aSize = OCResolveContextPanel.this.myRepoActivityIcon.getMinimumSize();
                int aWidth = (int)aSize.getWidth();
                int aHeight = (int)aSize.getHeight();
                OCResolveContextPanel.this.myRepoActivityIcon.setBounds(r.width - insets.right - aWidth, r.height / 2 - aHeight / 2, aWidth, aHeight);
                Icon icon = OCResolveContextPanel.this.myArrowsIcon.getIcon();
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                OCResolveContextPanel.this.myArrowsIcon.setBounds(r.width - insets.right - iconWidth - 2, r.height / 2 - iconHeight / 2, iconWidth, iconHeight);
            }
        };
        this.myComponent.add(this.myArrowsIcon);
        this.myComponent.add((Component)this.myRepoActivityIcon);
        this.myComponent.setRightPadding((int)(this.myRepoActivityIcon.getMinimumSize().getWidth() + 6.0));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$2", "onClick"));
                }
                if (OCResolveContextPanel.this.myHasList) {
                    OCResolveContextPanel.this.showPopup(e);
                }
                return true;
            }
        }.installOn((Component)this.myComponent);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        this.myConnection.subscribe(OCWorkspaceModificationListener.TOPIC, (Object)new OCWorkspaceModificationAdapter(){

            @Override
            public void somethingChanged() {
                OCResolveContextPanel.this.scheduleUpdate();
            }
        });
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                OCResolveContextPanel.this.scheduleUpdate();
            }

            public void exitDumbMode() {
                OCResolveContextPanel.this.scheduleUpdate();
            }
        });
        this.scheduleUpdate();
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "selectionChanged"));
        }
        this.scheduleUpdate();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "fileOpened"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "fileOpened"));
        }
        this.scheduleUpdate();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "fileClosed"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "fileClosed"));
        }
        this.scheduleUpdate();
    }

    public StatusBarWidget copy() {
        return new OCResolveContextPanel(this.myProject);
    }

    @NotNull
    public String ID() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "ID"));
        }
        return ID;
    }

    public TextPanel getComponent() {
        return this.myComponent;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "getPresentation"));
        }
        return null;
    }

    private void showPopup(MouseEvent e) {
        ListPopup popup = this.getPopupStep(DataManager.getInstance().getDataContext((Component)this.myStatusBar));
        if (popup == null) {
            return;
        }
        Dimension dimension = popup.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup.show(new RelativePoint(e.getComponent(), at));
        Disposer.register((Disposable)this, (Disposable)popup);
    }

    public ListPopup getPopupStep(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "getPopupStep"));
        }
        VirtualFile file2 = this.getSelectedFile();
        if (file2 == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (!OCResolveContextPanel.isAppropriateFile(psiFile)) {
            return null;
        }
        Pair<Collection<? extends OCResolveConfiguration>, Boolean> configurations = OCResolveContextPanel.getFileConfigurations(psiFile, true, null);
        DefaultActionGroup group = new DefaultActionGroup();
        if (!((Boolean)configurations.second).booleanValue()) {
            group.addSeparator("All project contexts are listed");
        }
        for (OCResolveConfiguration config : (Collection)configurations.first) {
            group.add((AnAction)new ConfigurationItem(psiFile, config));
        }
        final OCResolveConfiguration selected = OCInclusionContextUtil.getOrCalculateParsedResolveLanguageAndConfiguration(psiFile).getConfiguration();
        ListPopup list = JBPopupFactory.getInstance().createActionGroupPopup("Available resolve contexts", (ActionGroup)group, context, false, false, false, null, 15, (Condition)new Condition<AnAction>(){

            public boolean value(AnAction action) {
                return ((ConfigurationItem)action).getConfig() == selected;
            }
        });
        list.setAdText("File will be resolved in the selected context", 10);
        return list;
    }

    private void scheduleReParse(final PsiFile psiFile, final OCResolveConfiguration config) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                OCInclusionContextUtil.setUserSelectedConfiguration(psiFile, config);
                OCResolveContextPanel.this.scheduleUpdate();
            }
        });
    }

    public void scheduleUpdate() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile;
                VirtualFile file2;
                if (OCResolveContextPanel.this.myCurrentProgress != null) {
                    OCResolveContextPanel.this.myCurrentProgress.cancel();
                }
                if (OCResolveContextPanel.this.isDisposed()) {
                    return;
                }
                if (!OCResolveContextPanel.this.isDumbMode() && (file2 = OCResolveContextPanel.this.getSelectedFile()) != null && file2.isValid() && OCResolveContextPanel.isAppropriateFile(psiFile = PsiManager.getInstance((Project)OCResolveContextPanel.this.myProject).findFile(file2))) {
                    OCResolveContextPanel.this.myCurrentProgress = (ProgressIndicator)new EmptyProgressIndicator();
                    OCResolveContextPanel.this.updateUI(file2, null, false, false, null, true);
                    OCResolveContextPanel.this.scheduleReloadFileContexts(file2, psiFile, OCResolveContextPanel.this.myCurrentProgress);
                    return;
                }
                OCResolveContextPanel.this.updateUI(null, null, false, false, null, false);
            }
        });
    }

    private static boolean isAppropriateFile(PsiFile psiFile) {
        return psiFile instanceof OCConfigurationOwner;
    }

    private void scheduleReloadFileContexts(final @NotNull VirtualFile file2, final @NotNull PsiFile psiFile, final @NotNull ProgressIndicator globalProgress) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "scheduleReloadFileContexts"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "scheduleReloadFileContexts"));
        }
        if (globalProgress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalProgress", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "scheduleReloadFileContexts"));
        }
        final SensitiveProgressWrapper progress = new SensitiveProgressWrapper(globalProgress);
        final ReadTask task = new ReadTask(){

            @Override
            public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$8", "computeInReadAction"));
                }
                if (OCResolveContextPanel.this.isDisposed() || OCResolveContextPanel.this.myProject.isDisposed()) {
                    return;
                }
                if (!psiFile.isValid() || OCResolveContextPanel.this.isDumbMode()) {
                    OCResolveContextPanel.this.updateUI(file2, null, false, false, null, false);
                    return;
                }
                progress.checkCanceled();
                OCResolveLanguageAndConfiguration langAndConfig = OCInclusionContextUtil.getOrCalculateParsedResolveLanguageAndConfiguration(psiFile);
                OCResolveConfiguration config = langAndConfig.getConfiguration();
                OCLanguageKind kind = langAndConfig.getLanguageKind();
                progress.checkCanceled();
                OCResolveContextPanel.this.updateUI(file2, config, false, false, kind, true);
                Collection cs = (Collection)OCResolveContextPanel.getFileConfigurations((PsiFile)psiFile, (boolean)false, (ProgressIndicator)progress).first;
                progress.checkCanceled();
                if (cs.size() > 0 && !cs.contains(config)) {
                    OCResolveContextPanel.this.scheduleReParse(psiFile, (OCResolveConfiguration)ContainerUtil.getFirstItem((Collection)cs));
                } else {
                    OCResolveContextPanel.this.updateUI(file2, config, config != null, cs.size() > 1, kind, false);
                }
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$8", "onCanceled"));
                }
                if (!globalProgress.isCanceled()) {
                    OCResolveContextPanel.this.scheduleReloadFileContexts(file2, psiFile, globalProgress);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    task.computeInReadAction(globalProgress);
                }
            });
        } else {
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(progress, task);
        }
    }

    private void updateUI(final @Nullable VirtualFile file2, final @Nullable OCResolveConfiguration config, final boolean actionsEnabled, final boolean hasMoreConfigs, final @Nullable OCLanguageKind kind, final boolean isLoading) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (file2 != null && !Comparing.equal((Object)OCResolveContextPanel.this.getSelectedFile(), (Object)file2)) {
                    return;
                }
                OCResolveContextPanel.this.myActionEnabled = actionsEnabled;
                OCResolveContextPanel.this.myHasList = actionsEnabled && hasMoreConfigs;
                Pair titleWithDescription = OCResolveContextPanel.getTitleWithDescription(config, kind, OCResolveContextPanel.this.isDumbMode());
                String title = (String)titleWithDescription.first;
                OCResolveContextPanel.this.myComponent.setText(title);
                OCResolveContextPanel.this.myComponent.setToolTipText((String)titleWithDescription.second);
                OCResolveContextPanel.this.myComponent.setForeground(OCResolveContextPanel.this.myActionEnabled ? UIUtil.getActiveTextColor() : UIUtil.getInactiveTextColor());
                if (OCResolveContextPanel.this.myStatusBar != null) {
                    OCResolveContextPanel.this.myStatusBar.updateWidget(OCResolveContextPanel.this.ID());
                }
                boolean haveTitle = title != null;
                OCResolveContextPanel.this.myArrowsIcon.setVisible(haveTitle && !isLoading && OCResolveContextPanel.this.myHasList);
                if (haveTitle && isLoading) {
                    OCResolveContextPanel.this.myRepoActivityIcon.resume();
                } else {
                    OCResolveContextPanel.this.myRepoActivityIcon.suspend();
                }
            }
        });
    }

    private boolean isDumbMode() {
        return DumbService.getInstance((Project)this.myProject).isDumb();
    }

    @NotNull
    private static Pair<String, String> getTitleWithDescription(@Nullable OCResolveConfiguration config, @Nullable OCLanguageKind kind, boolean dumb) {
        String description;
        String title;
        if (dumb) {
            title = "<not available>";
            description = ActionUtil.getUnavailableMessage((String)"Resolve context", (boolean)false);
        } else if (config == null) {
            title = "<no context>";
            description = "No resolve context for current file";
        } else {
            title = config.getDisplayName(true);
            description = "Current file is resolved in context of " + config.getDisplayName(false);
            if (kind != null) {
                description = description + " (" + kind.getDisplayName() + ")";
            }
        }
        Pair pair = Pair.create((Object)("Context: " + title), (Object)description);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "getTitleWithDescription"));
        }
        return pair;
    }

    @NotNull
    private static Pair<Collection<? extends OCResolveConfiguration>, Boolean> getFileConfigurations(@NotNull PsiFile psiFile, boolean sort, @Nullable ProgressIndicator progress) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "getFileConfigurations"));
        }
        boolean isDetermined = true;
        Collection<? extends OCResolveConfiguration> allConfigurations = OCInclusionContextUtil.getAllBuildConfigurationsForFile(psiFile, progress);
        if (allConfigurations.isEmpty()) {
            isDetermined = false;
            allConfigurations = OCWorkspaceManager.getWorkspace(psiFile.getProject()).getConfigurations();
        }
        if (!sort) {
            Pair pair = new Pair(allConfigurations, (Object)isDetermined);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "getFileConfigurations"));
            }
            return pair;
        }
        ArrayList<? extends OCResolveConfiguration> sorted = new ArrayList<OCResolveConfiguration>(allConfigurations);
        Collections.sort(sorted);
        Pair pair = new Pair(sorted, (Object)isDetermined);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel", "getFileConfigurations"));
        }
        return pair;
    }

    public class ConfigurationItem
    extends AnAction {
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final OCResolveConfiguration myConfig;

        public ConfigurationItem(@NotNull PsiFile file2, OCResolveConfiguration config) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$ConfigurationItem", "<init>"));
            }
            if (config == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$ConfigurationItem", "<init>"));
            }
            super(config.getDisplayName(false));
            this.myFile = file2;
            this.myConfig = config;
        }

        public void actionPerformed(AnActionEvent e) {
            OCResolveContextPanel.this.scheduleReParse(this.myFile, this.myConfig);
        }

        @NotNull
        public OCResolveConfiguration getConfig() {
            OCResolveConfiguration oCResolveConfiguration = this.myConfig;
            if (oCResolveConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$ConfigurationItem", "getConfig"));
            }
            return oCResolveConfiguration;
        }
    }
}

